/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.reader.page;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.page.AbstractAlignedPageReader;
import org.apache.tsfile.read.reader.page.LazyLoadPageData;
import org.apache.tsfile.read.reader.page.ValuePageReader;

public class TablePageReader
extends AbstractAlignedPageReader {
    public TablePageReader(PageHeader timePageHeader, ByteBuffer timePageData, Decoder timeDecoder, List<PageHeader> valuePageHeaderList, List<ByteBuffer> valuePageDataList, List<TSDataType> valueDataTypeList, List<Decoder> valueDecoderList, Filter globalTimeFilter) {
        super(timePageHeader, timePageData, timeDecoder, valuePageHeaderList, valuePageDataList, valueDataTypeList, valueDecoderList, globalTimeFilter);
    }

    public TablePageReader(PageHeader timePageHeader, ByteBuffer timePageData, Decoder timeDecoder, List<PageHeader> valuePageHeaderList, LazyLoadPageData[] lazyLoadPageDataArray, List<TSDataType> valueDataTypeList, List<Decoder> valueDecoderList, Filter globalTimeFilter) {
        super(timePageHeader, timePageData, timeDecoder, valuePageHeaderList, lazyLoadPageDataArray, valueDataTypeList, valueDecoderList, globalTimeFilter);
    }

    @Override
    public Statistics<? extends Serializable> getStatistics() {
        return this.timePageReader.getStatistics();
    }

    @Override
    boolean keepCurrentRow(boolean hasNotNullValues, long timestamp, Object[] rowValues) {
        return this.satisfyRecordFilter(timestamp, rowValues);
    }

    @Override
    boolean allPageDataSatisfy() {
        return !this.isModified && this.globalTimeFilterAllSatisfy() && this.pushDownFilterAllSatisfy();
    }

    @Override
    void constructResult(boolean[] keepCurrentRow, long[] timeBatch, boolean pushDownFilterAllSatisfy) throws IOException {
        int readEndIndex = this.buildTimeColumn(timeBatch, keepCurrentRow, pushDownFilterAllSatisfy);
        this.buildValueColumns(readEndIndex, keepCurrentRow, timeBatch);
    }

    private void buildValueColumns(int readEndIndex, boolean[] keepCurrentRow, long[] timeBatch) throws IOException {
        for (int i = 0; i < this.valueCount; ++i) {
            ValuePageReader pageReader = (ValuePageReader)this.valuePageReaderList.get(i);
            if (pageReader != null) {
                if (pageReader.isModified()) {
                    boolean[] isDeleted = new boolean[timeBatch.length];
                    pageReader.fillIsDeleted(timeBatch, isDeleted, keepCurrentRow);
                    pageReader.writeColumnBuilderWithNextBatch(readEndIndex, this.builder.getColumnBuilder(i), keepCurrentRow, isDeleted);
                    continue;
                }
                pageReader.writeColumnBuilderWithNextBatch(readEndIndex, this.builder.getColumnBuilder(i), keepCurrentRow);
                continue;
            }
            for (int j = 0; j < readEndIndex; ++j) {
                if (!keepCurrentRow[j]) continue;
                this.builder.getColumnBuilder(i).appendNull();
            }
        }
    }

    public void setDeleteIntervalList(List<TimeRange> timeDeletions, List<List<TimeRange>> valueDeletionsList) {
        this.timePageReader.setDeleteIntervalList(timeDeletions);
        for (int i = 0; i < this.valueCount; ++i) {
            if (this.valuePageReaderList.get(i) == null) continue;
            ((ValuePageReader)this.valuePageReaderList.get(i)).setDeleteIntervalList(valueDeletionsList.get(i));
        }
    }
}

