/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.table;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PreCreateTablePlan
extends ConfigPhysicalPlan {
    private String database;
    private TsTable table;

    public PreCreateTablePlan(ConfigPhysicalPlanType type) {
        super(type);
    }

    public PreCreateTablePlan(String database, TsTable table) {
        this(ConfigPhysicalPlanType.PreCreateTable, database, table);
    }

    public PreCreateTablePlan(ConfigPhysicalPlanType type, String database, TsTable table) {
        super(type);
        this.database = database;
        this.table = table;
    }

    public String getDatabase() {
        return this.database;
    }

    public TsTable getTable() {
        return this.table;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.database, (OutputStream)stream);
        this.table.serialize((OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.database = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.table = TsTable.deserialize((ByteBuffer)buffer);
    }
}

