/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.log;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryBlock;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipePeriodicalLogReducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePeriodicalLogReducer.class);
    private static final PipeMemoryBlock block = PipeDataNodeResourceManager.memory().tryAllocate(PipeConfig.getInstance().getPipeLoggerCacheMaxSizeInBytes());
    protected static final Cache<String, String> loggerCache = Caffeine.newBuilder().expireAfterWrite(PipeConfig.getInstance().getPipePeriodicalLogMinIntervalSeconds(), TimeUnit.SECONDS).weigher((k, v) -> Math.toIntExact(RamUsageEstimator.sizeOf((String)((String)k)) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY)).maximumWeight(block.getMemoryUsageInBytes()).build();

    public static boolean log(Consumer<String> loggerFunction, String rawMessage, Object ... formatter) {
        String loggerMessage = String.format(rawMessage, formatter);
        if (!loggerCache.asMap().containsKey(loggerMessage)) {
            loggerCache.put((Object)loggerMessage, (Object)loggerMessage);
            loggerFunction.accept(loggerMessage);
            return true;
        }
        return false;
    }

    public static void update() {
        loggerCache.policy().expireAfterWrite().ifPresent(time -> time.setExpiresAfter(PipeConfig.getInstance().getPipePeriodicalLogMinIntervalSeconds(), TimeUnit.SECONDS));
        PipeDataNodeResourceManager.memory().resize(block, PipeConfig.getInstance().getPipeLoggerCacheMaxSizeInBytes(), false);
        LOGGER.info("PipePeriodicalLogReducer is allocated to {} bytes.", (Object)block.getMemoryUsageInBytes());
        loggerCache.policy().eviction().ifPresent(eviction -> eviction.setMaximum(block.getMemoryUsageInBytes()));
    }

    private PipePeriodicalLogReducer() {
    }
}

