/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFTimeDifference
implements UDTF {
    private boolean hasPrevious = false;
    private long previousTime = 0L;

    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        configurations.setAccessStrategy((AccessStrategy)new RowByRowAccessStrategy()).setOutputDataType(Type.INT64);
    }

    public void transform(Row row, PointCollector collector) throws IOException {
        if (!this.hasPrevious) {
            this.previousTime = row.getTime();
            this.hasPrevious = true;
            return;
        }
        long currentTime = row.getTime();
        collector.putLong(currentTime, currentTime - this.previousTime);
        this.previousTime = currentTime;
    }
}

