/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.binary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.binary.BinaryTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public abstract class CompareBinaryTransformer
extends BinaryTransformer {
    protected final Evaluator evaluator;

    protected CompareBinaryTransformer(LayerReader leftReader, LayerReader rightReader) throws UnSupportedDataTypeException {
        super(leftReader, rightReader);
        this.evaluator = TSDataType.TEXT.equals((Object)this.leftReaderDataType) ? this.constructTextEvaluator() : this.constructNumberEvaluator();
    }

    protected abstract Evaluator constructNumberEvaluator();

    protected abstract Evaluator constructTextEvaluator();

    @Override
    protected final void checkType() {
        if (this.leftReaderDataType.equals((Object)this.rightReaderDataType)) {
            return;
        }
        if (this.leftReaderDataType.equals((Object)TSDataType.BOOLEAN) || this.rightReaderDataType.equals((Object)TSDataType.BOOLEAN)) {
            throw new UnSupportedDataTypeException(TSDataType.BOOLEAN.toString());
        }
        if (this.leftReaderDataType.equals((Object)TSDataType.TEXT) || this.rightReaderDataType.equals((Object)TSDataType.TEXT)) {
            throw new UnSupportedDataTypeException(TSDataType.TEXT.toString());
        }
    }

    @Override
    protected final void transformAndCache(Column leftValues, int leftIndex, Column rightValues, int rightIndex, ColumnBuilder builder) throws QueryProcessException, IOException {
        builder.writeBoolean(this.evaluator.evaluate(leftValues, leftIndex, rightValues, rightIndex));
    }

    @Override
    public TSDataType[] getDataTypes() {
        return new TSDataType[]{TSDataType.BOOLEAN};
    }

    @FunctionalInterface
    protected static interface Evaluator {
        public boolean evaluate(Column var1, int var2, Column var3, int var4) throws QueryProcessException, IOException;
    }
}

