/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.server.cluster.raft.serializer.CustomDeserializer;
import org.apache.seata.server.cluster.raft.serializer.JacksonSerializer;

@LoadLevel(name="JACKSON")
public class JacksonSerializer
implements Serializer {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public <T> byte[] serialize(T t) {
        try {
            JsonInfo jsonInfo = new JsonInfo(OBJECT_MAPPER.writeValueAsBytes(t), t.getClass());
            return OBJECT_MAPPER.writeValueAsBytes((Object)jsonInfo);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T deserialize(byte[] bytes) {
        try {
            JsonInfo jsonInfo = (JsonInfo)OBJECT_MAPPER.readValue(bytes, JsonInfo.class);
            return (T)OBJECT_MAPPER.readValue(jsonInfo.getObj(), jsonInfo.getClz());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Class.class, (JsonDeserializer)new CustomDeserializer());
        OBJECT_MAPPER.registerModule((Module)module);
    }
}

