/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http2.Http2Headers;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestParseUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestParseUtils.class);

    private RequestParseUtils() {
    }

    public static QueryParseResult parseQuery(String uri) {
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        return new QueryParseResult(decoder.path(), RequestParseUtils.deepCopyParameters(decoder.parameters()));
    }

    public static Map<String, List<String>> copyHeaders(HttpHeaders headers) {
        HashMap<String, List<String>> headerParams = new HashMap<String, List<String>>();
        for (Map.Entry entry : headers) {
            String key = (String)entry.getKey();
            headerParams.computeIfAbsent(key, k -> new ArrayList()).add((String)entry.getValue());
            String lowerKey = key != null ? key.toLowerCase(Locale.ROOT) : null;
            if (lowerKey == null || lowerKey.equals(key)) continue;
            headerParams.computeIfAbsent(lowerKey, k -> new ArrayList()).add((String)entry.getValue());
        }
        return headerParams;
    }

    public static Map<String, List<String>> copyHeaders(Http2Headers headers) {
        HashMap<String, List<String>> headerParams = new HashMap<String, List<String>>();
        for (Map.Entry entry : headers) {
            String key = ((CharSequence)entry.getKey()).toString();
            String value = ((CharSequence)entry.getValue()).toString();
            headerParams.computeIfAbsent(key, k -> new ArrayList()).add(value);
            String lowerKey = key.toLowerCase(Locale.ROOT);
            if (lowerKey.equals(key)) continue;
            headerParams.computeIfAbsent(lowerKey, k -> new ArrayList()).add(value);
        }
        return headerParams;
    }

    public static Map<String, List<String>> deepCopyParameters(Map<String, List<String>> source) {
        HashMap<String, List<String>> target = new HashMap<String, List<String>>();
        if (source == null) {
            return target;
        }
        source.forEach((key, values) -> {
            if (values != null) {
                target.put((String)key, new ArrayList(values));
            }
        });
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BodyParseResult parseBody(ObjectMapper objectMapper, FullHttpRequest request) {
        ObjectNode bodyNode;
        HashMap<String, List<String>> jsonParams;
        HashMap<String, List<String>> formParams;
        block15: {
            if (request == null || !request.content().isReadable()) {
                return BodyParseResult.empty();
            }
            String contentType = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            if (contentType == null) {
                return BodyParseResult.empty();
            }
            String lowerCaseContentType = contentType.toLowerCase(Locale.ROOT);
            String bodyString = request.content().toString(StandardCharsets.UTF_8);
            formParams = new HashMap<String, List<String>>();
            jsonParams = new HashMap<String, List<String>>();
            bodyNode = null;
            try {
                if (lowerCaseContentType.contains("application/json")) {
                    JsonNode node = objectMapper.readTree(bodyString);
                    if (node instanceof ObjectNode) {
                        bodyNode = (ObjectNode)node;
                        bodyNode.fields().forEachRemaining(entry -> jsonParams.computeIfAbsent((String)entry.getKey(), k -> new ArrayList()).add(((JsonNode)entry.getValue()).asText()));
                    }
                    break block15;
                }
                if (lowerCaseContentType.contains("application/x-www-form-urlencoded")) {
                    bodyNode = objectMapper.createObjectNode();
                    RequestParseUtils.decodeUrlEncoded(bodyString, formParams, bodyNode);
                    break block15;
                }
                if (!lowerCaseContentType.contains("multipart/form-data")) break block15;
                bodyNode = objectMapper.createObjectNode();
                HttpPostRequestDecoder decoder = null;
                try {
                    decoder = new HttpPostRequestDecoder((HttpRequest)request);
                    for (InterfaceHttpData data : decoder.getBodyHttpDatas()) {
                        if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
                        Attribute attr = (Attribute)data;
                        try {
                            String name = attr.getName();
                            String value = attr.getValue();
                            formParams.computeIfAbsent(name, k -> new ArrayList()).add(value);
                            bodyNode.put(name, value);
                        }
                        finally {
                            attr.release();
                        }
                    }
                }
                finally {
                    if (decoder != null) {
                        decoder.destroy();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse HTTP/1.x body: {}", (Object)e.getMessage());
            }
        }
        return new BodyParseResult(formParams, jsonParams, bodyNode);
    }

    public static BodyParseResult parseBody(ObjectMapper objectMapper, String body, Http2Headers headers) {
        if (body == null || body.isEmpty()) {
            return BodyParseResult.empty();
        }
        CharSequence contentTypeSeq = (CharSequence)headers.get((Object)HttpHeaderNames.CONTENT_TYPE);
        if (contentTypeSeq == null) {
            return BodyParseResult.empty();
        }
        String contentType = contentTypeSeq.toString();
        String lowerCaseContentType = contentType.toLowerCase(Locale.ROOT);
        HashMap<String, List<String>> formParams = new HashMap<String, List<String>>();
        HashMap<String, List<String>> jsonParams = new HashMap<String, List<String>>();
        ObjectNode bodyNode = null;
        try {
            if (lowerCaseContentType.contains("application/json")) {
                JsonNode node = objectMapper.readTree(body);
                if (node instanceof ObjectNode) {
                    bodyNode = (ObjectNode)node;
                    bodyNode.fields().forEachRemaining(entry -> jsonParams.computeIfAbsent((String)entry.getKey(), k -> new ArrayList()).add(((JsonNode)entry.getValue()).asText()));
                }
            } else if (lowerCaseContentType.contains("application/x-www-form-urlencoded")) {
                bodyNode = objectMapper.createObjectNode();
                RequestParseUtils.decodeUrlEncoded(body, formParams, bodyNode);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to parse HTTP/2 body: {}", (Object)e.getMessage());
        }
        return new BodyParseResult(formParams, jsonParams, bodyNode);
    }

    private static void decodeUrlEncoded(String body, Map<String, List<String>> formParams, ObjectNode bodyNode) {
        String[] pairs;
        if (body == null || body.isEmpty()) {
            return;
        }
        for (String pair : pairs = body.split("&")) {
            String[] kv = pair.split("=", 2);
            if (kv.length != 2) continue;
            String key = RequestParseUtils.decodeComponent(kv[0]);
            String value = RequestParseUtils.decodeComponent(kv[1]);
            formParams.computeIfAbsent(key, k -> new ArrayList()).add(value);
            bodyNode.put(key, value);
        }
    }

    private static String decodeComponent(String value) {
        try {
            return URLDecoder.decode(value, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to decode form field: {}", (Object)value);
            return value;
        }
    }

    public static final class QueryParseResult {
        private final String path;
        private final Map<String, List<String>> parameters;

        QueryParseResult(String path, Map<String, List<String>> parameters) {
            this.path = path;
            this.parameters = parameters;
        }

        public String getPath() {
            return this.path;
        }

        public Map<String, List<String>> getParameters() {
            return this.parameters;
        }
    }

    public static final class BodyParseResult {
        private final Map<String, List<String>> formParams;
        private final Map<String, List<String>> jsonParams;
        private final ObjectNode bodyNode;

        BodyParseResult(Map<String, List<String>> formParams, Map<String, List<String>> jsonParams, ObjectNode bodyNode) {
            this.formParams = formParams;
            this.jsonParams = jsonParams;
            this.bodyNode = bodyNode;
        }

        public static BodyParseResult empty() {
            return new BodyParseResult(new HashMap<String, List<String>>(), new HashMap<String, List<String>>(), null);
        }

        public Map<String, List<String>> getFormParams() {
            return this.formParams;
        }

        public Map<String, List<String>> getJsonParams() {
            return this.jsonParams;
        }

        public ObjectNode getBodyNode() {
            return this.bodyNode;
        }
    }
}

