/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.RandomAccess;
import org.apache.fory.Fory;
import org.apache.fory.annotation.Internal;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.serializer.collection.CollectionSerializer;

@Internal
public final class ForyArrayAsListSerializer
extends CollectionSerializer<ArrayAsList> {
    public ForyArrayAsListSerializer(Fory fory) {
        super(fory, ArrayAsList.class, true);
    }

    @Override
    public Collection newCollection(MemoryBuffer buffer) {
        int numElements = buffer.readVarUint32Small7();
        this.setNumElements(numElements);
        return new ArrayAsList(numElements);
    }

    @Internal
    public static class ArrayAsList
    extends AbstractList<Object>
    implements RandomAccess,
    Serializable {
        private static final Object[] EMPTY = new Object[0];
        private Object[] array;
        private int size;

        public ArrayAsList(int size) {
            this.array = new Object[size];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(Object e) {
            this.array[this.size++] = e;
            return true;
        }

        @Override
        public Object get(int index) {
            return this.array[index];
        }

        public void clearArray() {
            this.size = 0;
            this.array = EMPTY;
        }

        public void setArray(Object[] a) {
            this.array = a;
            this.size = a.length;
        }

        public Object[] getArray() {
            return this.array;
        }

        @Override
        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            return this.array;
        }

        @Override
        public Iterator<Object> iterator() {
            return new Iterator<Object>(){
                private int index;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Object next() {
                    return array[this.index++];
                }
            };
        }
    }
}

