/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.fory.Fory;
import org.apache.fory.annotation.ForyField;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.collection.Tuple3;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.reflect.FieldAccessor;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.RefResolver;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.serializer.SerializationBinding;
import org.apache.fory.serializer.SerializationUtils;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.type.Descriptor;
import org.apache.fory.type.DescriptorGrouper;
import org.apache.fory.type.FinalObjectTypeStub;
import org.apache.fory.type.GenericType;
import org.apache.fory.type.Generics;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.util.record.RecordComponent;
import org.apache.fory.util.record.RecordInfo;
import org.apache.fory.util.record.RecordUtils;

public abstract class AbstractObjectSerializer<T>
extends Serializer<T> {
    protected final RefResolver refResolver;
    protected final ClassResolver classResolver;
    protected final boolean isRecord;
    protected final MethodHandle constructor;
    private InternalFieldInfo[] fieldInfos;
    private RecordInfo copyRecordInfo;

    public AbstractObjectSerializer(Fory fory, Class<T> type) {
        this(fory, type, RecordUtils.isRecord(type) ? (MethodHandle)RecordUtils.getRecordConstructor(type).f1 : ReflectionUtils.getCtrHandle(type, false));
    }

    public AbstractObjectSerializer(Fory fory, Class<T> type, MethodHandle constructor) {
        super(fory, type);
        this.refResolver = fory.getRefResolver();
        this.classResolver = fory.getClassResolver();
        this.isRecord = RecordUtils.isRecord(type);
        this.constructor = constructor;
    }

    static Object readFinalObjectFieldValue(SerializationBinding binding, RefResolver refResolver, TypeResolver typeResolver, FinalTypeField fieldInfo, boolean isFinal, MemoryBuffer buffer) {
        Object fieldValue;
        Serializer<Object> serializer = fieldInfo.classInfo.getSerializer();
        binding.incReadDepth();
        boolean nullable = fieldInfo.nullable;
        if (isFinal) {
            fieldValue = !fieldInfo.trackingRef ? binding.readNullable(buffer, serializer, nullable) : binding.readRef(buffer, serializer);
        } else if (serializer.needToWriteRef()) {
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                typeResolver.readClassInfo(buffer, fieldInfo.classInfo);
                fieldValue = serializer.read(buffer);
                refResolver.setReadObject(nextReadRefId, fieldValue);
            } else {
                fieldValue = refResolver.getReadObject();
            }
        } else {
            byte headFlag;
            if (nullable && (headFlag = buffer.readByte()) == -3) {
                binding.decDepth();
                return null;
            }
            typeResolver.readClassInfo(buffer, fieldInfo.classInfo);
            fieldValue = serializer.read(buffer);
        }
        binding.decDepth();
        return fieldValue;
    }

    static Object readOtherFieldValue(SerializationBinding binding, GenericTypeField fieldInfo, MemoryBuffer buffer) {
        Object fieldValue;
        boolean nullable = fieldInfo.nullable;
        if (fieldInfo.trackingRef) {
            fieldValue = binding.readRef(buffer, fieldInfo);
        } else {
            byte headFlag;
            binding.preserveRefId(-1);
            if (nullable && (headFlag = buffer.readByte()) == -3) {
                return null;
            }
            fieldValue = binding.readNonRef(buffer, fieldInfo);
        }
        return fieldValue;
    }

    static Object readContainerFieldValue(SerializationBinding binding, Generics generics, GenericTypeField fieldInfo, MemoryBuffer buffer) {
        Object fieldValue;
        if (fieldInfo.trackingRef) {
            generics.pushGenericType(fieldInfo.genericType);
            fieldValue = binding.readContainerFieldValueRef(buffer, fieldInfo);
            generics.popGenericType();
        } else {
            byte headFlag;
            binding.preserveRefId(-1);
            boolean nullable = fieldInfo.nullable;
            if (nullable && (headFlag = buffer.readByte()) == -3) {
                return null;
            }
            generics.pushGenericType(fieldInfo.genericType);
            fieldValue = binding.readContainerFieldValue(buffer, fieldInfo);
            generics.popGenericType();
        }
        return fieldValue;
    }

    static boolean writePrimitiveFieldValueFailed(Fory fory, MemoryBuffer buffer, Object targetObject, FieldAccessor fieldAccessor, short classId) {
        long fieldOffset = fieldAccessor.getFieldOffset();
        if (fieldOffset != -1L) {
            return AbstractObjectSerializer.writePrimitiveFieldValueFailed(fory, buffer, targetObject, fieldOffset, classId);
        }
        switch (classId) {
            case 5: {
                buffer.writeBoolean((Boolean)fieldAccessor.get(targetObject));
                return false;
            }
            case 6: {
                buffer.writeByte((Byte)fieldAccessor.get(targetObject));
                return false;
            }
            case 7: {
                buffer.writeChar(((Character)fieldAccessor.get(targetObject)).charValue());
                return false;
            }
            case 8: {
                buffer.writeInt16((Short)fieldAccessor.get(targetObject));
                return false;
            }
            case 9: {
                int fieldValue = (Integer)fieldAccessor.get(targetObject);
                if (fory.compressInt()) {
                    buffer.writeVarInt32(fieldValue);
                } else {
                    buffer.writeInt32(fieldValue);
                }
                return false;
            }
            case 10: {
                buffer.writeFloat32(((Float)fieldAccessor.get(targetObject)).floatValue());
                return false;
            }
            case 11: {
                long fieldValue = (Long)fieldAccessor.get(targetObject);
                fory.writeInt64(buffer, fieldValue);
                return false;
            }
            case 12: {
                buffer.writeFloat64((Double)fieldAccessor.get(targetObject));
                return false;
            }
        }
        return true;
    }

    static boolean writePrimitiveFieldValueFailed(Fory fory, MemoryBuffer buffer, Object targetObject, long fieldOffset, short classId) {
        switch (classId) {
            case 5: {
                buffer.writeBoolean(Platform.getBoolean(targetObject, fieldOffset));
                return false;
            }
            case 6: {
                buffer.writeByte(Platform.getByte(targetObject, fieldOffset));
                return false;
            }
            case 7: {
                buffer.writeChar(Platform.getChar(targetObject, fieldOffset));
                return false;
            }
            case 8: {
                buffer.writeInt16(Platform.getShort(targetObject, fieldOffset));
                return false;
            }
            case 9: {
                int fieldValue = Platform.getInt(targetObject, fieldOffset);
                if (fory.compressInt()) {
                    buffer.writeVarInt32(fieldValue);
                } else {
                    buffer.writeInt32(fieldValue);
                }
                return false;
            }
            case 10: {
                buffer.writeFloat32(Platform.getFloat(targetObject, fieldOffset));
                return false;
            }
            case 11: {
                long fieldValue = Platform.getLong(targetObject, fieldOffset);
                fory.writeInt64(buffer, fieldValue);
                return false;
            }
            case 12: {
                buffer.writeFloat64(Platform.getDouble(targetObject, fieldOffset));
                return false;
            }
        }
        return true;
    }

    static boolean writeBasicObjectFieldValueFailed(Fory fory, MemoryBuffer buffer, Object fieldValue, short classId) {
        if (!fory.isBasicTypesRefIgnored()) {
            return true;
        }
        switch (classId) {
            case 22: {
                String stringValue = (String)fieldValue;
                if (fory.getStringSerializer().needToWriteRef()) {
                    fory.writeJavaStringRef(buffer, stringValue);
                } else {
                    fory.writeString(buffer, stringValue);
                }
                return false;
            }
            case 14: {
                buffer.writeBoolean((Boolean)fieldValue);
                return false;
            }
            case 15: {
                buffer.writeByte((Byte)fieldValue);
                return false;
            }
            case 16: {
                buffer.writeChar(((Character)fieldValue).charValue());
                return false;
            }
            case 17: {
                buffer.writeInt16((Short)fieldValue);
                return false;
            }
            case 18: {
                if (fory.compressInt()) {
                    buffer.writeVarInt32((Integer)fieldValue);
                } else {
                    buffer.writeInt32((Integer)fieldValue);
                }
                return false;
            }
            case 19: {
                buffer.writeFloat32(((Float)fieldValue).floatValue());
                return false;
            }
            case 20: {
                fory.writeInt64(buffer, (Long)fieldValue);
                return false;
            }
            case 21: {
                buffer.writeFloat64((Double)fieldValue);
                return false;
            }
        }
        return true;
    }

    static boolean writeBasicNullableObjectFieldValueFailed(Fory fory, MemoryBuffer buffer, Object fieldValue, short classId) {
        if (!fory.isBasicTypesRefIgnored()) {
            return true;
        }
        switch (classId) {
            case 22: {
                fory.writeJavaStringRef(buffer, (String)fieldValue);
                return false;
            }
            case 14: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeBoolean((Boolean)fieldValue);
                }
                return false;
            }
            case 15: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeByte((Byte)fieldValue);
                }
                return false;
            }
            case 16: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeChar(((Character)fieldValue).charValue());
                }
                return false;
            }
            case 17: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeInt16((Short)fieldValue);
                }
                return false;
            }
            case 18: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    if (fory.compressInt()) {
                        buffer.writeVarInt32((Integer)fieldValue);
                    } else {
                        buffer.writeInt32((Integer)fieldValue);
                    }
                }
                return false;
            }
            case 19: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeFloat32(((Float)fieldValue).floatValue());
                }
                return false;
            }
            case 20: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    fory.writeInt64(buffer, (Long)fieldValue);
                }
                return false;
            }
            case 21: {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                } else {
                    buffer.writeByte((byte)-1);
                    buffer.writeFloat64((Double)fieldValue);
                }
                return false;
            }
        }
        return true;
    }

    static boolean readPrimitiveFieldValueFailed(Fory fory, MemoryBuffer buffer, Object targetObject, FieldAccessor fieldAccessor, short classId) {
        long fieldOffset = fieldAccessor.getFieldOffset();
        if (fieldOffset != -1L) {
            return AbstractObjectSerializer.readPrimitiveFieldValueFailed(fory, buffer, targetObject, fieldOffset, classId);
        }
        switch (classId) {
            case 5: {
                fieldAccessor.set(targetObject, buffer.readBoolean());
                return false;
            }
            case 6: {
                fieldAccessor.set(targetObject, buffer.readByte());
                return false;
            }
            case 7: {
                fieldAccessor.set(targetObject, Character.valueOf(buffer.readChar()));
                return false;
            }
            case 8: {
                fieldAccessor.set(targetObject, buffer.readInt16());
                return false;
            }
            case 9: {
                if (fory.compressInt()) {
                    fieldAccessor.set(targetObject, buffer.readVarInt32());
                } else {
                    fieldAccessor.set(targetObject, buffer.readInt32());
                }
                return false;
            }
            case 10: {
                fieldAccessor.set(targetObject, Float.valueOf(buffer.readFloat32()));
                return false;
            }
            case 11: {
                fieldAccessor.set(targetObject, fory.readInt64(buffer));
                return false;
            }
            case 12: {
                fieldAccessor.set(targetObject, buffer.readFloat64());
                return false;
            }
        }
        return true;
    }

    private static boolean readPrimitiveFieldValueFailed(Fory fory, MemoryBuffer buffer, Object targetObject, long fieldOffset, short classId) {
        switch (classId) {
            case 5: {
                Platform.putBoolean(targetObject, fieldOffset, buffer.readBoolean());
                return false;
            }
            case 6: {
                Platform.putByte(targetObject, fieldOffset, buffer.readByte());
                return false;
            }
            case 7: {
                Platform.putChar(targetObject, fieldOffset, buffer.readChar());
                return false;
            }
            case 8: {
                Platform.putShort(targetObject, fieldOffset, buffer.readInt16());
                return false;
            }
            case 9: {
                if (fory.compressInt()) {
                    Platform.putInt(targetObject, fieldOffset, buffer.readVarInt32());
                } else {
                    Platform.putInt(targetObject, fieldOffset, buffer.readInt32());
                }
                return false;
            }
            case 10: {
                Platform.putFloat(targetObject, fieldOffset, buffer.readFloat32());
                return false;
            }
            case 11: {
                Platform.putLong(targetObject, fieldOffset, fory.readInt64(buffer));
                return false;
            }
            case 12: {
                Platform.putDouble(targetObject, fieldOffset, buffer.readFloat64());
                return false;
            }
        }
        return true;
    }

    static boolean readBasicObjectFieldValueFailed(Fory fory, MemoryBuffer buffer, Object targetObject, FieldAccessor fieldAccessor, short classId) {
        if (!fory.isBasicTypesRefIgnored()) {
            return true;
        }
        switch (classId) {
            case 22: {
                if (fory.getStringSerializer().needToWriteRef()) {
                    fieldAccessor.putObject(targetObject, fory.readJavaStringRef(buffer));
                } else {
                    fieldAccessor.putObject(targetObject, fory.readString(buffer));
                }
                return false;
            }
            case 14: {
                fieldAccessor.putObject(targetObject, buffer.readBoolean());
                return false;
            }
            case 15: {
                fieldAccessor.putObject(targetObject, buffer.readByte());
                return false;
            }
            case 16: {
                fieldAccessor.putObject(targetObject, Character.valueOf(buffer.readChar()));
                return false;
            }
            case 17: {
                fieldAccessor.putObject(targetObject, buffer.readInt16());
                return false;
            }
            case 18: {
                if (fory.compressInt()) {
                    fieldAccessor.putObject(targetObject, buffer.readVarInt32());
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readInt32());
                }
                return false;
            }
            case 19: {
                fieldAccessor.putObject(targetObject, Float.valueOf(buffer.readFloat32()));
                return false;
            }
            case 20: {
                fieldAccessor.putObject(targetObject, fory.readInt64(buffer));
                return false;
            }
            case 21: {
                fieldAccessor.putObject(targetObject, buffer.readFloat64());
                return false;
            }
        }
        return true;
    }

    static boolean readBasicNullableObjectFieldValueFailed(Fory fory, MemoryBuffer buffer, Object targetObject, FieldAccessor fieldAccessor, short classId) {
        if (!fory.isBasicTypesRefIgnored()) {
            return true;
        }
        switch (classId) {
            case 22: {
                fieldAccessor.putObject(targetObject, fory.readJavaStringRef(buffer));
                return false;
            }
            case 14: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readBoolean());
                }
                return false;
            }
            case 15: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readByte());
                }
                return false;
            }
            case 16: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, Character.valueOf(buffer.readChar()));
                }
                return false;
            }
            case 17: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readInt16());
                }
                return false;
            }
            case 18: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else if (fory.compressInt()) {
                    fieldAccessor.putObject(targetObject, buffer.readVarInt32());
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readInt32());
                }
                return false;
            }
            case 19: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, Float.valueOf(buffer.readFloat32()));
                }
                return false;
            }
            case 20: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, fory.readInt64(buffer));
                }
                return false;
            }
            case 21: {
                if (buffer.readByte() == -3) {
                    fieldAccessor.putObject(targetObject, null);
                } else {
                    fieldAccessor.putObject(targetObject, buffer.readFloat64());
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public T copy(T originObj) {
        if (this.immutable) {
            return originObj;
        }
        if (this.isRecord) {
            return this.copyRecord(originObj);
        }
        T newObj = this.newBean();
        if (this.needToCopyRef) {
            this.fory.reference(originObj, newObj);
        }
        this.copyFields(originObj, newObj);
        return newObj;
    }

    private T copyRecord(T originObj) {
        Object[] fieldValues = this.copyFields(originObj);
        try {
            Object t = this.constructor.invokeWithArguments(fieldValues);
            Arrays.fill(this.copyRecordInfo.getRecordComponents(), null);
            this.fory.reference(originObj, t);
            return (T)t;
        }
        catch (Throwable e) {
            Platform.throwException(e);
            return originObj;
        }
    }

    private Object[] copyFields(T originObj) {
        InternalFieldInfo[] fieldInfos = this.fieldInfos;
        if (fieldInfos == null) {
            fieldInfos = this.buildFieldsInfo();
        }
        Object[] fieldValues = new Object[fieldInfos.length];
        for (int i = 0; i < fieldInfos.length; ++i) {
            InternalFieldInfo fieldInfo = fieldInfos[i];
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            long fieldOffset = fieldAccessor.getFieldOffset();
            if (fieldOffset != -1L) {
                fieldValues[i] = this.copyField(originObj, fieldOffset, fieldInfo.classId);
                continue;
            }
            Object fieldValue = fieldAccessor.get(originObj);
            fieldValues[i] = this.fory.copyObject(fieldValue, fieldInfo.classId);
        }
        return RecordUtils.remapping(this.copyRecordInfo, fieldValues);
    }

    private void copyFields(T originObj, T newObj) {
        InternalFieldInfo[] fieldInfos = this.fieldInfos;
        if (fieldInfos == null) {
            fieldInfos = this.buildFieldsInfo();
        }
        block11: for (InternalFieldInfo fieldInfo : fieldInfos) {
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            long fieldOffset = fieldAccessor.getFieldOffset();
            assert (fieldOffset != -1L);
            switch (fieldInfo.classId) {
                case 6: {
                    Platform.putByte(newObj, fieldOffset, Platform.getByte(originObj, fieldOffset));
                    continue block11;
                }
                case 7: {
                    Platform.putChar(newObj, fieldOffset, Platform.getChar(originObj, fieldOffset));
                    continue block11;
                }
                case 8: {
                    Platform.putShort(newObj, fieldOffset, Platform.getShort(originObj, fieldOffset));
                    continue block11;
                }
                case 9: {
                    Platform.putInt(newObj, fieldOffset, Platform.getInt(originObj, fieldOffset));
                    continue block11;
                }
                case 11: {
                    Platform.putLong(newObj, fieldOffset, Platform.getLong(originObj, fieldOffset));
                    continue block11;
                }
                case 10: {
                    Platform.putFloat(newObj, fieldOffset, Platform.getFloat(originObj, fieldOffset));
                    continue block11;
                }
                case 12: {
                    Platform.putDouble(newObj, fieldOffset, Platform.getDouble(originObj, fieldOffset));
                    continue block11;
                }
                case 5: {
                    Platform.putBoolean(newObj, fieldOffset, Platform.getBoolean(originObj, fieldOffset));
                    continue block11;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    Platform.putObject(newObj, fieldOffset, Platform.getObject(originObj, fieldOffset));
                    continue block11;
                }
                default: {
                    Platform.putObject(newObj, fieldOffset, this.fory.copyObject(Platform.getObject(originObj, fieldOffset)));
                }
            }
        }
    }

    public static void copyFields(Fory fory, InternalFieldInfo[] fieldInfos, Object originObj, Object newObj) {
        block11: for (InternalFieldInfo fieldInfo : fieldInfos) {
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            long fieldOffset = fieldAccessor.getFieldOffset();
            assert (fieldOffset != -1L);
            switch (fieldInfo.classId) {
                case 6: {
                    Platform.putByte(newObj, fieldOffset, Platform.getByte(originObj, fieldOffset));
                    continue block11;
                }
                case 7: {
                    Platform.putChar(newObj, fieldOffset, Platform.getChar(originObj, fieldOffset));
                    continue block11;
                }
                case 8: {
                    Platform.putShort(newObj, fieldOffset, Platform.getShort(originObj, fieldOffset));
                    continue block11;
                }
                case 9: {
                    Platform.putInt(newObj, fieldOffset, Platform.getInt(originObj, fieldOffset));
                    continue block11;
                }
                case 11: {
                    Platform.putLong(newObj, fieldOffset, Platform.getLong(originObj, fieldOffset));
                    continue block11;
                }
                case 10: {
                    Platform.putFloat(newObj, fieldOffset, Platform.getFloat(originObj, fieldOffset));
                    continue block11;
                }
                case 12: {
                    Platform.putDouble(newObj, fieldOffset, Platform.getDouble(originObj, fieldOffset));
                    continue block11;
                }
                case 5: {
                    Platform.putBoolean(newObj, fieldOffset, Platform.getBoolean(originObj, fieldOffset));
                    continue block11;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    Platform.putObject(newObj, fieldOffset, Platform.getObject(originObj, fieldOffset));
                    continue block11;
                }
                default: {
                    Platform.putObject(newObj, fieldOffset, fory.copyObject(Platform.getObject(originObj, fieldOffset)));
                }
            }
        }
    }

    private Object copyField(Object targetObject, long fieldOffset, short classId) {
        switch (classId) {
            case 5: {
                return Platform.getBoolean(targetObject, fieldOffset);
            }
            case 6: {
                return Platform.getByte(targetObject, fieldOffset);
            }
            case 7: {
                return Character.valueOf(Platform.getChar(targetObject, fieldOffset));
            }
            case 8: {
                return Platform.getShort(targetObject, fieldOffset);
            }
            case 9: {
                return Platform.getInt(targetObject, fieldOffset);
            }
            case 10: {
                return Float.valueOf(Platform.getFloat(targetObject, fieldOffset));
            }
            case 11: {
                return Platform.getLong(targetObject, fieldOffset);
            }
            case 12: {
                return Platform.getDouble(targetObject, fieldOffset);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return Platform.getObject(targetObject, fieldOffset);
            }
        }
        return this.fory.copyObject(Platform.getObject(targetObject, fieldOffset));
    }

    private InternalFieldInfo[] buildFieldsInfo() {
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        if (RecordUtils.isRecord(this.type)) {
            RecordComponent[] components = RecordUtils.getRecordComponents(this.type);
            assert (components != null);
            try {
                for (Object object : components) {
                    Field field = this.type.getDeclaredField(((RecordComponent)object).getName());
                    descriptors.add(new Descriptor(field, TypeRef.of(field.getGenericType()), ((RecordComponent)object).getAccessor(), null));
                }
            }
            catch (NoSuchFieldException e) {
                Platform.throwException(e);
            }
        } else {
            for (Field field : ReflectionUtils.getFields(this.type, true)) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                descriptors.add(new Descriptor(field, TypeRef.of(field.getGenericType()), null, null));
            }
        }
        DescriptorGrouper descriptorGrouper = this.fory.getClassResolver().createDescriptorGrouper(descriptors, false);
        Tuple3<Tuple2<FinalTypeField[], boolean[]>, GenericTypeField[], GenericTypeField[]> infos = AbstractObjectSerializer.buildFieldInfos(this.fory, descriptorGrouper);
        this.fieldInfos = new InternalFieldInfo[descriptors.size()];
        System.arraycopy(((Tuple2)infos.f0).f0, 0, this.fieldInfos, 0, ((FinalTypeField[])((Tuple2)infos.f0).f0).length);
        System.arraycopy(infos.f1, 0, this.fieldInfos, ((FinalTypeField[])((Tuple2)infos.f0).f0).length, ((GenericTypeField[])infos.f1).length);
        System.arraycopy(infos.f2, 0, this.fieldInfos, this.fieldInfos.length - ((GenericTypeField[])infos.f2).length, ((GenericTypeField[])infos.f2).length);
        if (this.isRecord) {
            List<String> fieldNames = Arrays.stream(this.fieldInfos).map(f -> f.fieldAccessor.getField().getName()).collect(Collectors.toList());
            this.copyRecordInfo = new RecordInfo(this.type, fieldNames);
        }
        return this.fieldInfos;
    }

    public static InternalFieldInfo[] buildFieldsInfo(Fory fory, List<Field> fields) {
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        for (Field field : fields) {
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            descriptors.add(new Descriptor(field, TypeRef.of(field.getGenericType()), null, null));
        }
        DescriptorGrouper descriptorGrouper = fory.getClassResolver().createDescriptorGrouper(descriptors, false);
        Tuple3<Tuple2<FinalTypeField[], boolean[]>, GenericTypeField[], GenericTypeField[]> infos = AbstractObjectSerializer.buildFieldInfos(fory, descriptorGrouper);
        InternalFieldInfo[] fieldInfos = new InternalFieldInfo[descriptors.size()];
        System.arraycopy(((Tuple2)infos.f0).f0, 0, fieldInfos, 0, ((FinalTypeField[])((Tuple2)infos.f0).f0).length);
        System.arraycopy(infos.f1, 0, fieldInfos, ((FinalTypeField[])((Tuple2)infos.f0).f0).length, ((GenericTypeField[])infos.f1).length);
        System.arraycopy(infos.f2, 0, fieldInfos, fieldInfos.length - ((GenericTypeField[])infos.f2).length, ((GenericTypeField[])infos.f2).length);
        return fieldInfos;
    }

    protected T newBean() {
        if (this.constructor != null) {
            try {
                return (T)this.constructor.invoke();
            }
            catch (Throwable e) {
                Platform.throwException(e);
            }
        }
        return Platform.newInstance(this.type);
    }

    static Tuple3<Tuple2<FinalTypeField[], boolean[]>, GenericTypeField[], GenericTypeField[]> buildFieldInfos(Fory fory, DescriptorGrouper grouper) {
        Collection<Descriptor> primitives = grouper.getPrimitiveDescriptors();
        Collection<Descriptor> boxed = grouper.getBoxedDescriptors();
        Collection<Descriptor> finals = grouper.getFinalDescriptors();
        FinalTypeField[] finalFields = new FinalTypeField[primitives.size() + boxed.size() + finals.size()];
        int cnt = 0;
        for (Descriptor d : primitives) {
            finalFields[cnt++] = new FinalTypeField(fory, d);
        }
        for (Descriptor d : boxed) {
            finalFields[cnt++] = new FinalTypeField(fory, d);
        }
        for (Descriptor d : finals) {
            finalFields[cnt++] = new FinalTypeField(fory, d);
        }
        boolean[] isFinal = new boolean[finalFields.length];
        for (int i = 0; i < isFinal.length; ++i) {
            ClassInfo classInfo = finalFields[i].classInfo;
            isFinal[i] = classInfo != null && fory.getClassResolver().isMonomorphic(classInfo.getCls());
        }
        cnt = 0;
        GenericTypeField[] otherFields = new GenericTypeField[grouper.getOtherDescriptors().size()];
        for (Descriptor descriptor : grouper.getOtherDescriptors()) {
            GenericTypeField genericTypeField = new GenericTypeField(fory, descriptor);
            otherFields[cnt++] = genericTypeField;
        }
        cnt = 0;
        Collection<Descriptor> collections = grouper.getCollectionDescriptors();
        Collection<Descriptor> maps = grouper.getMapDescriptors();
        GenericTypeField[] containerFields = new GenericTypeField[collections.size() + maps.size()];
        for (Descriptor d : collections) {
            containerFields[cnt++] = new GenericTypeField(fory, d);
        }
        for (Descriptor d : maps) {
            containerFields[cnt++] = new GenericTypeField(fory, d);
        }
        return Tuple3.of(Tuple2.of(finalFields, isFinal), otherFields, containerFields);
    }

    private static short getRegisteredClassId(Fory fory, Class<?> cls) {
        Short classId = fory.getClassResolver().getRegisteredClassId(cls);
        return classId == null ? (short)0 : classId;
    }

    static final class GenericTypeField
    extends InternalFieldInfo {
        final GenericType genericType;
        final ClassInfoHolder classInfoHolder;
        final boolean isArray;
        final ClassInfo containerClassInfo;

        private GenericTypeField(Fory fory, Descriptor d) {
            super(fory, d, AbstractObjectSerializer.getRegisteredClassId(fory, TypeUtils.getRawType(d.getTypeRef())));
            boolean skip;
            ClassResolver classResolver = fory.getClassResolver();
            GenericType t = classResolver.buildGenericType(this.typeRef);
            Class<?> cls = t.getCls();
            if (t.getTypeParametersCount() > 0 && (skip = Arrays.stream(t.getTypeParameters()).allMatch(p -> p.getCls() == Object.class))) {
                t = new GenericType(t.getTypeRef(), t.isMonomorphic(), new GenericType[0]);
            }
            this.genericType = t;
            this.classInfoHolder = classResolver.nilClassInfoHolder();
            this.isArray = cls.isArray();
            this.containerClassInfo = !fory.isCrossLanguage() ? null : (classResolver.isMap(cls) || classResolver.isCollection(cls) || classResolver.isSet(cls) ? fory.getXtypeResolver().getClassInfo(cls) : null);
        }

        @Override
        public String toString() {
            return "GenericTypeField{genericType=" + this.genericType + ", classInfoHolder=" + this.classInfoHolder + ", trackingRef=" + this.trackingRef + ", typeRef=" + this.typeRef + ", classId=" + this.classId + ", qualifiedFieldName='" + this.qualifiedFieldName + ", fieldAccessor=" + this.fieldAccessor + ", nullable=" + this.nullable + '}';
        }
    }

    static final class FinalTypeField
    extends InternalFieldInfo {
        final ClassInfo classInfo;

        private FinalTypeField(Fory fory, Descriptor d) {
            super(fory, d, AbstractObjectSerializer.getRegisteredClassId(fory, d.getTypeRef().getRawType()));
            this.classInfo = this.typeRef.getRawType() == FinalObjectTypeStub.class ? null : SerializationUtils.getClassInfo(fory, this.typeRef.getRawType());
        }
    }

    public static class InternalFieldInfo {
        protected final TypeRef<?> typeRef;
        protected final short classId;
        protected final String qualifiedFieldName;
        protected final FieldAccessor fieldAccessor;
        protected boolean nullable;
        protected boolean trackingRef;

        private InternalFieldInfo(Fory fory, Descriptor d, short classId) {
            this.typeRef = d.getTypeRef();
            this.classId = classId;
            this.qualifiedFieldName = d.getDeclaringClass() + "." + d.getName();
            this.fieldAccessor = d.getField() != null ? FieldAccessor.createAccessor(d.getField()) : null;
            ForyField foryField = d.getForyField();
            this.nullable = d.isNullable();
            if (fory.trackingRef()) {
                this.trackingRef = foryField != null ? foryField.trackingRef() : fory.getClassResolver().needToWriteRef(this.typeRef);
            }
        }

        public String toString() {
            return "InternalFieldInfo{typeRef=" + this.typeRef + ", classId=" + this.classId + ", qualifiedFieldName='" + this.qualifiedFieldName + ", fieldAccessor=" + this.fieldAccessor + ", nullable=" + this.nullable + '}';
        }
    }
}

