/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.commands;

import java.util.HashMap;
import java.util.Map;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.commands.CommandExecutionException;
import org.apache.skywalking.apm.agent.core.commands.CommandExecutor;
import org.apache.skywalking.apm.agent.core.commands.executor.ConfigurationDiscoveryCommandExecutor;
import org.apache.skywalking.apm.agent.core.commands.executor.NoopCommandExecutor;
import org.apache.skywalking.apm.agent.core.commands.executor.ProfileTaskCommandExecutor;
import org.apache.skywalking.apm.network.trace.component.command.BaseCommand;

@DefaultImplementor
public class CommandExecutorService
implements BootService,
CommandExecutor {
    private Map<String, CommandExecutor> commandExecutorMap;

    @Override
    public void prepare() throws Throwable {
        this.commandExecutorMap = new HashMap<String, CommandExecutor>();
        this.commandExecutorMap.put("ProfileTaskQuery", new ProfileTaskCommandExecutor());
        this.commandExecutorMap.put("ConfigurationDiscoveryCommand", new ConfigurationDiscoveryCommandExecutor());
    }

    @Override
    public void boot() throws Throwable {
    }

    @Override
    public void onComplete() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
    }

    @Override
    public void execute(BaseCommand command) throws CommandExecutionException {
        this.executorForCommand(command).execute(command);
    }

    private CommandExecutor executorForCommand(BaseCommand command) {
        CommandExecutor executor = this.commandExecutorMap.get(command.getCommand());
        if (executor != null) {
            return executor;
        }
        return NoopCommandExecutor.INSTANCE;
    }
}

