/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.runtime.SecurityProviderUtils;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.jboss.logging.Logger;

@Recorder
public class SecurityProviderRecorder {
    private static final Logger LOG = Logger.getLogger(SecurityProviderRecorder.class);

    public void addBouncyCastleProvider(boolean inFipsMode) {
        String providerName = inFipsMode ? "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider" : "org.bouncycastle.jce.provider.BouncyCastleProvider";
        SecurityProviderUtils.addProvider(SecurityProviderUtils.loadProvider(providerName));
        if (inFipsMode) {
            this.setSecureRandomStrongAlgorithmIfNecessary();
        }
    }

    public void addBouncyCastleJsseProvider() {
        Provider bc = SecurityProviderUtils.loadProvider("org.bouncycastle.jce.provider.BouncyCastleProvider");
        Provider bcJsse = SecurityProviderUtils.loadProvider("org.bouncycastle.jsse.provider.BouncyCastleJsseProvider");
        int sunJsseIndex = SecurityProviderUtils.findProviderIndex("SunJSSE");
        SecurityProviderUtils.insertProvider(bc, sunJsseIndex);
        SecurityProviderUtils.insertProvider(bcJsse, sunJsseIndex + 1);
    }

    public void addBouncyCastleFipsJsseProvider() {
        Provider bc = SecurityProviderUtils.loadProvider("org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider");
        int sunIndex = SecurityProviderUtils.findProviderIndex("SUN");
        SecurityProviderUtils.insertProvider(bc, sunIndex);
        Provider bcJsse = SecurityProviderUtils.loadProviderWithParams("org.bouncycastle.jsse.provider.BouncyCastleJsseProvider", new Class[]{Boolean.TYPE, Provider.class}, new Object[]{true, bc});
        SecurityProviderUtils.insertProvider(bcJsse, sunIndex + 1);
        this.setSecureRandomStrongAlgorithmIfNecessary();
    }

    private void setSecureRandomStrongAlgorithmIfNecessary() {
        try {
            SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            SecureRandom secRandom = new SecureRandom();
            String origStrongAlgorithms = Security.getProperty("securerandom.strongAlgorithms");
            String usedAlgorithm = secRandom.getAlgorithm() + ":" + secRandom.getProvider().getName();
            String strongAlgorithms = origStrongAlgorithms == null ? usedAlgorithm : usedAlgorithm + "," + origStrongAlgorithms;
            LOG.debugf("Strong SecureRandom algorithm '%s' is not available. Using fallback algorithm '%s'.", (Object)origStrongAlgorithms, (Object)usedAlgorithm);
            Security.setProperty("securerandom.strongAlgorithms", strongAlgorithms);
        }
    }
}

