#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

# coding: utf-8

# flake8: noqa
"""
    Apache Iceberg REST Catalog API

    Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


# import models into model package
from polaris.catalog.models.add_partition_spec_update import AddPartitionSpecUpdate
from polaris.catalog.models.add_schema_update import AddSchemaUpdate
from polaris.catalog.models.add_snapshot_update import AddSnapshotUpdate
from polaris.catalog.models.add_sort_order_update import AddSortOrderUpdate
from polaris.catalog.models.add_view_version_update import AddViewVersionUpdate
from polaris.catalog.models.and_or_expression import AndOrExpression
from polaris.catalog.models.assert_create import AssertCreate
from polaris.catalog.models.assert_current_schema_id import AssertCurrentSchemaId
from polaris.catalog.models.assert_default_sort_order_id import AssertDefaultSortOrderId
from polaris.catalog.models.assert_default_spec_id import AssertDefaultSpecId
from polaris.catalog.models.assert_last_assigned_field_id import AssertLastAssignedFieldId
from polaris.catalog.models.assert_last_assigned_partition_id import AssertLastAssignedPartitionId
from polaris.catalog.models.assert_ref_snapshot_id import AssertRefSnapshotId
from polaris.catalog.models.assert_table_uuid import AssertTableUUID
from polaris.catalog.models.assert_view_uuid import AssertViewUUID
from polaris.catalog.models.assign_uuid_update import AssignUUIDUpdate
from polaris.catalog.models.async_planning_result import AsyncPlanningResult
from polaris.catalog.models.base_update import BaseUpdate
from polaris.catalog.models.blob_metadata import BlobMetadata
from polaris.catalog.models.catalog_config import CatalogConfig
from polaris.catalog.models.commit_report import CommitReport
from polaris.catalog.models.commit_table_request import CommitTableRequest
from polaris.catalog.models.commit_table_response import CommitTableResponse
from polaris.catalog.models.commit_transaction_request import CommitTransactionRequest
from polaris.catalog.models.commit_view_request import CommitViewRequest
from polaris.catalog.models.completed_planning_result import CompletedPlanningResult
from polaris.catalog.models.completed_planning_with_id_result import CompletedPlanningWithIDResult
from polaris.catalog.models.content_file import ContentFile
from polaris.catalog.models.count_map import CountMap
from polaris.catalog.models.counter_result import CounterResult
from polaris.catalog.models.create_namespace_request import CreateNamespaceRequest
from polaris.catalog.models.create_namespace_response import CreateNamespaceResponse
from polaris.catalog.models.create_table_request import CreateTableRequest
from polaris.catalog.models.create_view_request import CreateViewRequest
from polaris.catalog.models.data_file import DataFile
from polaris.catalog.models.delete_file import DeleteFile
from polaris.catalog.models.empty_planning_result import EmptyPlanningResult
from polaris.catalog.models.enable_row_lineage_update import EnableRowLineageUpdate
from polaris.catalog.models.equality_delete_file import EqualityDeleteFile
from polaris.catalog.models.error_model import ErrorModel
from polaris.catalog.models.expression import Expression
from polaris.catalog.models.failed_planning_result import FailedPlanningResult
from polaris.catalog.models.false_expression import FalseExpression
from polaris.catalog.models.fetch_planning_result import FetchPlanningResult
from polaris.catalog.models.fetch_scan_tasks_request import FetchScanTasksRequest
from polaris.catalog.models.fetch_scan_tasks_result import FetchScanTasksResult
from polaris.catalog.models.file_format import FileFormat
from polaris.catalog.models.file_scan_task import FileScanTask
from polaris.catalog.models.get_namespace_response import GetNamespaceResponse
from polaris.catalog.models.iceberg_error_response import IcebergErrorResponse
from polaris.catalog.models.list_namespaces_response import ListNamespacesResponse
from polaris.catalog.models.list_tables_response import ListTablesResponse
from polaris.catalog.models.list_type import ListType
from polaris.catalog.models.literal_expression import LiteralExpression
from polaris.catalog.models.load_credentials_response import LoadCredentialsResponse
from polaris.catalog.models.load_table_result import LoadTableResult
from polaris.catalog.models.load_view_result import LoadViewResult
from polaris.catalog.models.map_type import MapType
from polaris.catalog.models.metadata_log_inner import MetadataLogInner
from polaris.catalog.models.metric_result import MetricResult
from polaris.catalog.models.model_schema import ModelSchema
from polaris.catalog.models.not_expression import NotExpression
from polaris.catalog.models.null_order import NullOrder
from polaris.catalog.models.o_auth_error import OAuthError
from polaris.catalog.models.o_auth_token_response import OAuthTokenResponse
from polaris.catalog.models.partition_field import PartitionField
from polaris.catalog.models.partition_spec import PartitionSpec
from polaris.catalog.models.partition_statistics_file import PartitionStatisticsFile
from polaris.catalog.models.plan_status import PlanStatus
from polaris.catalog.models.plan_table_scan_request import PlanTableScanRequest
from polaris.catalog.models.plan_table_scan_result import PlanTableScanResult
from polaris.catalog.models.position_delete_file import PositionDeleteFile
from polaris.catalog.models.primitive_type_value import PrimitiveTypeValue
from polaris.catalog.models.register_table_request import RegisterTableRequest
from polaris.catalog.models.remove_partition_specs_update import RemovePartitionSpecsUpdate
from polaris.catalog.models.remove_partition_statistics_update import RemovePartitionStatisticsUpdate
from polaris.catalog.models.remove_properties_update import RemovePropertiesUpdate
from polaris.catalog.models.remove_snapshot_ref_update import RemoveSnapshotRefUpdate
from polaris.catalog.models.remove_snapshots_update import RemoveSnapshotsUpdate
from polaris.catalog.models.remove_statistics_update import RemoveStatisticsUpdate
from polaris.catalog.models.rename_table_request import RenameTableRequest
from polaris.catalog.models.report_metrics_request import ReportMetricsRequest
from polaris.catalog.models.sql_view_representation import SQLViewRepresentation
from polaris.catalog.models.scan_report import ScanReport
from polaris.catalog.models.scan_tasks import ScanTasks
from polaris.catalog.models.set_current_schema_update import SetCurrentSchemaUpdate
from polaris.catalog.models.set_current_view_version_update import SetCurrentViewVersionUpdate
from polaris.catalog.models.set_default_sort_order_update import SetDefaultSortOrderUpdate
from polaris.catalog.models.set_default_spec_update import SetDefaultSpecUpdate
from polaris.catalog.models.set_expression import SetExpression
from polaris.catalog.models.set_location_update import SetLocationUpdate
from polaris.catalog.models.set_partition_statistics_update import SetPartitionStatisticsUpdate
from polaris.catalog.models.set_properties_update import SetPropertiesUpdate
from polaris.catalog.models.set_snapshot_ref_update import SetSnapshotRefUpdate
from polaris.catalog.models.set_statistics_update import SetStatisticsUpdate
from polaris.catalog.models.snapshot import Snapshot
from polaris.catalog.models.snapshot_log_inner import SnapshotLogInner
from polaris.catalog.models.snapshot_reference import SnapshotReference
from polaris.catalog.models.snapshot_summary import SnapshotSummary
from polaris.catalog.models.sort_direction import SortDirection
from polaris.catalog.models.sort_field import SortField
from polaris.catalog.models.sort_order import SortOrder
from polaris.catalog.models.statistics_file import StatisticsFile
from polaris.catalog.models.storage_credential import StorageCredential
from polaris.catalog.models.struct_field import StructField
from polaris.catalog.models.struct_type import StructType
from polaris.catalog.models.table_identifier import TableIdentifier
from polaris.catalog.models.table_metadata import TableMetadata
from polaris.catalog.models.table_requirement import TableRequirement
from polaris.catalog.models.table_update import TableUpdate
from polaris.catalog.models.term import Term
from polaris.catalog.models.timer_result import TimerResult
from polaris.catalog.models.token_type import TokenType
from polaris.catalog.models.transform_term import TransformTerm
from polaris.catalog.models.true_expression import TrueExpression
from polaris.catalog.models.type import Type
from polaris.catalog.models.unary_expression import UnaryExpression
from polaris.catalog.models.update_namespace_properties_request import UpdateNamespacePropertiesRequest
from polaris.catalog.models.update_namespace_properties_response import UpdateNamespacePropertiesResponse
from polaris.catalog.models.upgrade_format_version_update import UpgradeFormatVersionUpdate
from polaris.catalog.models.value_map import ValueMap
from polaris.catalog.models.view_history_entry import ViewHistoryEntry
from polaris.catalog.models.view_metadata import ViewMetadata
from polaris.catalog.models.view_representation import ViewRepresentation
from polaris.catalog.models.view_requirement import ViewRequirement
from polaris.catalog.models.view_update import ViewUpdate
from polaris.catalog.models.view_version import ViewVersion
