/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.util;

import com.xiaomi.mone.tpc.login.anno.AuthExclude;
import com.xiaomi.mone.tpc.login.util.MD5Util;
import java.lang.reflect.Field;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SignUtil {
    private static final Logger logger = LoggerFactory.getLogger(SignUtil.class);
    private static final Map<Class, Map<String, Field>> clsFieldMap = new ConcurrentHashMap<Class, Map<String, Field>>();

    public static final String getSysSign(String sysName, String token, long now, String userToken, String dataSign) {
        StringBuilder signBuilder = new StringBuilder();
        signBuilder.append(sysName).append(token).append(now);
        if (StringUtils.isNotBlank((CharSequence)userToken)) {
            signBuilder.append(userToken);
        }
        if (StringUtils.isNotBlank((CharSequence)dataSign)) {
            signBuilder.append(dataSign);
        }
        String md5Val = MD5Util.md5(signBuilder.toString());
        logger.info("ReqSignUtil.getSysSign data={}, md5={}", (Object)signBuilder.toString(), (Object)md5Val);
        return md5Val;
    }

    public static String getDataSign(Object ... args) throws NoSuchFieldException, IllegalAccessException {
        if (args == null || args.length <= 0) {
            return null;
        }
        StringBuilder signBuilder = new StringBuilder();
        for (Object arg : args) {
            if (arg == null) continue;
            SignUtil.dataStr(arg, arg.getClass(), signBuilder);
        }
        if (signBuilder.length() <= 0) {
            return null;
        }
        String md5Val = MD5Util.md5(signBuilder.toString());
        logger.info("ReqSignUtil.getDataSign data={}, md5={}", (Object)signBuilder.toString(), (Object)md5Val);
        return md5Val;
    }

    public static void dataStr(Object arg, Class argClass, StringBuilder signBuilder) throws NoSuchFieldException, IllegalAccessException {
        if (arg == null) {
            return;
        }
        if (SignUtil.isPrimitive(argClass)) {
            signBuilder.append(arg.toString());
            return;
        }
        if (Date.class.isAssignableFrom(argClass)) {
            signBuilder.append(((Date)arg).getTime());
            return;
        }
        if (argClass.isArray()) {
            Object[] arrVal;
            for (Object val : arrVal = (Object[])arg) {
                if (val == null) continue;
                SignUtil.dataStr(val, val.getClass(), signBuilder);
            }
            return;
        }
        if (List.class.isAssignableFrom(argClass)) {
            List list = (List)arg;
            for (Object val : list) {
                if (val == null) continue;
                SignUtil.dataStr(val, val.getClass(), signBuilder);
            }
            return;
        }
        if (Map.class.isAssignableFrom(argClass)) {
            Map map = (Map)arg;
            TreeMap treemap = new TreeMap(map);
            Set keys = treemap.keySet();
            Object keyVal = null;
            for (String key : keys) {
                keyVal = treemap.get(key);
                if (keyVal == null) continue;
                SignUtil.dataStr(keyVal, keyVal.getClass(), signBuilder);
            }
            return;
        }
        if (Set.class.isAssignableFrom(argClass)) {
            return;
        }
        Map<String, Field> fieldMap = SignUtil.getFieldMap(argClass);
        for (String fieldName : fieldMap.keySet()) {
            Field field = fieldMap.get(fieldName);
            Object fieldVal = field.get(arg);
            if (fieldVal == null) continue;
            SignUtil.dataStr(fieldVal, fieldVal.getClass(), signBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Field> getFieldMap(Class clazz) {
        Map<String, Field> fieldMap = clsFieldMap.get(clazz);
        if (fieldMap != null) {
            return fieldMap;
        }
        Map<Class, Map<String, Field>> map = clsFieldMap;
        synchronized (map) {
            fieldMap = clsFieldMap.get(clazz);
            if (fieldMap != null) {
                return fieldMap;
            }
            fieldMap = SignUtil.getClazzFieldMap(clazz);
            for (Field field : fieldMap.values()) {
                if (field.isAccessible()) continue;
                field.setAccessible(true);
            }
            fieldMap = new TreeMap<String, Field>(fieldMap);
            clsFieldMap.put(clazz, fieldMap);
        }
        return fieldMap;
    }

    private static Map<String, Field> getClazzFieldMap(Class clazz) {
        if (clazz == null || clazz.equals(Object.class)) {
            return new HashMap<String, Field>();
        }
        Field[] fields = clazz.getDeclaredFields();
        if (fields == null) {
            fields = new Field[]{};
        }
        HashMap<String, Field> map = new HashMap<String, Field>();
        Map<String, Field> subMap = SignUtil.getClazzFieldMap(clazz.getSuperclass());
        if (!CollectionUtils.isEmpty(subMap)) {
            map.putAll(subMap);
        }
        Arrays.stream(fields).filter(field -> field.getAnnotation(AuthExclude.class) == null).map(field -> {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field;
        }).forEach(field -> map.put(field.getName(), (Field)field));
        return map;
    }

    public static boolean isPrimitive(Class fClazz) {
        if (fClazz.isPrimitive()) {
            return true;
        }
        return Integer.class.equals((Object)fClazz) || Byte.class.equals((Object)fClazz) || Short.class.equals((Object)fClazz) || Long.class.equals((Object)fClazz) || Boolean.class.equals((Object)fClazz) || Character.class.equals((Object)fClazz) || String.class.equals((Object)fClazz) || Float.class.equals((Object)fClazz) || Double.class.equals((Object)fClazz);
    }

    private static String verifySignGetInfo(String message, String key, boolean isDecode) throws SignatureException {
        try {
            logger.debug("cas VerifySignGetInfo message:" + message);
            Base64.Decoder decoder = Base64.getDecoder();
            if (StringUtils.isEmpty((CharSequence)message)) {
                return "";
            }
            String[] dataBox = message.split("#");
            String signature = dataBox[0];
            String data = dataBox[1];
            logger.debug("verifySignGetInfo signature:" + signature);
            logger.debug("verifySignGetInfo data:" + data);
            byte[] signBytes = signature.getBytes();
            byte[] dataBytes = data.getBytes();
            if (isDecode) {
                signBytes = decoder.decode(signature);
                dataBytes = decoder.decode(data);
            }
            String pkey = key.replace("\\n", "");
            pkey = pkey.replace("\n", "");
            pkey = pkey.replace("-----BEGIN PUBLIC KEY-----", "");
            pkey = pkey.replace("-----END PUBLIC KEY-----", "");
            byte[] keyBytes = decoder.decode(pkey);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            RSAPublicKey pubKey = (RSAPublicKey)kf.generatePublic(spec);
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initVerify(pubKey);
            sign.update(dataBytes);
            if (sign.verify(signBytes)) {
                return new String(dataBytes);
            }
            return "";
        }
        catch (Exception ex) {
            logger.error("VerifySignGetInfo err ", (Throwable)ex);
            throw new SignatureException(ex);
        }
    }

    public static String verifySignGetInfo(String data, String key) throws SignatureException {
        return SignUtil.verifySignGetInfo(data, key, true);
    }
}

