/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.filter;

import com.xiaomi.mone.tpc.login.filter.DoceanFilter;
import com.xiaomi.mone.tpc.login.util.CommonUtil;
import com.xiaomi.mone.tpc.login.util.ConstUtil;
import com.xiaomi.mone.tpc.login.util.DoceanTokenUtil;
import com.xiaomi.mone.tpc.login.util.HttpClientUtil;
import com.xiaomi.mone.tpc.login.util.SystemReqUtil;
import com.xiaomi.mone.tpc.login.vo.AuthTokenVo;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import com.xiaomi.mone.tpc.login.vo.ResultVo;
import com.xiaomi.youpin.docean.mvc.MvcContext;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DoceanAuthTokenFilter
extends DoceanFilter {
    private static final Logger logger = LoggerFactory.getLogger(DoceanAuthTokenFilter.class);
    private String[] ignoreUrls = null;
    private String loginUrl = null;

    public DoceanAuthTokenFilter() {
        HttpClientUtil.init();
    }

    @Override
    public void init(Map<String, String> filterConfig) {
        this.loginUrl = filterConfig.get("loginUrl");
        String authTokenUrl = filterConfig.get("authTokenUrl");
        if (StringUtils.isBlank((CharSequence)authTokenUrl)) {
            throw new IllegalArgumentException("authTokenUrl\u503c\u4e3a\u7a7a");
        }
        ConstUtil.authTokenUrlVal = authTokenUrl;
        logger.info("auth_token_url is {}", (Object)authTokenUrl);
        String ignoreUrl = filterConfig.get("IGNORE_URL");
        if (ignoreUrl != null && !"".equals(ignoreUrl)) {
            this.ignoreUrls = ignoreUrl.split(",");
        }
        logger.info("ignore_url_list is {}", (Object[])this.ignoreUrls);
    }

    @Override
    public boolean doFilter(MvcContext mvcContext) {
        String url = mvcContext.getPath();
        AuthTokenVo authToken = DoceanTokenUtil.parseAuthToken(mvcContext);
        logger.info("authToken={}", (Object)authToken);
        if (authToken == null) {
            if (CommonUtil.isIgnoreUrl(this.ignoreUrls, url)) {
                logger.info("request is ignore_url={}", (Object)url);
                return true;
            }
            logger.info("request not login request_url={}", (Object)url);
            this.noAuthResponse(mvcContext);
            return false;
        }
        ResultVo<AuthUserVo> resultVo = SystemReqUtil.authRequest(authToken.getAuthToken(), !authToken.isFromCookie());
        logger.info("getResult={}", resultVo);
        if (resultVo == null || !resultVo.success()) {
            if (CommonUtil.isIgnoreUrl(this.ignoreUrls, url)) {
                logger.info("request is ignore_url={}", (Object)url);
                return true;
            }
            logger.info("request not login request_url={}", (Object)url);
            this.noAuthResponse(mvcContext);
            return false;
        }
        if (!authToken.isFromCookie()) {
            DoceanTokenUtil.setCookie(resultVo.getData(), mvcContext);
        }
        mvcContext.session().setAttribute("TPC_USER", (Object)resultVo.getData());
        return true;
    }

    private void noAuthResponse(MvcContext mvcContext) {
        mvcContext.getResHeaders().put("x-status", "401");
        mvcContext.getResHeaders().put("TPC_TOKEN", "1");
        mvcContext.getResHeaders().put("loginUrl", this.loginUrl);
    }

    @Override
    public void destroy() {
    }
}

