/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ozhera.log.manager.common.exception.MilogManageException;
import org.apache.ozhera.log.manager.model.dto.DictionaryDTO;
import org.apache.ozhera.log.manager.model.dto.RocketMqResponseDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogAppMiddlewareRel;
import org.apache.ozhera.log.manager.service.CommonRocketMqService;
import org.apache.ozhera.log.manager.service.MqConfigService;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class RocketMqConfigService
implements MqConfigService,
CommonRocketMqService {
    private static final Logger log = LoggerFactory.getLogger(RocketMqConfigService.class);
    private Map<String, DefaultMQProducer> mqMap = new HashMap<String, DefaultMQProducer>();

    @Override
    public MilogAppMiddlewareRel.Config generateConfig(String ak, String sk, String nameServer, String serviceUrl, String authorization, String orgId, String teamId, Long exceedId, String name, String source, Long id) {
        MilogAppMiddlewareRel.Config config = new MilogAppMiddlewareRel.Config();
        DefaultMQProducer defaultMQProducer = this.mqMap.get(nameServer);
        if (null == defaultMQProducer) {
            defaultMQProducer = new DefaultMQProducer("hera_log");
            defaultMQProducer.setNamesrvAddr(nameServer);
            try {
                defaultMQProducer.start();
            }
            catch (MQClientException e) {
                log.info("create mq producer error,nameServer:{}", (Object)nameServer, (Object)e);
                throw new MilogManageException("create mq producer error", e);
            }
            this.mqMap.put(nameServer, defaultMQProducer);
        }
        String topicName = this.generateSimpleTopicName(id, name);
        try {
            String brokerName = "tj1-b2c-systech-infra03.kscn";
            defaultMQProducer.createTopic(brokerName, topicName, 1);
        }
        catch (MQClientException e) {
            log.info("create mq common topic error,nameServer:{}", (Object)nameServer, (Object)e);
            throw new MilogManageException("create mq common topic error", e);
        }
        config.setTopic(topicName);
        config.setPartitionCnt(1);
        return config;
    }

    @Override
    public List<DictionaryDTO> queryExistsTopic(String ak, String sk, String nameServer, String serviceUrl, String authorization, String orgId, String teamId) {
        ArrayList dictionaryDTOS = Lists.newArrayList();
        return dictionaryDTOS;
    }

    @Override
    public List<String> createCommonTagTopic(String ak, String sk, String nameServer, String serviceUrl, String authorization, String orgId, String brokerName) {
        DefaultMQProducer defaultMQProducer = this.mqMap.get(nameServer);
        if (null == defaultMQProducer) {
            defaultMQProducer = new DefaultMQProducer("hera_log");
            defaultMQProducer.setNamesrvAddr(nameServer);
            try {
                defaultMQProducer.start();
            }
            catch (MQClientException e) {
                log.info("create mq producer error,nameServer:{}", (Object)nameServer, (Object)e);
                throw new MilogManageException("create mq producer error", e);
            }
            this.mqMap.put(nameServer, defaultMQProducer);
        }
        List<String> commonTagTopicNames = this.generateCommonTagTopicName(orgId);
        try {
            for (String commonTagTopicName : commonTagTopicNames) {
                defaultMQProducer.createTopic(brokerName, commonTagTopicName, 1);
            }
        }
        catch (MQClientException e) {
            log.info("create mq common topic error,nameServer:{}", (Object)nameServer, (Object)e);
            throw new MilogManageException("create mq common topic error", e);
        }
        return commonTagTopicNames;
    }

    @Override
    public boolean CreateGroup(String ak, String sk, String nameServer) {
        return false;
    }

    public boolean createSubscribeGroup(String serviceUrl, String authorization, String orgId, Long spaceId, Long storeId, Long tailId, Long milogAppId) {
        return false;
    }

    public List<RocketMqResponseDTO.SubGroup> querySubGroupList(String serviceUrl, String authorization, String orgId) {
        return Lists.newArrayList();
    }

    public boolean deleteSubscribeGroup(String serviceUrl, String authorization, String orgId, Long spaceId, Long storeId, Long tailId) {
        return false;
    }
}

