/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.el.parse;

import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.nutz.el.ElException;
import org.nutz.el.Parse;
import org.nutz.el.obj.Elobj;
import org.nutz.el.obj.FieldObj;
import org.nutz.el.obj.IdentifierObj;
import org.nutz.el.obj.MethodObj;
import org.nutz.el.opt.arithmetic.LBracketOpt;
import org.nutz.el.opt.arithmetic.NegativeOpt;
import org.nutz.el.opt.arithmetic.RBracketOpt;
import org.nutz.el.opt.arithmetic.SubOpt;
import org.nutz.el.opt.object.AccessOpt;
import org.nutz.el.opt.object.CommaOpt;
import org.nutz.el.opt.object.InvokeMethodOpt;
import org.nutz.el.opt.object.MethodOpt;
import org.nutz.el.parse.CharQueue;
import org.nutz.el.parse.CharQueueDefault;
import org.nutz.el.parse.IdentifierParse;
import org.nutz.el.parse.OptParse;
import org.nutz.el.parse.StringParse;
import org.nutz.el.parse.ValParse;
import org.nutz.lang.Lang;

public class Converter {
    private final List<Parse> parses = new ArrayList<Parse>();
    private CharQueue exp;
    private LinkedList<Object> itemCache;
    private LinkedList<MethodOpt> methods = new LinkedList();
    private Object prev = null;

    public Converter(CharQueue reader) {
        this.exp = reader;
        this.itemCache = new LinkedList();
        this.skipSpace();
        this.initParse();
    }

    public Converter(String val) {
        this(Lang.inr(val));
    }

    public Converter(Reader reader) {
        this(new CharQueueDefault(reader));
    }

    private void initParse() {
        this.parses.add(new OptParse());
        this.parses.add(new StringParse());
        this.parses.add(new IdentifierParse());
        this.parses.add(new ValParse());
    }

    public void setParse(List<Parse> val) {
        this.parses.addAll(val);
    }

    public void initItems() {
        while (!this.exp.isEmpty()) {
            Object obj = this.parseItem();
            if (obj.getClass().isArray()) {
                for (Object o : (Object[])obj) {
                    this.itemCache.add(o);
                }
                continue;
            }
            this.itemCache.add(obj);
        }
        this.itemCache = this.clearUp(this.itemCache);
    }

    private LinkedList<Object> clearUp(LinkedList<Object> rpn) {
        LinkedList<Object> dest = new LinkedList<Object>();
        while (!rpn.isEmpty()) {
            if (!(rpn.getFirst() instanceof Elobj)) {
                dest.add(rpn.removeFirst());
                continue;
            }
            Elobj obj = (Elobj)rpn.removeFirst();
            if (!rpn.isEmpty() && rpn.getFirst() instanceof MethodOpt) {
                dest.add(new MethodObj(obj.getVal()));
                continue;
            }
            if (dest.size() > 0 && dest.getLast() instanceof AccessOpt && rpn.size() > 0 && rpn.getFirst() instanceof AccessOpt) {
                dest.add(new FieldObj(obj.getVal()));
                continue;
            }
            dest.add(new IdentifierObj(obj.getVal()));
        }
        return dest;
    }

    private Object parseItem() {
        Object obj = Parse.nullobj;
        for (Parse parse : this.parses) {
            obj = parse.fetchItem(this.exp);
            if (obj == Parse.nullobj) continue;
            this.skipSpace();
            return this.parseItem(obj);
        }
        throw new ElException("\u65e0\u6cd5\u89e3\u6790!");
    }

    private Object parseItem(Object item) {
        if (this.methods.peek() != null) {
            MethodOpt opt = this.methods.peek();
            if (opt.getSize() <= 0) {
                if (!(item instanceof CommaOpt) && !(item instanceof RBracketOpt)) {
                    opt.setSize(1);
                }
            } else if (item instanceof CommaOpt) {
                opt.setSize(opt.getSize() + 1);
            }
        }
        if (item instanceof LBracketOpt) {
            if (this.prev instanceof Elobj) {
                MethodOpt prem = new MethodOpt();
                item = new Object[]{prem, new LBracketOpt()};
                this.methods.addFirst(prem);
            } else {
                this.methods.addFirst(null);
            }
        }
        if (item instanceof RBracketOpt && this.methods.poll() != null) {
            item = new Object[]{new RBracketOpt(), new InvokeMethodOpt()};
        }
        if (item instanceof SubOpt && NegativeOpt.isNegetive(this.prev)) {
            item = new NegativeOpt();
        }
        this.prev = item;
        return item;
    }

    private boolean skipSpace() {
        boolean space = false;
        while (!this.exp.isEmpty() && Character.isWhitespace(this.exp.peek())) {
            space = true;
            this.exp.poll();
        }
        return space;
    }

    public Object fetchItem() {
        return this.itemCache.poll();
    }

    public boolean isEnd() {
        return this.itemCache.isEmpty();
    }
}

