import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import * as ReactDOM from "react-dom";
import { Envelope } from "@kie-tools-core/envelope";
import { ProcessFormEnvelopeView } from "./ProcessFormEnvelopeView";
import { ProcessFormEnvelopeApiImpl } from "./ProcessFormEnvelopeApiImpl";
import "./styles.css";
export function init(args) {
    const envelope = new Envelope(args.bus, args.config);
    const envelopeViewDelegate = async () => {
        const ref = React.createRef();
        return new Promise((res) => {
            args.container.className = "kogito-process-form-container";
            ReactDOM.render(_jsx(ProcessFormEnvelopeView, { ref: ref, channelApi: envelope.channelApi, targetOrigin: args.targetOrigin }), args.container, () => res(() => ref.current));
        });
    };
    const context = {};
    return envelope.start(envelopeViewDelegate, context, {
        create: (apiFactoryArgs) => new ProcessFormEnvelopeApiImpl(apiFactoryArgs),
    });
}
//# sourceMappingURL=ProcessFormEnvelope.js.map