import { DefaultUser } from "./Auth";
export class KeycloakUserContext {
    constructor(keycloakInfo) {
        this.currentUser = new DefaultUser(keycloakInfo.userName, keycloakInfo.roles);
        this.tokenMinValidity = keycloakInfo.tokenMinValidity;
        this.token = keycloakInfo.token;
        this.handleLogout = keycloakInfo.logout;
    }
    logout() {
        this.handleLogout();
    }
    getCurrentUser() {
        return this.currentUser;
    }
    getToken() {
        return this.token;
    }
    setToken(token) {
        this.token = token;
    }
    getTokenMinValidity() {
        return this.tokenMinValidity;
    }
}
//# sourceMappingURL=KeycloakUserContext.js.map