import { useCallback, useMemo, useState } from "react";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { findDataTypeById, getNewItemDefinition } from "./DataTypeSpec";
const NAME_SEPARATOR = "-";
export var JavaClassConflictOptions;
(function (JavaClassConflictOptions) {
    JavaClassConflictOptions["REPLACE"] = "Replace";
    JavaClassConflictOptions["KEEP_BOTH"] = "Keep Both";
})(JavaClassConflictOptions || (JavaClassConflictOptions = {}));
const useImportJavaClasses = () => {
    const [isConflictsOccured, setIsConflictsOccured] = useState(false);
    const [conflictsClasses, setConflictsClasses] = useState([]);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const { externalModelsByNamespace } = useExternalModels();
    const allDataTypesById = useDmnEditorStore((s) => s.computed(s).getDataTypes(externalModelsByNamespace).allDataTypesById);
    const dataTypesTree = useDmnEditorStore((s) => s.computed(s).getDataTypes(externalModelsByNamespace).dataTypesTree);
    const dataTypeNames = useMemo(() => {
        var _a, _b, _c;
        const dataTypeNames = new Set();
        for (let i = 0, len = dataTypesTree === null || dataTypesTree === void 0 ? void 0 : dataTypesTree.length; i < len; i++) {
            dataTypeNames.add(((_a = dataTypesTree === null || dataTypesTree === void 0 ? void 0 : dataTypesTree[i]) === null || _a === void 0 ? void 0 : _a.feelName) || ((_c = (_b = dataTypesTree === null || dataTypesTree === void 0 ? void 0 : dataTypesTree[i]) === null || _b === void 0 ? void 0 : _b.itemDefinition) === null || _c === void 0 ? void 0 : _c["@_name"]));
        }
        return dataTypeNames;
    }, [dataTypesTree]);
    const buildName = useCallback((nameCandidate, namesCount, nameSeparator = NAME_SEPARATOR) => {
        if (namesCount.has(nameCandidate)) {
            const occurrences = namesCount.get(nameCandidate);
            namesCount.set(nameCandidate, occurrences + 1);
            return nameCandidate + nameSeparator + occurrences;
        }
        namesCount.set(nameCandidate, 1);
        return nameCandidate;
    }, []);
    const updatePropertiesReferences = useCallback((javaClasses, javaClassNameToDMNTypeNameMap) => {
        return javaClasses.map((javaClass) => {
            var _a, _b;
            const namesCount = new Map();
            const updatedFields = (_b = (_a = (javaClass !== null && javaClass !== void 0 ? javaClass : [])) === null || _a === void 0 ? void 0 : _a.fields) === null || _b === void 0 ? void 0 : _b.map((field) => {
                const newFieldName = buildName(field === null || field === void 0 ? void 0 : field.name, namesCount);
                if (javaClassNameToDMNTypeNameMap.has(field.type)) {
                    const renamedFieldType = javaClassNameToDMNTypeNameMap.get(field.type);
                    return { ...field, name: newFieldName, dmnTypeRef: renamedFieldType };
                }
                return { ...field, name: newFieldName };
            });
            return { ...javaClass, fields: updatedFields };
        });
    }, [buildName]);
    const editItemDefinition = useCallback((id, consumer) => {
        dmnEditorStoreApi.setState((state) => {
            var _a;
            var _b;
            const { itemDefinition, items, index } = findDataTypeById({
                definitions: state.dmn.model.definitions,
                itemDefinitionId: id,
                allDataTypesById,
            });
            (_a = (_b = state.dmn.model.definitions).itemDefinition) !== null && _a !== void 0 ? _a : (_b.itemDefinition = []);
            consumer(itemDefinition, items, index, state.dmn.model.definitions.itemDefinition, state);
        });
    }, [allDataTypesById, dmnEditorStoreApi]);
    const renameJavaClassToDMNName = useCallback((javaClasses) => {
        const namesCount = new Map();
        const javaClassNameToDMNTypeNameMap = new Map();
        const renamedJavaClasses = javaClasses.map((javaClass) => {
            const nameCandidate = javaClass.name.substring(javaClass.name.lastIndexOf(".") + 1);
            const newName = buildName(nameCandidate, namesCount);
            javaClassNameToDMNTypeNameMap.set(javaClass.name, newName);
            return { ...javaClass, name: newName };
        });
        return updatePropertiesReferences(renamedJavaClasses, javaClassNameToDMNTypeNameMap);
    }, [updatePropertiesReferences, buildName]);
    const generateUniqueDmnTypeNames = useCallback((javaClasses, nameSeparator = NAME_SEPARATOR) => {
        const namesCount = new Map();
        const javaClassNameToDMNTypeNameMap = new Map();
        const renamedJavaClasses = javaClasses.map((javaClass) => {
            let newName = javaClass.name;
            if (dataTypeNames.has(newName)) {
                if (!namesCount.has(newName)) {
                    namesCount.set(newName, 0);
                }
                let counter = namesCount.get(newName);
                do {
                    counter++;
                    newName = javaClass.name + nameSeparator + counter;
                } while (dataTypeNames.has(newName));
                namesCount.set(javaClass.name, counter);
            }
            else {
                namesCount.set(javaClass.name, 0);
            }
            javaClassNameToDMNTypeNameMap.set(javaClass.name, newName);
            return { ...javaClass, name: newName };
        });
        return updatePropertiesReferences(renamedJavaClasses, javaClassNameToDMNTypeNameMap);
    }, [updatePropertiesReferences, dataTypeNames]);
    const overwriteExistingDMNTypes = useCallback((javaClasses) => {
        var _a, _b, _c, _d;
        for (let i = 0, len = javaClasses === null || javaClasses === void 0 ? void 0 : javaClasses.length; i < len; i++) {
            const className = (_a = javaClasses === null || javaClasses === void 0 ? void 0 : javaClasses[i]) === null || _a === void 0 ? void 0 : _a.name;
            if (dataTypeNames === null || dataTypeNames === void 0 ? void 0 : dataTypeNames.has(className)) {
                const dataType = dataTypesTree === null || dataTypesTree === void 0 ? void 0 : dataTypesTree.find((type) => { var _a; return (type === null || type === void 0 ? void 0 : type.feelName) === className || ((_a = type === null || type === void 0 ? void 0 : type.itemDefinition) === null || _a === void 0 ? void 0 : _a["@_name"]) === className; });
                if (dataType && ((_b = dataType === null || dataType === void 0 ? void 0 : dataType.itemDefinition) === null || _b === void 0 ? void 0 : _b["@_id"])) {
                    const itemComponents = (_d = (_c = javaClasses === null || javaClasses === void 0 ? void 0 : javaClasses[i]) === null || _c === void 0 ? void 0 : _c.fields) === null || _d === void 0 ? void 0 : _d.map((field) => getNewItemDefinition({ "@_name": field === null || field === void 0 ? void 0 : field.name, typeRef: { __$$text: field === null || field === void 0 ? void 0 : field.dmnTypeRef } }));
                    if (itemComponents && (itemComponents === null || itemComponents === void 0 ? void 0 : itemComponents.length) > 0) {
                        editItemDefinition(dataType.itemDefinition["@_id"], (itemDefinition) => {
                            itemDefinition.itemComponent = itemComponents;
                        });
                    }
                }
            }
        }
    }, [dataTypeNames, dataTypesTree, editItemDefinition]);
    const checkNameConflicts = useCallback((javaClasses) => {
        const updatedJavaClasses = renameJavaClassToDMNName(javaClasses);
        const conflicts = [];
        const nonConflicts = [];
        for (let i = 0, len = updatedJavaClasses === null || updatedJavaClasses === void 0 ? void 0 : updatedJavaClasses.length; i < len; i++) {
            const javaClass = updatedJavaClasses === null || updatedJavaClasses === void 0 ? void 0 : updatedJavaClasses[i];
            const fullClassName = javaClass.name;
            if (dataTypeNames.has(fullClassName))
                conflicts.push(javaClass);
            else
                nonConflicts.push(javaClass);
        }
        return {
            conflicts,
            nonConflicts,
        };
    }, [renameJavaClassToDMNName, dataTypeNames]);
    const mapJavaClassesToDMNItemDefinitions = useCallback((javaClasses) => {
        return javaClasses === null || javaClasses === void 0 ? void 0 : javaClasses.map((javaClass) => {
            var _a;
            const itemsComponents = (_a = javaClass === null || javaClass === void 0 ? void 0 : javaClass.fields) === null || _a === void 0 ? void 0 : _a.map((field) => getNewItemDefinition({ "@_name": field === null || field === void 0 ? void 0 : field.name, typeRef: { __$$text: field === null || field === void 0 ? void 0 : field.dmnTypeRef } }));
            return getNewItemDefinition({ "@_name": javaClass === null || javaClass === void 0 ? void 0 : javaClass.name, typeRef: undefined, itemComponent: itemsComponents });
        });
    }, []);
    const importJavaClassesInDataTypeEditor = useCallback((javaClasses) => {
        if ((javaClasses === null || javaClasses === void 0 ? void 0 : javaClasses.length) === 0)
            return;
        const itemDefinitions = mapJavaClassesToDMNItemDefinitions(javaClasses);
        dmnEditorStoreApi.setState((state) => {
            var _a, _b, _c, _d;
            var _e;
            (_a = (_e = state.dmn.model.definitions).itemDefinition) !== null && _a !== void 0 ? _a : (_e.itemDefinition = []);
            (_b = state.dmn.model.definitions.itemDefinition) === null || _b === void 0 ? void 0 : _b.unshift(...itemDefinitions);
            state.dataTypesEditor.activeItemDefinitionId = (_c = itemDefinitions === null || itemDefinitions === void 0 ? void 0 : itemDefinitions[0]) === null || _c === void 0 ? void 0 : _c["@_id"];
            state.focus.consumableId = (_d = itemDefinitions === null || itemDefinitions === void 0 ? void 0 : itemDefinitions[0]) === null || _d === void 0 ? void 0 : _d["@_id"];
        });
    }, [dmnEditorStoreApi, mapJavaClassesToDMNItemDefinitions]);
    const handleImportJavaClasses = useCallback((javaClass) => {
        const { conflicts, nonConflicts } = checkNameConflicts(javaClass);
        if ((nonConflicts === null || nonConflicts === void 0 ? void 0 : nonConflicts.length) !== 0) {
            importJavaClassesInDataTypeEditor(nonConflicts);
        }
        if ((conflicts === null || conflicts === void 0 ? void 0 : conflicts.length) !== 0) {
            setIsConflictsOccured(true);
            setConflictsClasses(conflicts);
        }
    }, [checkNameConflicts, importJavaClassesInDataTypeEditor]);
    const handleConflictAction = useCallback((action) => {
        if ((conflictsClasses === null || conflictsClasses === void 0 ? void 0 : conflictsClasses.length) === 0)
            return;
        if (action === JavaClassConflictOptions.KEEP_BOTH) {
            const updatedJavaClasses = generateUniqueDmnTypeNames(conflictsClasses);
            importJavaClassesInDataTypeEditor(updatedJavaClasses);
        }
        else if (action === JavaClassConflictOptions.REPLACE) {
            overwriteExistingDMNTypes(conflictsClasses);
        }
        setIsConflictsOccured(false);
        setConflictsClasses([]);
    }, [conflictsClasses, generateUniqueDmnTypeNames, importJavaClassesInDataTypeEditor, overwriteExistingDMNTypes]);
    return {
        handleImportJavaClasses,
        handleConflictAction,
        conflictsClasses,
        isConflictsOccured,
    };
};
export { useImportJavaClasses };
//# sourceMappingURL=useImportJavaClasses.js.map