import { Actions } from "./Actions";
import { Attribute, CompoundPredicate, Predicate, SimplePredicate } from "@kie-tools/pmml-editor-marshaller";
import { immerable } from "immer";
import { Builder } from "../paths";
Attribute[immerable] = true;
Predicate[immerable] = true;
SimplePredicate[immerable] = true;
CompoundPredicate[immerable] = true;
export const AttributesReducer = (historyService) => {
    return (state, action) => {
        switch (action.type) {
            case Actions.Scorecard_AddAttribute:
                historyService.batch(state, Builder()
                    .forModel(action.payload.modelIndex)
                    .forCharacteristics()
                    .forCharacteristic(action.payload.characteristicIndex)
                    .forAttribute()
                    .build(), (draft) => {
                    draft.push({
                        predicate: action.payload.predicate,
                        partialScore: action.payload.partialScore,
                        reasonCode: action.payload.reasonCode,
                    });
                });
                break;
            case Actions.Scorecard_DeleteAttribute:
                historyService.batch(state, Builder()
                    .forModel(action.payload.modelIndex)
                    .forCharacteristics()
                    .forCharacteristic(action.payload.characteristicIndex)
                    .forAttribute()
                    .build(), (draft) => {
                    const attributeIndex = action.payload.attributeIndex;
                    if (attributeIndex >= 0 && attributeIndex < draft.length) {
                        draft.splice(attributeIndex, 1);
                    }
                });
                break;
            case Actions.Scorecard_UpdateAttribute:
                historyService.batch(state, Builder()
                    .forModel(action.payload.modelIndex)
                    .forCharacteristics()
                    .forCharacteristic(action.payload.characteristicIndex)
                    .forAttribute()
                    .build(), (draft) => {
                    const attributeIndex = action.payload.attributeIndex;
                    if (attributeIndex >= 0 && attributeIndex < draft.length) {
                        draft[attributeIndex] = {
                            ...draft[attributeIndex],
                            predicate: action.payload.predicate,
                            partialScore: action.payload.partialScore,
                            reasonCode: action.payload.reasonCode,
                        };
                    }
                });
        }
        return state;
    };
};
//# sourceMappingURL=AttributesReducer.js.map