# iggy

![Version: 0.2.0](https://img.shields.io/badge/Version-0.2.0-informational?style=flat-square) ![Type: application](https://img.shields.io/badge/Type-application-informational?style=flat-square) ![AppVersion: 0.5.0](https://img.shields.io/badge/AppVersion-0.5.0-informational?style=flat-square)

A Helm chart for Apache Iggy server and web-ui

## Source Code

* <https://github.com/apache/iggy>

## Values

| Key                                          | Type   | Default                                                                                                             | Description                                                                                                                                                                                                                                                                                                             |
|----------------------------------------------|--------|---------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| additionalLabels                             | object | `{}`                                                                                                                | Additional labels to add to all resources                                                                                                                                                                                                                                                                               |
| autoscaling.enabled                          | bool   | `false`                                                                                                             |                                                                                                                                                                                                                                                                                                                         |
| autoscaling.maxReplicas                      | int    | `100`                                                                                                               |                                                                                                                                                                                                                                                                                                                         |
| autoscaling.minReplicas                      | int    | `1`                                                                                                                 |                                                                                                                                                                                                                                                                                                                         |
| autoscaling.targetCPUUtilizationPercentage   | int    | `80`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| fullnameOverride                             | string | `""`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| imagePullSecrets                             | list   | `[]`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| nameOverride                                 | string | `""`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| podAnnotations                               | object | `{}`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| podSecurityContext                           | object | `{}`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| resources                                    | object | `{}`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| securityContext                              | object | `{}`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| server.affinity                              | object | `{}`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| server.enabled                               | bool   | `true`                                                                                                              |                                                                                                                                                                                                                                                                                                                         |
| server.env                                   | list   | `[{"name":"RUST_LOG","value":"info"}]`                                                                              | Set up environmental variables to be added to the container                                                                                                                                                                                                                                                             |
| server.image.pullPolicy                      | string | `"IfNotPresent"`                                                                                                    |                                                                                                                                                                                                                                                                                                                         |
| server.image.repository                      | string | `"apache/iggy"`                                                                                                     |                                                                                                                                                                                                                                                                                                                         |
| server.image.tag                             | string | `""`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| server.ingress.annotations                   | object | `{}`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| server.ingress.className                     | string | `""`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| server.ingress.enabled                       | bool   | `false`                                                                                                             |                                                                                                                                                                                                                                                                                                                         |
| server.ingress.hosts[0].host                 | string | `"chart-example.local"`                                                                                             |                                                                                                                                                                                                                                                                                                                         |
| server.ingress.hosts[0].paths[0].path        | string | `"/"`                                                                                                               |                                                                                                                                                                                                                                                                                                                         |
| server.ingress.hosts[0].paths[0].pathType    | string | `"ImplementationSpecific"`                                                                                          |                                                                                                                                                                                                                                                                                                                         |
| server.ingress.tls                           | list   | `[]`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| server.nodeSelector                          | object | `{}`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| server.persistence                           | object | `{"accessMode":"ReadWriteOnce","annotations":{},"enabled":false,"existingClaim":"","size":"8Gi","storageClass":""}` | Add persistence volume claim configuration                                                                                                                                                                                                                                                                              |
| server.persistence.accessMode                | string | `"ReadWriteOnce"`                                                                                                   | PVC Access mode                                                                                                                                                                                                                                                                                                         |
| server.persistence.annotations               | object | `{}`                                                                                                                | PVC annotations                                                                                                                                                                                                                                                                                                         |
| server.persistence.enabled                   | bool   | `false`                                                                                                             | Enable persistence using a PVC                                                                                                                                                                                                                                                                                          |
| server.persistence.existingClaim             | string | `""`                                                                                                                | A manually managed Persistent Volume and Claim Requires persistence.enabled: true If defined, PVC must be created manually before volume will be bound                                                                                                                                                                  |
| server.persistence.size                      | string | `"8Gi"`                                                                                                             | PVC claim size                                                                                                                                                                                                                                                                                                          |
| server.persistence.storageClass              | string | `""`                                                                                                                | Persistent Volume Storage Class If defined, storageClassName: <storageClass> If set to "-", storageClassName: "", which disables dynamic provisioning If undefined (the default) or set to null, no storageClassName spec is   set, choosing the default provisioner.  (gp2 on AWS, standard on   GKE, AWS & OpenStack) |
| server.ports.http                            | int    | `3000`                                                                                                              |                                                                                                                                                                                                                                                                                                                         |
| server.ports.quic                            | int    | `8080`                                                                                                              |                                                                                                                                                                                                                                                                                                                         |
| server.ports.tcp                             | int    | `8090`                                                                                                              |                                                                                                                                                                                                                                                                                                                         |
| server.replicaCount                          | int    | `1`                                                                                                                 |                                                                                                                                                                                                                                                                                                                         |
| server.service.port                          | int    | `3000`                                                                                                              |                                                                                                                                                                                                                                                                                                                         |
| server.service.type                          | string | `"ClusterIP"`                                                                                                       |                                                                                                                                                                                                                                                                                                                         |
| server.serviceMonitor.additionalLabels       | object | `{}`                                                                                                                | Add custom labels to the ServiceMonitor resource                                                                                                                                                                                                                                                                        |
| server.serviceMonitor.enabled                | bool   | `true`                                                                                                              | Enable this if you're using [Prometheus Operator](https://github.com/coreos/prometheus-operator)                                                                                                                                                                                                                        |
| server.serviceMonitor.honorLabels            | bool   | `false`                                                                                                             |                                                                                                                                                                                                                                                                                                                         |
| server.serviceMonitor.interval               | string | `"30s"`                                                                                                             | Fallback to the prometheus default unless specified                                                                                                                                                                                                                                                                     |
| server.serviceMonitor.namespace              | string | `""`                                                                                                                | Namespace to deploy the ServiceMonitor                                                                                                                                                                                                                                                                                  |
| server.serviceMonitor.path                   | string | `"/metrics"`                                                                                                        | Path to scrape metrics                                                                                                                                                                                                                                                                                                  |
| server.serviceMonitor.scrapeTimeout          | string | `"10s"`                                                                                                             | Timeout for scrape metrics request                                                                                                                                                                                                                                                                                      |
| server.tolerations                           | list   | `[]`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| server.users.root.createSecret               | bool   | `true`                                                                                                              | Create a secret for the root user                                                                                                                                                                                                                                                                                       |
| server.users.root.existingSecret             | object | `{"name":"","passwordKey":"password","usernameKey":"username"}`                                                     | Whether to use an existing secret for the root user                                                                                                                                                                                                                                                                     |
| server.users.root.existingSecret.passwordKey | string | `"password"`                                                                                                        | Key in the secret to get the root password from                                                                                                                                                                                                                                                                         |
| server.users.root.existingSecret.usernameKey | string | `"username"`                                                                                                        | Key in the secret to get the root username from                                                                                                                                                                                                                                                                         |
| server.users.root.password                   | string | `"changeit"`                                                                                                        |                                                                                                                                                                                                                                                                                                                         |
| server.users.root.username                   | string | `"iggy"`                                                                                                            |                                                                                                                                                                                                                                                                                                                         |
| serviceAccount.annotations                   | object | `{}`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| serviceAccount.create                        | bool   | `true`                                                                                                              |                                                                                                                                                                                                                                                                                                                         |
| serviceAccount.name                          | string | `""`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| ui.affinity                                  | object | `{}`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| ui.enabled                                   | bool   | `true`                                                                                                              |                                                                                                                                                                                                                                                                                                                         |
| ui.env                                       | object | `{}`                                                                                                                | Extra environmental variables to add to the container                                                                                                                                                                                                                                                                   |
| ui.image.pullPolicy                          | string | `"IfNotPresent"`                                                                                                    |                                                                                                                                                                                                                                                                                                                         |
| ui.image.repository                          | string | `"apache/iggy-web-ui"`                                                                                              |                                                                                                                                                                                                                                                                                                                         |
| ui.image.tag                                 | string | `"latest"`                                                                                                          |                                                                                                                                                                                                                                                                                                                         |
| ui.ingress.annotations                       | object | `{}`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| ui.ingress.className                         | string | `""`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| ui.ingress.enabled                           | bool   | `false`                                                                                                             |                                                                                                                                                                                                                                                                                                                         |
| ui.ingress.hosts[0].host                     | string | `"chart-example.local"`                                                                                             |                                                                                                                                                                                                                                                                                                                         |
| ui.ingress.hosts[0].paths[0].path            | string | `"/"`                                                                                                               |                                                                                                                                                                                                                                                                                                                         |
| ui.ingress.hosts[0].paths[0].pathType        | string | `"ImplementationSpecific"`                                                                                          |                                                                                                                                                                                                                                                                                                                         |
| ui.ingress.tls                               | list   | `[]`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| ui.nodeSelector                              | object | `{}`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| ui.ports.http                                | int    | `3050`                                                                                                              |                                                                                                                                                                                                                                                                                                                         |
| ui.replicaCount                              | int    | `1`                                                                                                                 |                                                                                                                                                                                                                                                                                                                         |
| ui.resources                                 | object | `{}`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |
| ui.server.endpoint                           | string | `""`                                                                                                                | Set the Iggy server endpoint explicitly. If kept blank, the Iggy service URL will be used                                                                                                                                                                                                                               |
| ui.service.port                              | int    | `3050`                                                                                                              |                                                                                                                                                                                                                                                                                                                         |
| ui.service.type                              | string | `"ClusterIP"`                                                                                                       |                                                                                                                                                                                                                                                                                                                         |
| ui.tolerations                               | list   | `[]`                                                                                                                |                                                                                                                                                                                                                                                                                                                         |

----------------------------------------------
Autogenerated from chart metadata using [helm-docs v1.14.2](https://github.com/norwoodj/helm-docs/releases/v1.14.2)
