/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.value;

import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.value.ClickHouseObjectValue;
import com.clickhouse.data.value.ClickHouseOffsetDateTimeValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class ClickHouseDateValue
extends ClickHouseObjectValue<LocalDate> {
    public static final LocalDate DEFAULT = ClickHouseOffsetDateTimeValue.DEFAULT.toLocalDate();

    public static ClickHouseDateValue ofNull() {
        return ClickHouseDateValue.ofNull(null);
    }

    public static ClickHouseDateValue ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseDateValue ? (ClickHouseDateValue)((ClickHouseDateValue)ref).set(null) : new ClickHouseDateValue(null);
    }

    public static ClickHouseDateValue of(LocalDate value) {
        return ClickHouseDateValue.of(null, value);
    }

    public static ClickHouseDateValue of(long epochDay) {
        return ClickHouseDateValue.of(null, LocalDate.ofEpochDay(epochDay));
    }

    public static ClickHouseDateValue of(ClickHouseValue ref, LocalDate value) {
        return ref instanceof ClickHouseDateValue ? ((ClickHouseDateValue)ref).update(value) : new ClickHouseDateValue(value);
    }

    protected ClickHouseDateValue(LocalDate value) {
        super(value);
    }

    @Override
    public ClickHouseDateValue copy(boolean deep) {
        return new ClickHouseDateValue((LocalDate)this.getValue());
    }

    @Override
    public byte asByte() {
        return (byte)this.asLong();
    }

    @Override
    public short asShort() {
        return (short)this.asLong();
    }

    @Override
    public int asInteger() {
        return (int)this.asLong();
    }

    @Override
    public long asLong() {
        return this.isNullOrEmpty() ? 0L : ((LocalDate)this.getValue()).toEpochDay();
    }

    @Override
    public BigInteger asBigInteger() {
        return this.isNullOrEmpty() ? null : BigInteger.valueOf(((LocalDate)this.getValue()).toEpochDay());
    }

    @Override
    public float asFloat() {
        return this.asLong();
    }

    @Override
    public double asDouble() {
        return this.asLong();
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        return this.isNullOrEmpty() ? null : new BigDecimal(this.asBigInteger(), scale);
    }

    @Override
    public LocalDate asDate() {
        return (LocalDate)this.getValue();
    }

    @Override
    public final LocalTime asTime(int scale) {
        return this.isNullOrEmpty() ? null : LocalTime.ofSecondOfDay(0L);
    }

    @Override
    public LocalDateTime asDateTime(int scale) {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return LocalDateTime.of((LocalDate)this.getValue(), ClickHouseValues.TIME_ZERO);
    }

    @Override
    public String asString() {
        if (this.isNullOrEmpty()) {
            return null;
        }
        return this.asDate().format(ClickHouseValues.DATE_FORMATTER);
    }

    @Override
    public ClickHouseDateValue resetToDefault() {
        this.set(DEFAULT);
        return this;
    }

    @Override
    public String toSqlExpression() {
        if (this.isNullOrEmpty()) {
            return "NULL";
        }
        return '\'' + this.asDate().format(ClickHouseValues.DATE_FORMATTER) + '\'';
    }

    @Override
    public ClickHouseDateValue update(byte value) {
        this.set(LocalDate.ofEpochDay(value));
        return this;
    }

    @Override
    public ClickHouseDateValue update(short value) {
        this.set(LocalDate.ofEpochDay(value));
        return this;
    }

    @Override
    public ClickHouseDateValue update(int value) {
        this.set(LocalDate.ofEpochDay(value));
        return this;
    }

    @Override
    public ClickHouseDateValue update(long value) {
        this.set(LocalDate.ofEpochDay(value));
        return this;
    }

    @Override
    public ClickHouseDateValue update(float value) {
        this.set(LocalDate.ofEpochDay((long)value));
        return this;
    }

    @Override
    public ClickHouseDateValue update(double value) {
        this.set(LocalDate.ofEpochDay((long)value));
        return this;
    }

    @Override
    public ClickHouseDateValue update(BigInteger value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDate.ofEpochDay(value.longValue()));
        }
        return this;
    }

    @Override
    public ClickHouseDateValue update(BigDecimal value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDate.ofEpochDay(value.longValue()));
        }
        return this;
    }

    @Override
    public ClickHouseDateValue update(Enum<?> value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(LocalDate.ofEpochDay(value.ordinal()));
        }
        return this;
    }

    @Override
    public ClickHouseDateValue update(LocalDate value) {
        this.set(value);
        return this;
    }

    @Override
    public ClickHouseDateValue update(LocalTime value) {
        return this;
    }

    @Override
    public ClickHouseDateValue update(LocalDateTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.toLocalDate());
        }
        return this;
    }

    @Override
    public ClickHouseDateValue update(String value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else if (value.isEmpty()) {
            this.resetToDefault();
        } else {
            this.set(LocalDate.parse(value, ClickHouseValues.DATE_FORMATTER));
        }
        return this;
    }

    @Override
    public ClickHouseDateValue update(ClickHouseValue value) {
        if (value == null || value.isNullOrEmpty()) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.asDate());
        }
        return this;
    }

    @Override
    public ClickHouseDateValue update(Object value) {
        if (value instanceof LocalDate) {
            this.set((LocalDate)value);
        } else if (value instanceof LocalDateTime) {
            this.set(((LocalDateTime)value).toLocalDate());
        } else if (value instanceof LocalTime) {
            this.set(LocalDate.now());
        } else {
            super.update(value);
        }
        return this;
    }
}

