/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.common.util;

public final class Ensures {
    public static <T> T ensureNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T> T ensureNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static <T> T ensureNonNull(T obj, String fmt, Object ... args) {
        if (obj == null) {
            throw new NullPointerException(String.format(fmt, args));
        }
        return obj;
    }

    public static void ensure(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void ensure(boolean expression, Object message) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(message));
        }
    }

    public static void ensure(boolean expression, String fmt, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(fmt, args));
        }
    }

    private Ensures() {
    }
}

