/*
 * Decompiled with CFR 0.152.
 */
package com.google.flatbuffers;

import com.google.flatbuffers.ReadWriteBuf;
import com.google.flatbuffers.Utf8Safe;
import java.util.Arrays;

public class ArrayReadWriteBuf
implements ReadWriteBuf {
    private byte[] buffer;
    private int writePos;

    public ArrayReadWriteBuf() {
        this(10);
    }

    public ArrayReadWriteBuf(int initialCapacity) {
        this(new byte[initialCapacity]);
    }

    public ArrayReadWriteBuf(byte[] buffer) {
        this.buffer = buffer;
        this.writePos = 0;
    }

    public ArrayReadWriteBuf(byte[] buffer, int startPos) {
        this.buffer = buffer;
        this.writePos = startPos;
    }

    @Override
    public void clear() {
        this.writePos = 0;
    }

    @Override
    public boolean getBoolean(int index) {
        return this.buffer[index] != 0;
    }

    @Override
    public byte get(int index) {
        return this.buffer[index];
    }

    @Override
    public short getShort(int index) {
        return (short)(this.buffer[index + 1] << 8 | this.buffer[index] & 0xFF);
    }

    @Override
    public int getInt(int index) {
        return this.buffer[index + 3] << 24 | (this.buffer[index + 2] & 0xFF) << 16 | (this.buffer[index + 1] & 0xFF) << 8 | this.buffer[index] & 0xFF;
    }

    @Override
    public long getLong(int index) {
        return (long)this.buffer[index++] & 0xFFL | ((long)this.buffer[index++] & 0xFFL) << 8 | ((long)this.buffer[index++] & 0xFFL) << 16 | ((long)this.buffer[index++] & 0xFFL) << 24 | ((long)this.buffer[index++] & 0xFFL) << 32 | ((long)this.buffer[index++] & 0xFFL) << 40 | ((long)this.buffer[index++] & 0xFFL) << 48 | (long)this.buffer[index] << 56;
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public String getString(int start, int size) {
        return Utf8Safe.decodeUtf8Array(this.buffer, start, size);
    }

    @Override
    public byte[] data() {
        return this.buffer;
    }

    @Override
    public void putBoolean(boolean value) {
        this.setBoolean(this.writePos, value);
        ++this.writePos;
    }

    @Override
    public void put(byte[] value, int start, int length) {
        this.set(this.writePos, value, start, length);
        this.writePos += length;
    }

    @Override
    public void put(byte value) {
        this.set(this.writePos, value);
        ++this.writePos;
    }

    @Override
    public void putShort(short value) {
        this.setShort(this.writePos, value);
        this.writePos += 2;
    }

    @Override
    public void putInt(int value) {
        this.setInt(this.writePos, value);
        this.writePos += 4;
    }

    @Override
    public void putLong(long value) {
        this.setLong(this.writePos, value);
        this.writePos += 8;
    }

    @Override
    public void putFloat(float value) {
        this.setFloat(this.writePos, value);
        this.writePos += 4;
    }

    @Override
    public void putDouble(double value) {
        this.setDouble(this.writePos, value);
        this.writePos += 8;
    }

    @Override
    public void setBoolean(int index, boolean value) {
        this.set(index, value ? (byte)1 : 0);
    }

    @Override
    public void set(int index, byte value) {
        this.requestCapacity(index + 1);
        this.buffer[index] = value;
    }

    @Override
    public void set(int index, byte[] toCopy, int start, int length) {
        this.requestCapacity(index + (length - start));
        System.arraycopy(toCopy, start, this.buffer, index, length);
    }

    @Override
    public void setShort(int index, short value) {
        this.requestCapacity(index + 2);
        this.buffer[index++] = (byte)(value & 0xFF);
        this.buffer[index] = (byte)(value >> 8 & 0xFF);
    }

    @Override
    public void setInt(int index, int value) {
        this.requestCapacity(index + 4);
        this.buffer[index++] = (byte)(value & 0xFF);
        this.buffer[index++] = (byte)(value >> 8 & 0xFF);
        this.buffer[index++] = (byte)(value >> 16 & 0xFF);
        this.buffer[index] = (byte)(value >> 24 & 0xFF);
    }

    @Override
    public void setLong(int index, long value) {
        this.requestCapacity(index + 8);
        int i = (int)value;
        this.buffer[index++] = (byte)(i & 0xFF);
        this.buffer[index++] = (byte)(i >> 8 & 0xFF);
        this.buffer[index++] = (byte)(i >> 16 & 0xFF);
        this.buffer[index++] = (byte)(i >> 24 & 0xFF);
        i = (int)(value >> 32);
        this.buffer[index++] = (byte)(i & 0xFF);
        this.buffer[index++] = (byte)(i >> 8 & 0xFF);
        this.buffer[index++] = (byte)(i >> 16 & 0xFF);
        this.buffer[index] = (byte)(i >> 24 & 0xFF);
    }

    @Override
    public void setFloat(int index, float value) {
        this.requestCapacity(index + 4);
        int iValue = Float.floatToRawIntBits(value);
        this.buffer[index++] = (byte)(iValue & 0xFF);
        this.buffer[index++] = (byte)(iValue >> 8 & 0xFF);
        this.buffer[index++] = (byte)(iValue >> 16 & 0xFF);
        this.buffer[index] = (byte)(iValue >> 24 & 0xFF);
    }

    @Override
    public void setDouble(int index, double value) {
        this.requestCapacity(index + 8);
        long lValue = Double.doubleToRawLongBits(value);
        int i = (int)lValue;
        this.buffer[index++] = (byte)(i & 0xFF);
        this.buffer[index++] = (byte)(i >> 8 & 0xFF);
        this.buffer[index++] = (byte)(i >> 16 & 0xFF);
        this.buffer[index++] = (byte)(i >> 24 & 0xFF);
        i = (int)(lValue >> 32);
        this.buffer[index++] = (byte)(i & 0xFF);
        this.buffer[index++] = (byte)(i >> 8 & 0xFF);
        this.buffer[index++] = (byte)(i >> 16 & 0xFF);
        this.buffer[index] = (byte)(i >> 24 & 0xFF);
    }

    @Override
    public int limit() {
        return this.writePos;
    }

    @Override
    public int writePosition() {
        return this.writePos;
    }

    @Override
    public boolean requestCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity may not be negative (likely a previous int overflow)");
        }
        if (this.buffer.length >= capacity) {
            return true;
        }
        int oldCapacity = this.buffer.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity < capacity) {
            newCapacity = capacity;
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
        return true;
    }
}

