/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.models;

import io.greptime.common.Into;
import io.greptime.common.util.Ensures;
import io.greptime.models.RowHelper;
import io.greptime.models.TableSchema;
import io.greptime.v1.Common;
import io.greptime.v1.Database;
import io.greptime.v1.RowData;
import java.util.ArrayList;
import java.util.List;

public interface Table {
    public String tableName();

    public int rowCount();

    public int columnCount();

    default public int pointCount() {
        return this.rowCount() * this.columnCount();
    }

    public Table addRow(Object ... var1);

    public Table subRange(int var1, int var2);

    public Database.RowInsertRequest intoRowInsertRequest();

    public Database.RowDeleteRequest intoRowDeleteRequest();

    default public void checkNumValues(int len) {
        int columnCount = this.columnCount();
        Ensures.ensure((columnCount == len ? 1 : 0) != 0, (String)"Expected values num: %d, actual: %d", (Object[])new Object[]{columnCount, len});
    }

    public static Table from(TableSchema tableSchema) {
        return new Builder(tableSchema).build();
    }

    public static class RowBasedTable
    implements Table,
    Into<RowData.Rows> {
        private String tableName;
        private List<RowData.ColumnSchema> columnSchemas;
        private final List<RowData.Row> rows;

        public RowBasedTable() {
            this.rows = new ArrayList<RowData.Row>();
        }

        private RowBasedTable(String tableName, List<RowData.ColumnSchema> columnSchemas, List<RowData.Row> rows) {
            this.tableName = tableName;
            this.columnSchemas = columnSchemas;
            this.rows = rows;
        }

        @Override
        public String tableName() {
            return this.tableName;
        }

        @Override
        public int rowCount() {
            return this.rows.size();
        }

        @Override
        public int columnCount() {
            return this.columnSchemas.size();
        }

        @Override
        public Table addRow(Object ... values) {
            this.checkNumValues(values.length);
            RowData.Row.Builder rowBuilder = RowData.Row.newBuilder();
            for (int i = 0; i < values.length; ++i) {
                RowData.ColumnSchema columnSchema = this.columnSchemas.get(i);
                Object value = values[i];
                RowHelper.addValue(rowBuilder, columnSchema.getDatatype(), columnSchema.getDatatypeExtension(), value);
            }
            this.rows.add(rowBuilder.build());
            return this;
        }

        @Override
        public Table subRange(int fromIndex, int toIndex) {
            List<RowData.Row> rows = this.rows.subList(fromIndex, toIndex);
            return new RowBasedTable(this.tableName, this.columnSchemas, rows);
        }

        @Override
        public Database.RowInsertRequest intoRowInsertRequest() {
            return Database.RowInsertRequest.newBuilder().setTableName(this.tableName).setRows(this.into()).build();
        }

        @Override
        public Database.RowDeleteRequest intoRowDeleteRequest() {
            return Database.RowDeleteRequest.newBuilder().setTableName(this.tableName).setRows(this.into()).build();
        }

        public RowData.Rows into() {
            return RowData.Rows.newBuilder().addAllSchema(this.columnSchemas).addAllRows(this.rows).build();
        }
    }

    public static class Builder {
        private final TableSchema tableSchema;

        public Builder(TableSchema tableSchema) {
            this.tableSchema = tableSchema;
        }

        public Table build() {
            String tableName = this.tableSchema.getTableName();
            List<String> columnNames = this.tableSchema.getColumnNames();
            List<Common.SemanticType> semanticTypes = this.tableSchema.getSemanticTypes();
            List<Common.ColumnDataType> dataTypes = this.tableSchema.getDataTypes();
            List<Common.ColumnDataTypeExtension> dataTypeExtensions = this.tableSchema.getDataTypeExtensions();
            Ensures.ensureNonNull((Object)tableName, (String)"Null table name");
            Ensures.ensureNonNull(columnNames, (String)"Null column names");
            Ensures.ensureNonNull(semanticTypes, (String)"Null semantic types");
            Ensures.ensureNonNull(dataTypes, (String)"Null data types");
            int columnCount = columnNames.size();
            Ensures.ensure((columnCount > 0 ? 1 : 0) != 0, (Object)"Empty column names");
            Ensures.ensure((columnCount == semanticTypes.size() ? 1 : 0) != 0, (Object)"Column names size not equal to semantic types size");
            Ensures.ensure((columnCount == dataTypes.size() ? 1 : 0) != 0, (Object)"Column names size not equal to data types size");
            Ensures.ensure((columnCount == dataTypeExtensions.size() ? 1 : 0) != 0, (Object)"Column names size not equal to data type extensions size");
            return Builder.buildTable(tableName, columnCount, columnNames, semanticTypes, dataTypes, dataTypeExtensions);
        }

        private static Table buildTable(String tableName, int columnCount, List<String> columnNames, List<Common.SemanticType> semanticTypes, List<Common.ColumnDataType> dataTypes, List<Common.ColumnDataTypeExtension> dataTypeExtensions) {
            RowBasedTable table = new RowBasedTable();
            table.tableName = tableName;
            table.columnSchemas = new ArrayList(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                RowData.ColumnSchema.Builder builder = RowData.ColumnSchema.newBuilder();
                builder.setColumnName(columnNames.get(i)).setSemanticType(semanticTypes.get(i)).setDatatype(dataTypes.get(i)).setDatatypeExtension(dataTypeExtensions.get(i));
                table.columnSchemas.add(builder.build());
            }
            return table;
        }
    }
}

