/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import java.io.IOException;
import java.util.Properties;
import org.apache.gravitino.dto.VersionDTO;
import org.apache.gravitino.exceptions.GravitinoRuntimeException;

public class Version {
    private static final Version INSTANCE = new Version();
    private VersionInfo versionInfo;
    private VersionDTO versionDTO;

    private Version() {
        Properties projectProperties = new Properties();
        try {
            VersionInfo currentVersionInfo = new VersionInfo();
            projectProperties.load(Version.class.getClassLoader().getResourceAsStream("gravitino-build-info.properties"));
            currentVersionInfo.version = projectProperties.getProperty("project.version");
            currentVersionInfo.compileDate = projectProperties.getProperty("compile.date");
            currentVersionInfo.gitCommit = projectProperties.getProperty("git.commit.id");
            this.versionInfo = currentVersionInfo;
            this.versionDTO = new VersionDTO(currentVersionInfo.version, currentVersionInfo.compileDate, currentVersionInfo.gitCommit);
        }
        catch (IOException e) {
            throw new GravitinoRuntimeException(e, "Failed to get Gravitino version", new Object[0]);
        }
    }

    public static VersionInfo getCurrentVersion() {
        return Version.INSTANCE.versionInfo;
    }

    public static VersionDTO getCurrentVersionDTO() {
        return Version.INSTANCE.versionDTO;
    }

    public static class VersionInfo {
        public String version;
        public String compileDate;
        public String gitCommit;
    }
}

