/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.util.NaNUtil;

public class BoundUnaryPredicate<T>
extends BoundPredicate<T> {
    BoundUnaryPredicate(Expression.Operation op, BoundTerm<T> term) {
        super(op, term);
    }

    @Override
    public Expression negate() {
        return new BoundUnaryPredicate<T>(this.op().negate(), (BoundTerm)this.term());
    }

    @Override
    public boolean isUnaryPredicate() {
        return true;
    }

    @Override
    public BoundUnaryPredicate<T> asUnaryPredicate() {
        return this;
    }

    @Override
    public boolean test(T value) {
        switch (this.op()) {
            case IS_NULL: {
                return value == null;
            }
            case NOT_NULL: {
                return value != null;
            }
            case IS_NAN: {
                return NaNUtil.isNaN(value);
            }
            case NOT_NAN: {
                return !NaNUtil.isNaN(value);
            }
        }
        throw new IllegalStateException("Invalid operation for BoundUnaryPredicate: " + (Object)((Object)this.op()));
    }

    @Override
    public boolean isEquivalentTo(Expression other) {
        if (this.op() == other.op()) {
            return ((BoundTerm)this.term()).isEquivalentTo((BoundTerm)((BoundUnaryPredicate)other).term());
        }
        return false;
    }

    public String toString() {
        switch (this.op()) {
            case IS_NULL: {
                return "is_null(" + this.term() + ")";
            }
            case NOT_NULL: {
                return "not_null(" + this.term() + ")";
            }
            case IS_NAN: {
                return "is_nan(" + this.term() + ")";
            }
            case NOT_NAN: {
                return "not_nan(" + this.term() + ")";
            }
        }
        return "Invalid unary predicate: operation = " + (Object)((Object)this.op());
    }
}

