/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.client;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.grpc.MethodDescriptor;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import org.apache.bifromq.baseenv.EnvProvider;
import org.apache.bifromq.basekv.RPCBluePrint;
import org.apache.bifromq.basekv.client.BaseKVStoreClientBuilder;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.client.IMutationPipeline;
import org.apache.bifromq.basekv.client.IQueryPipeline;
import org.apache.bifromq.basekv.client.KVRangeRouterUtil;
import org.apache.bifromq.basekv.client.KVRangeSetting;
import org.apache.bifromq.basekv.client.ManagedMutationPipeline;
import org.apache.bifromq.basekv.client.ManagedQueryPipeline;
import org.apache.bifromq.basekv.metaservice.IBaseKVLandscapeObserver;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.KVRangeId;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.raft.proto.RaftNodeStatus;
import org.apache.bifromq.basekv.store.proto.BaseKVStoreServiceGrpc;
import org.apache.bifromq.basekv.store.proto.BootstrapReply;
import org.apache.bifromq.basekv.store.proto.BootstrapRequest;
import org.apache.bifromq.basekv.store.proto.ChangeReplicaConfigReply;
import org.apache.bifromq.basekv.store.proto.ChangeReplicaConfigRequest;
import org.apache.bifromq.basekv.store.proto.KVRangeMergeReply;
import org.apache.bifromq.basekv.store.proto.KVRangeMergeRequest;
import org.apache.bifromq.basekv.store.proto.KVRangeROReply;
import org.apache.bifromq.basekv.store.proto.KVRangeRORequest;
import org.apache.bifromq.basekv.store.proto.KVRangeRWReply;
import org.apache.bifromq.basekv.store.proto.KVRangeRWRequest;
import org.apache.bifromq.basekv.store.proto.KVRangeSplitReply;
import org.apache.bifromq.basekv.store.proto.KVRangeSplitRequest;
import org.apache.bifromq.basekv.store.proto.RecoverReply;
import org.apache.bifromq.basekv.store.proto.RecoverRequest;
import org.apache.bifromq.basekv.store.proto.ReplyCode;
import org.apache.bifromq.basekv.store.proto.TransferLeadershipReply;
import org.apache.bifromq.basekv.store.proto.TransferLeadershipRequest;
import org.apache.bifromq.basekv.store.proto.ZombieQuitReply;
import org.apache.bifromq.basekv.store.proto.ZombieQuitRequest;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.basekv.utils.DescriptorUtil;
import org.apache.bifromq.basekv.utils.EffectiveEpoch;
import org.apache.bifromq.baserpc.BluePrint;
import org.apache.bifromq.baserpc.client.IConnectable;
import org.apache.bifromq.baserpc.client.IRPCClient;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

final class BaseKVStoreClient
implements IBaseKVStoreClient {
    private static final ExecutorService CLIENT_EXECUTOR = ExecutorServiceMetrics.monitor((MeterRegistry)Metrics.globalRegistry, (ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), EnvProvider.INSTANCE.newThreadFactory("basekv-client-scheduler", true)), (String)"basekv-client-scheduler", (Tag[])new Tag[0]);
    private static final Scheduler SHARE_CLIENT_SCHEDULER = Schedulers.from((Executor)CLIENT_EXECUTOR);
    private final Logger log;
    private final String clusterId;
    private final IRPCClient rpcClient;
    private final IBaseKVMetaService metaService;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final int queryPipelinesPerStore;
    private final IBaseKVLandscapeObserver landscapeObserver;
    private final MethodDescriptor<BootstrapRequest, BootstrapReply> bootstrapMethod;
    private final MethodDescriptor<RecoverRequest, RecoverReply> recoverMethod;
    private final MethodDescriptor<ZombieQuitRequest, ZombieQuitReply> zombieQuitMethod;
    private final MethodDescriptor<TransferLeadershipRequest, TransferLeadershipReply> transferLeadershipMethod;
    private final MethodDescriptor<ChangeReplicaConfigRequest, ChangeReplicaConfigReply> changeReplicaConfigMethod;
    private final MethodDescriptor<KVRangeSplitRequest, KVRangeSplitReply> splitMethod;
    private final MethodDescriptor<KVRangeMergeRequest, KVRangeMergeReply> mergeMethod;
    private final MethodDescriptor<KVRangeRWRequest, KVRangeRWReply> executeMethod;
    private final MethodDescriptor<KVRangeRORequest, KVRangeROReply> linearizedQueryMethod;
    private final MethodDescriptor<KVRangeRORequest, KVRangeROReply> queryMethod;
    private final Subject<Map<String, String>> storeToServerSubject = BehaviorSubject.createDefault(Collections.emptyMap());
    private final Observable<ClusterInfo> clusterInfoObservable;
    private final Map<String, List<IQueryPipeline>> lnrQueryPplns = Maps.newHashMap();
    private final AtomicReference<NavigableMap<Boundary, KVRangeSetting>> effectiveRouter = new AtomicReference(Collections.unmodifiableNavigableMap(new TreeMap(BoundaryUtil::compare)));
    private final AtomicReference<Map<KVRangeId, Map<String, KVRangeDescriptor>>> latestRouteMap = new AtomicReference(Collections.emptyMap());
    private volatile Map<String, String> serverToStoreMap = Maps.newHashMap();
    private volatile Map<String, String> storeToServerMap = Maps.newHashMap();
    private volatile Map<String, Map<KVRangeId, IMutationPipeline>> mutPplns = Maps.newHashMap();
    private volatile Map<String, List<IQueryPipeline>> queryPplns = Maps.newHashMap();

    BaseKVStoreClient(BaseKVStoreClientBuilder builder) {
        this.clusterId = builder.clusterId;
        this.log = MDCLogger.getLogger(BaseKVStoreClient.class, (String[])new String[]{"clusterId", this.clusterId});
        BluePrint bluePrint = RPCBluePrint.build((String)this.clusterId);
        this.bootstrapMethod = bluePrint.methodDesc(RPCBluePrint.toScopedFullMethodName((String)this.clusterId, (String)BaseKVStoreServiceGrpc.getBootstrapMethod().getFullMethodName()));
        this.recoverMethod = bluePrint.methodDesc(RPCBluePrint.toScopedFullMethodName((String)this.clusterId, (String)BaseKVStoreServiceGrpc.getRecoverMethod().getFullMethodName()));
        this.zombieQuitMethod = bluePrint.methodDesc(RPCBluePrint.toScopedFullMethodName((String)this.clusterId, (String)BaseKVStoreServiceGrpc.getZombieQuitMethod().getFullMethodName()));
        this.transferLeadershipMethod = bluePrint.methodDesc(RPCBluePrint.toScopedFullMethodName((String)this.clusterId, (String)BaseKVStoreServiceGrpc.getTransferLeadershipMethod().getFullMethodName()));
        this.changeReplicaConfigMethod = bluePrint.methodDesc(RPCBluePrint.toScopedFullMethodName((String)this.clusterId, (String)BaseKVStoreServiceGrpc.getChangeReplicaConfigMethod().getFullMethodName()));
        this.splitMethod = bluePrint.methodDesc(RPCBluePrint.toScopedFullMethodName((String)this.clusterId, (String)BaseKVStoreServiceGrpc.getSplitMethod().getFullMethodName()));
        this.mergeMethod = bluePrint.methodDesc(RPCBluePrint.toScopedFullMethodName((String)this.clusterId, (String)BaseKVStoreServiceGrpc.getMergeMethod().getFullMethodName()));
        this.executeMethod = bluePrint.methodDesc(RPCBluePrint.toScopedFullMethodName((String)this.clusterId, (String)BaseKVStoreServiceGrpc.getExecuteMethod().getFullMethodName()));
        this.linearizedQueryMethod = bluePrint.methodDesc(RPCBluePrint.toScopedFullMethodName((String)this.clusterId, (String)BaseKVStoreServiceGrpc.getLinearizedQueryMethod().getFullMethodName()));
        this.queryMethod = bluePrint.methodDesc(RPCBluePrint.toScopedFullMethodName((String)this.clusterId, (String)BaseKVStoreServiceGrpc.getQueryMethod().getFullMethodName()));
        this.metaService = builder.metaService;
        this.queryPipelinesPerStore = builder.queryPipelinesPerStore <= 0 ? 5 : builder.queryPipelinesPerStore;
        this.rpcClient = IRPCClient.newBuilder().trafficService(builder.trafficService).bluePrint(bluePrint).workerThreads(builder.workerThreads).eventLoopGroup(builder.eventLoopGroup).sslContext(builder.sslContext).idleTimeoutInSec(builder.idleTimeoutInSec).keepAliveInSec(builder.keepAliveInSec).build();
        this.landscapeObserver = this.metaService.landscapeObserver(this.clusterId);
        this.clusterInfoObservable = Observable.combineLatest((ObservableSource)this.landscapeObserver.landscape(), (ObservableSource)this.rpcClient.serverList().map(servers -> Maps.transformValues((Map)servers, metadata -> (String)metadata.get("store_id"))), ClusterInfo::new).observeOn(SHARE_CLIENT_SCHEDULER).filter(clusterInfo -> {
            boolean complete = Sets.newHashSet(clusterInfo.serverToStoreMap.values()).equals(clusterInfo.storeDescriptors.keySet());
            if (!complete) {
                this.log.debug("Incomplete cluster[{}] info: storeDescriptors={}, serverToStoreMap={}", new Object[]{this.clusterId, clusterInfo.storeDescriptors, clusterInfo.serverToStoreMap});
            }
            return complete;
        });
        this.disposables.add(this.clusterInfoObservable.subscribe(this::refresh));
    }

    public Observable<IConnectable.ConnState> connState() {
        return this.rpcClient.connState();
    }

    @Override
    public String clusterId() {
        return this.clusterId;
    }

    @Override
    public Observable<Set<KVRangeStoreDescriptor>> describe() {
        return this.clusterInfoObservable.map(clusterInfo -> Sets.newHashSet(clusterInfo.storeDescriptors.values()));
    }

    @Override
    public NavigableMap<Boundary, KVRangeSetting> latestEffectiveRouter() {
        return this.effectiveRouter.get();
    }

    @Override
    public CompletableFuture<BootstrapReply> bootstrap(String storeId, BootstrapRequest request) {
        String serverId = this.storeToServerMap.get(storeId);
        if (serverId == null) {
            return CompletableFuture.failedFuture((Throwable)new ServerNotFoundException("BaseKVStore Server not available for storeId: " + storeId));
        }
        return this.rpcClient.invoke("", serverId, (Object)request, this.bootstrapMethod);
    }

    @Override
    public CompletableFuture<RecoverReply> recover(String storeId, RecoverRequest request) {
        String serverId = this.storeToServerMap.get(storeId);
        if (serverId == null) {
            return CompletableFuture.failedFuture((Throwable)new ServerNotFoundException("BaseKVStore Server not available for storeId: " + storeId));
        }
        return this.rpcClient.invoke("", serverId, (Object)request, this.recoverMethod);
    }

    @Override
    public CompletableFuture<ZombieQuitReply> zombieQuit(String storeId, ZombieQuitRequest request) {
        String serverId = this.storeToServerMap.get(storeId);
        if (serverId == null) {
            return CompletableFuture.failedFuture((Throwable)new ServerNotFoundException("BaseKVStore Server not available for storeId: " + storeId));
        }
        return this.rpcClient.invoke("", serverId, (Object)request, this.zombieQuitMethod);
    }

    @Override
    public CompletableFuture<TransferLeadershipReply> transferLeadership(String storeId, TransferLeadershipRequest request) {
        String serverId = this.storeToServerMap.get(storeId);
        if (serverId == null) {
            return CompletableFuture.failedFuture((Throwable)new ServerNotFoundException("BaseKVStore Server not available for storeId: " + storeId));
        }
        return ((CompletableFuture)this.rpcClient.invoke("", serverId, (Object)request, this.transferLeadershipMethod).exceptionally(e -> {
            this.log.error("Failed to transfer leader", e);
            return TransferLeadershipReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.InternalError).build();
        })).thenApplyAsync(v -> {
            if (v.hasLatest()) {
                this.patchRouter(storeId, v.getLatest());
            }
            return v;
        }, (Executor)CLIENT_EXECUTOR);
    }

    @Override
    public CompletableFuture<ChangeReplicaConfigReply> changeReplicaConfig(String storeId, ChangeReplicaConfigRequest request) {
        String serverId = this.storeToServerMap.get(storeId);
        if (serverId == null) {
            return CompletableFuture.failedFuture((Throwable)new ServerNotFoundException("BaseKVStore Server not available for storeId: " + storeId));
        }
        return ((CompletableFuture)this.rpcClient.invoke("", serverId, (Object)request, this.changeReplicaConfigMethod).exceptionally(e -> {
            this.log.error("Failed to change config", e);
            return ChangeReplicaConfigReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.InternalError).build();
        })).thenApply(v -> {
            if (v.hasLatest()) {
                this.patchRouter(storeId, v.getLatest());
            }
            return v;
        });
    }

    @Override
    public CompletableFuture<KVRangeSplitReply> splitRange(String storeId, KVRangeSplitRequest request) {
        String serverId = this.storeToServerMap.get(storeId);
        if (serverId == null) {
            return CompletableFuture.failedFuture((Throwable)new ServerNotFoundException("BaseKVStore Server not available for storeId: " + storeId));
        }
        return ((CompletableFuture)this.rpcClient.invoke("", serverId, (Object)request, this.splitMethod).exceptionally(e -> {
            this.log.error("Failed to split", e);
            return KVRangeSplitReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.InternalError).build();
        })).thenApplyAsync(v -> {
            if (v.hasLatest()) {
                this.patchRouter(storeId, v.getLatest());
            }
            return v;
        }, (Executor)CLIENT_EXECUTOR);
    }

    @Override
    public CompletableFuture<KVRangeMergeReply> mergeRanges(String storeId, KVRangeMergeRequest request) {
        String serverId = this.storeToServerMap.get(storeId);
        if (serverId == null) {
            return CompletableFuture.failedFuture((Throwable)new ServerNotFoundException("BaseKVStore Server not available for storeId: " + storeId));
        }
        return ((CompletableFuture)this.rpcClient.invoke("", serverId, (Object)request, this.mergeMethod).exceptionally(e -> {
            this.log.error("Failed to merge", e);
            return KVRangeMergeReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.InternalError).build();
        })).thenApplyAsync(v -> {
            if (v.hasLatest()) {
                this.patchRouter(storeId, v.getLatest());
            }
            return v;
        }, (Executor)CLIENT_EXECUTOR);
    }

    @Override
    public CompletableFuture<KVRangeRWReply> execute(String storeId, KVRangeRWRequest request) {
        return this.execute(storeId, request, String.valueOf(Thread.currentThread().getId()));
    }

    @Override
    public CompletableFuture<KVRangeRWReply> execute(String storeId, KVRangeRWRequest request, String orderKey) {
        IMutationPipeline mutPpln = (IMutationPipeline)this.mutPplns.getOrDefault(storeId, Collections.emptyMap()).get(request.getKvRangeId());
        if (mutPpln == null) {
            return CompletableFuture.failedFuture((Throwable)new ServerNotFoundException("BaseKVStore Server not available for storeId: " + storeId));
        }
        return mutPpln.execute(request);
    }

    @Override
    public CompletableFuture<KVRangeROReply> query(String storeId, KVRangeRORequest request) {
        return this.query(storeId, request, String.valueOf(Thread.currentThread().getId()));
    }

    @Override
    public CompletableFuture<KVRangeROReply> query(String storeId, KVRangeRORequest request, String orderKey) {
        List<IQueryPipeline> pipelines = this.queryPplns.get(storeId);
        if (pipelines == null) {
            return CompletableFuture.failedFuture((Throwable)new ServerNotFoundException("BaseKVStore Server not available for storeId: " + storeId));
        }
        return pipelines.get((orderKey.hashCode() % pipelines.size() + pipelines.size()) % pipelines.size()).query(request);
    }

    @Override
    public CompletableFuture<KVRangeROReply> linearizedQuery(String storeId, KVRangeRORequest request) {
        return this.linearizedQuery(storeId, request, String.valueOf(Thread.currentThread().getId()));
    }

    @Override
    public CompletableFuture<KVRangeROReply> linearizedQuery(String storeId, KVRangeRORequest request, String orderKey) {
        List<IQueryPipeline> pipelines = this.lnrQueryPplns.get(storeId);
        if (pipelines == null) {
            return CompletableFuture.failedFuture((Throwable)new ServerNotFoundException("BaseKVStore Server not available for storeId: " + storeId));
        }
        return pipelines.get((orderKey.hashCode() % pipelines.size() + pipelines.size()) % pipelines.size()).query(request);
    }

    @Override
    public IMutationPipeline createMutationPipeline(final String storeId) {
        return new ManagedMutationPipeline((Observable<IRPCClient.IRequestPipeline<KVRangeRWRequest, KVRangeRWReply>>)this.storeToServerSubject.map(m -> Optional.ofNullable((String)m.get(storeId))).distinctUntilChanged().map(serverIdOpt -> {
            if (serverIdOpt.isEmpty()) {
                return new IRPCClient.IRequestPipeline<KVRangeRWRequest, KVRangeRWReply>(){

                    public boolean isClosed() {
                        return false;
                    }

                    public CompletableFuture<KVRangeRWReply> invoke(KVRangeRWRequest req) {
                        return CompletableFuture.failedFuture((Throwable)new ServerNotFoundException("BaseKVStore Server not available for storeId: " + storeId));
                    }

                    public void close() {
                    }
                };
            }
            return this.rpcClient.createRequestPipeline("", (String)serverIdOpt.get(), null, Collections.emptyMap(), this.executeMethod);
        }), latest -> this.patchRouter(storeId, (KVRangeDescriptor)latest), this.log);
    }

    @Override
    public IQueryPipeline createLinearizedQueryPipeline(String storeId) {
        return this.createQueryPipeline(storeId, true);
    }

    @Override
    public IQueryPipeline createQueryPipeline(String storeId) {
        return this.createQueryPipeline(storeId, false);
    }

    private IQueryPipeline createQueryPipeline(final String storeId, boolean linearized) {
        return new ManagedQueryPipeline((Observable<IRPCClient.IRequestPipeline<KVRangeRORequest, KVRangeROReply>>)this.storeToServerSubject.map(m -> Optional.ofNullable((String)m.get(storeId))).distinctUntilChanged().map(serverIdOpt -> {
            if (serverIdOpt.isEmpty()) {
                return new IRPCClient.IRequestPipeline<KVRangeRORequest, KVRangeROReply>(){

                    public boolean isClosed() {
                        return false;
                    }

                    public CompletableFuture<KVRangeROReply> invoke(KVRangeRORequest req) {
                        return CompletableFuture.failedFuture((Throwable)new ServerNotFoundException("BaseKVStore Server not available for storeId: " + storeId));
                    }

                    public void close() {
                    }
                };
            }
            if (linearized) {
                return this.rpcClient.createRequestPipeline("", (String)serverIdOpt.get(), null, Collections.emptyMap(), this.linearizedQueryMethod);
            }
            return this.rpcClient.createRequestPipeline("", (String)serverIdOpt.get(), null, Collections.emptyMap(), this.queryMethod);
        }), latest -> this.patchRouter(storeId, (KVRangeDescriptor)latest), this.log);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.log.debug("Stopping BaseKVStore client: cluster[{}]", (Object)this.clusterId);
            this.landscapeObserver.stop();
            this.disposables.dispose();
            this.log.debug("Closing execution pipelines: cluster[{}]", (Object)this.clusterId);
            this.mutPplns.values().forEach(pplns -> pplns.values().forEach(IMutationPipeline::close));
            this.log.debug("Closing query pipelines: cluster[{}]", (Object)this.clusterId);
            this.queryPplns.values().forEach(pplns -> pplns.forEach(IQueryPipeline::close));
            this.log.debug("Closing linearizable query pipelines: cluster[{}]", (Object)this.clusterId);
            this.lnrQueryPplns.values().forEach(pplns -> pplns.forEach(IQueryPipeline::close));
            this.log.debug("Stopping rpc client: cluster[{}]", (Object)this.clusterId);
            this.rpcClient.stop();
            this.log.debug("BaseKVStore client stopped: cluster[{}]", (Object)this.clusterId);
        }
    }

    private void refresh(ClusterInfo clusterInfo) {
        this.log.debug("Cluster[{}] info update\n{}", (Object)this.clusterId, (Object)clusterInfo);
        boolean rangeRouteUpdated = this.refreshRangeRoute(clusterInfo);
        boolean storeRouteUpdated = this.refreshStoreRoute(clusterInfo);
        if (storeRouteUpdated) {
            this.refreshQueryPipelines(clusterInfo.storeDescriptors.keySet());
        }
        if (rangeRouteUpdated || storeRouteUpdated) {
            this.refreshMutPipelines(clusterInfo.storeDescriptors);
        }
    }

    private boolean refreshRangeRoute(ClusterInfo clusterInfo) {
        Optional effectiveEpoch = DescriptorUtil.getEffectiveEpoch((Set)Sets.newHashSet(clusterInfo.storeDescriptors.values()));
        if (effectiveEpoch.isEmpty()) {
            return false;
        }
        HashMap<KVRangeId, Map<String, KVRangeDescriptor>> patch = new HashMap<KVRangeId, Map<String, KVRangeDescriptor>>();
        ((EffectiveEpoch)effectiveEpoch.get()).storeDescriptors().forEach(storeDescriptor -> storeDescriptor.getRangesList().forEach(rangeDescriptor -> patch.computeIfAbsent(rangeDescriptor.getId(), k -> new HashMap()).put(storeDescriptor.getId(), rangeDescriptor)));
        this.latestRouteMap.set(KVRangeRouterUtil.refreshRouteMap(this.latestRouteMap.get(), patch));
        NavigableMap rangeLeaders = DescriptorUtil.getRangeLeaders(this.latestRouteMap.get());
        NavigableMap<Boundary, KVRangeSetting> router = KVRangeRouterUtil.buildClientRoute(this.clusterId, rangeLeaders, this.latestRouteMap.get());
        NavigableMap<Boundary, KVRangeSetting> last = this.effectiveRouter.get();
        if (!router.equals(last)) {
            this.effectiveRouter.set(Collections.unmodifiableNavigableMap(router));
            return true;
        }
        return false;
    }

    private boolean refreshStoreRoute(ClusterInfo clusterInfo) {
        Map<String, String> oldServerToStoreMap = this.serverToStoreMap;
        if (clusterInfo.serverToStoreMap.equals(oldServerToStoreMap)) {
            return false;
        }
        HashMap<String, String> newStoreToServerMap = new HashMap<String, String>();
        clusterInfo.serverToStoreMap.forEach((server, store) -> newStoreToServerMap.put((String)store, (String)server));
        this.serverToStoreMap = clusterInfo.serverToStoreMap;
        this.storeToServerMap = newStoreToServerMap;
        this.storeToServerSubject.onNext(newStoreToServerMap);
        return true;
    }

    private void patchRouter(String storeId, KVRangeDescriptor latest) {
        CLIENT_EXECUTOR.execute(() -> {
            this.latestRouteMap.set(KVRangeRouterUtil.patchRouteMap(storeId, latest, new HashMap<KVRangeId, Map<String, KVRangeDescriptor>>(this.latestRouteMap.get())));
            NavigableMap rangeLeaders = DescriptorUtil.getRangeLeaders(this.latestRouteMap.get());
            NavigableMap<Boundary, KVRangeSetting> router = KVRangeRouterUtil.buildClientRoute(this.clusterId, rangeLeaders, this.latestRouteMap.get());
            NavigableMap<Boundary, KVRangeSetting> last = this.effectiveRouter.get();
            if (!router.equals(last)) {
                this.effectiveRouter.set(Collections.unmodifiableNavigableMap(router));
            }
        });
    }

    private void refreshMutPipelines(Map<String, KVRangeStoreDescriptor> storeDescriptors) {
        HashMap<String, Map<KVRangeId, IMutationPipeline>> nextMutPplns = new HashMap<String, Map<KVRangeId, IMutationPipeline>>();
        Map<String, Map<KVRangeId, IMutationPipeline>> currentMutPplns = this.mutPplns;
        for (KVRangeStoreDescriptor storeDescriptor : storeDescriptors.values()) {
            String storeId = storeDescriptor.getId();
            for (KVRangeDescriptor rangeDescriptor : storeDescriptor.getRangesList()) {
                if (rangeDescriptor.getRole() != RaftNodeStatus.Leader) continue;
                KVRangeId rangeId = rangeDescriptor.getId();
                Map currentRanges = currentMutPplns.getOrDefault(storeId, Collections.emptyMap());
                IMutationPipeline existingPpln = (IMutationPipeline)currentRanges.get(rangeId);
                if (existingPpln != null) {
                    nextMutPplns.computeIfAbsent(storeId, k -> new HashMap()).put(rangeId, existingPpln);
                    continue;
                }
                nextMutPplns.computeIfAbsent(storeId, k -> new HashMap()).put(rangeId, this.createMutationPipeline(storeId));
            }
        }
        this.mutPplns = nextMutPplns;
        for (String storeId : Sets.difference(currentMutPplns.keySet(), nextMutPplns.keySet())) {
            currentMutPplns.get(storeId).values().forEach(IMutationPipeline::close);
        }
    }

    private void refreshQueryPipelines(Set<String> allStoreIds) {
        HashMap<String, List<IQueryPipeline>> nextQueryPplns = new HashMap<String, List<IQueryPipeline>>();
        Map<String, List<IQueryPipeline>> currentQueryPplns = this.queryPplns;
        for (String storeId : allStoreIds) {
            if (currentQueryPplns.containsKey(storeId)) {
                nextQueryPplns.put(storeId, currentQueryPplns.get(storeId));
                continue;
            }
            ArrayList queryPipelines = new ArrayList(this.queryPipelinesPerStore);
            IntStream.range(0, this.queryPipelinesPerStore).forEach(i -> queryPipelines.add(this.createQueryPipeline(storeId)));
            nextQueryPplns.put(storeId, queryPipelines);
        }
        this.queryPplns = nextQueryPplns;
        for (String storeId : Sets.difference(currentQueryPplns.keySet(), allStoreIds)) {
            currentQueryPplns.get(storeId).forEach(IQueryPipeline::close);
        }
    }

    private record ClusterInfo(Map<String, KVRangeStoreDescriptor> storeDescriptors, Map<String, String> serverToStoreMap) {
    }
}

