/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server.scheduler;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IMutationPipeline;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.BatchMutationCall;
import org.apache.bifromq.basekv.client.scheduler.MutationCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.inbox.rpc.proto.DetachReply;
import org.apache.bifromq.inbox.rpc.proto.DetachRequest;
import org.apache.bifromq.inbox.storage.proto.BatchDetachReply;
import org.apache.bifromq.inbox.storage.proto.BatchDetachRequest;
import org.apache.bifromq.inbox.storage.proto.InboxServiceRWCoProcInput;
import org.apache.bifromq.inbox.storage.proto.InboxVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchDetachCall
extends BatchMutationCall<DetachRequest, DetachReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchDetachCall.class);

    protected BatchDetachCall(IMutationPipeline pipeline, MutationCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
    }

    protected BatchMutationCall.MutationCallTaskBatch<DetachRequest, DetachReply> newBatch(long ver) {
        return new BatchDetachCallTask(ver);
    }

    protected RWCoProcInput makeBatch(Iterable<ICallTask<DetachRequest, DetachReply, MutationCallBatcherKey>> callTasks) {
        BatchDetachRequest.Builder reqBuilder = BatchDetachRequest.newBuilder();
        for (ICallTask<DetachRequest, DetachReply, MutationCallBatcherKey> callTask : callTasks) {
            DetachRequest request = (DetachRequest)callTask.call();
            BatchDetachRequest.Params.Builder paramsBuilder = BatchDetachRequest.Params.newBuilder().setTenantId(request.getClient().getTenantId()).setInboxId(request.getInboxId()).setExpirySeconds(request.getExpirySeconds()).setDiscardLWT(request.getDiscardLWT()).setNow(request.getNow());
            if (request.hasVersion()) {
                paramsBuilder.setVersion(request.getVersion());
            }
            reqBuilder.addParams(paramsBuilder.build());
        }
        long reqId = System.nanoTime();
        return RWCoProcInput.newBuilder().setInboxService(InboxServiceRWCoProcInput.newBuilder().setReqId(reqId).setBatchDetach(reqBuilder.build()).build()).build();
    }

    protected void handleOutput(Queue<ICallTask<DetachRequest, DetachReply, MutationCallBatcherKey>> batchedTasks, RWCoProcOutput output) {
        ICallTask<DetachRequest, DetachReply, MutationCallBatcherKey> callTask;
        assert (batchedTasks.size() == output.getInboxService().getBatchDetach().getCodeCount());
        int i = 0;
        while ((callTask = batchedTasks.poll()) != null) {
            BatchDetachReply.Code code = output.getInboxService().getBatchDetach().getCode(i++);
            DetachReply.Builder replyBuilder = DetachReply.newBuilder().setReqId(((DetachRequest)callTask.call()).getReqId());
            switch (code) {
                case OK: {
                    replyBuilder.setCode(DetachReply.Code.OK);
                    break;
                }
                case NO_INBOX: {
                    replyBuilder.setCode(DetachReply.Code.NO_INBOX);
                    break;
                }
                case CONFLICT: {
                    replyBuilder.setCode(DetachReply.Code.CONFLICT);
                    break;
                }
                default: {
                    log.error("Unexpected detach result: {}", (Object)code);
                    replyBuilder.setCode(DetachReply.Code.ERROR);
                }
            }
            callTask.resultPromise().complete(replyBuilder.build());
        }
    }

    protected void handleException(ICallTask<DetachRequest, DetachReply, MutationCallBatcherKey> callTask, Throwable e) {
        if (e instanceof ServerNotFoundException) {
            callTask.resultPromise().complete(DetachReply.newBuilder().setCode(DetachReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof BadVersionException) {
            callTask.resultPromise().complete(DetachReply.newBuilder().setCode(DetachReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof TryLaterException) {
            callTask.resultPromise().complete(DetachReply.newBuilder().setCode(DetachReply.Code.TRY_LATER).build());
            return;
        }
        callTask.resultPromise().completeExceptionally(e);
    }

    private static class BatchDetachCallTask
    extends BatchMutationCall.MutationCallTaskBatch<DetachRequest, DetachReply> {
        private final Map<String, Set<InboxVersion>> inboxes = new HashMap<String, Set<InboxVersion>>();

        private BatchDetachCallTask(long ver) {
            super(ver);
        }

        protected void add(ICallTask<DetachRequest, DetachReply, MutationCallBatcherKey> callTask) {
            super.add(callTask);
            this.inboxes.computeIfAbsent(((DetachRequest)callTask.call()).getClient().getTenantId(), k -> new HashSet()).add(((DetachRequest)callTask.call()).getVersion());
        }

        protected boolean isBatchable(ICallTask<DetachRequest, DetachReply, MutationCallBatcherKey> callTask) {
            return !this.inboxes.getOrDefault(((DetachRequest)callTask.call()).getClient().getTenantId(), Collections.emptySet()).contains(((DetachRequest)callTask.call()).getVersion());
        }
    }
}

