/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.slf4j.Logger;

class QuorumTracker {
    private final Set<String> voterGroupOne = new HashSet<String>();
    private final Set<String> voterGroupTwo = new HashSet<String>();
    private final Map<String, Boolean> votes = new HashMap<String, Boolean>();
    private final Logger logger;

    QuorumTracker(ClusterConfig clusterConfig, Logger logger) {
        this.voterGroupOne.addAll((Collection<String>)clusterConfig.getVotersList());
        this.voterGroupTwo.addAll((Collection<String>)clusterConfig.getNextVotersList());
        this.logger = logger;
    }

    void refresh(ClusterConfig clusterConfig) {
        this.logger.debug("Quorum tracker reset to config[v:{},nv:{}]", (Object)clusterConfig.getVotersList(), (Object)clusterConfig.getNextVotersList());
        this.voterGroupOne.clear();
        this.voterGroupOne.addAll((Collection<String>)clusterConfig.getVotersList());
        this.voterGroupTwo.clear();
        this.voterGroupTwo.addAll((Collection<String>)clusterConfig.getNextVotersList());
    }

    void reset() {
        this.votes.clear();
    }

    void poll(String voter, boolean vote) {
        this.votes.put(voter, vote);
    }

    TallyResult tally(String voter) {
        if (this.votes.containsKey(voter)) {
            if (this.votes.get(voter).booleanValue()) {
                return TallyResult.Yes;
            }
            return TallyResult.No;
        }
        return TallyResult.Miss;
    }

    JointVoteResult tally() {
        VoteGroupResult groupOneResult = this.tally(this.voterGroupOne);
        VoteGroupResult groupTwoResult = this.tally(this.voterGroupTwo);
        return new JointVoteResult(groupOneResult, groupTwoResult);
    }

    VoteGroupResult tally(Set<String> voters) {
        int miss = 0;
        int yes = 0;
        int no = 0;
        for (String voter : voters) {
            switch (this.tally(voter)) {
                case Yes: {
                    ++yes;
                    break;
                }
                case No: {
                    ++no;
                    break;
                }
                case Miss: {
                    ++miss;
                    break;
                }
            }
        }
        return new VoteGroupResult(voters.size(), yes, no, miss);
    }

    static enum TallyResult {
        Yes,
        No,
        Miss;

    }

    static class VoteGroupResult {
        final VoteResult result;
        final int yes;
        final int no;
        final int miss;

        private VoteGroupResult(int voters, int yes, int no, int miss) {
            int quorum;
            this.yes = yes;
            this.no = no;
            this.miss = miss;
            this.result = voters == 0 ? VoteResult.Won : (yes >= (quorum = voters / 2 + 1) ? VoteResult.Won : (yes + miss >= quorum ? VoteResult.Pending : VoteResult.Lost));
        }

        public String toString() {
            return "VoteGroupResult{result=" + String.valueOf((Object)this.result) + ", yes=" + this.yes + ", no=" + this.no + ", miss=" + this.miss + "}";
        }
    }

    static class JointVoteResult {
        final VoteResult result;
        final VoteGroupResult groupOneResult;
        final VoteGroupResult groupTwoResult;

        JointVoteResult(VoteGroupResult groupOneResult, VoteGroupResult groupTwoResult) {
            this.groupOneResult = groupOneResult;
            this.groupTwoResult = groupTwoResult;
            this.result = groupOneResult.result == groupTwoResult.result ? groupOneResult.result : (groupOneResult.result == VoteResult.Lost || groupTwoResult.result == VoteResult.Lost ? VoteResult.Lost : VoteResult.Pending);
        }

        public String toString() {
            return "JointVoteResult{result=" + String.valueOf((Object)this.result) + ", groupOneResult=" + String.valueOf(this.groupOneResult) + ", groupTwoResult=" + String.valueOf(this.groupTwoResult) + "}";
        }
    }

    static enum VoteResult {
        Won,
        Lost,
        Pending;

    }
}

