/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.v5;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.bifromq.inbox.storage.proto.InboxVersion;
import org.apache.bifromq.inbox.storage.proto.LWT;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.mqtt.handler.IMQTTProtocolHelper;
import org.apache.bifromq.mqtt.handler.MQTTPersistentSessionHandler;
import org.apache.bifromq.mqtt.handler.TenantSettings;
import org.apache.bifromq.mqtt.handler.condition.Condition;
import org.apache.bifromq.mqtt.handler.record.ProtocolResponse;
import org.apache.bifromq.mqtt.handler.v5.IReAuthenticator;
import org.apache.bifromq.mqtt.handler.v5.MQTT5ProtocolHelper;
import org.apache.bifromq.type.ClientInfo;

public final class MQTT5PersistentSessionHandler
extends MQTTPersistentSessionHandler {
    private final IMQTTProtocolHelper helper;
    private final IReAuthenticator reAuthenticator;

    public MQTT5PersistentSessionHandler(MqttConnectMessage connMsg, TenantSettings settings, ITenantMeter tenantMeter, Condition oomCondition, String userSessionId, int keepAliveTimeSeconds, int sessionExpirySeconds, ClientInfo clientInfo, InboxVersion inboxVersion, LWT noDelayLWT, ChannelHandlerContext ctx) {
        super(settings, tenantMeter, oomCondition, userSessionId, keepAliveTimeSeconds, sessionExpirySeconds, clientInfo, inboxVersion, noDelayLWT, ctx);
        this.helper = new MQTT5ProtocolHelper(connMsg, settings, clientInfo, this.sessionCtx.userPropsCustomizer);
        this.reAuthenticator = IReAuthenticator.create(connMsg, this.authProvider, clientInfo, x$0 -> this.handleProtocolResponse((ProtocolResponse)x$0), (Executor)ctx.executor());
    }

    @Override
    protected IMQTTProtocolHelper helper() {
        return this.helper;
    }

    @Override
    protected void handleOther(MqttMessage message) {
        if (message.fixedHeader().messageType() == MqttMessageType.AUTH) {
            this.reAuthenticator.onAuth(message);
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        this.memUsage.addAndGet(this.estBaseMemSize());
    }

    @Override
    public void doTearDown(ChannelHandlerContext ctx) {
        super.doTearDown(ctx);
        this.memUsage.addAndGet(-this.estBaseMemSize());
    }

    private int estBaseMemSize() {
        int s = 408;
        s += this.userSessionId.length();
        s += this.clientInfo.getSerializedSize();
        if (this.willMessage() != null) {
            s += this.willMessage().getSerializedSize();
        }
        return s;
    }

    @Generated
    public static MQTT5PersistentSessionHandlerBuilder builder() {
        return new MQTT5PersistentSessionHandlerBuilder();
    }

    @Generated
    public static class MQTT5PersistentSessionHandlerBuilder {
        @Generated
        private MqttConnectMessage connMsg;
        @Generated
        private TenantSettings settings;
        @Generated
        private ITenantMeter tenantMeter;
        @Generated
        private Condition oomCondition;
        @Generated
        private String userSessionId;
        @Generated
        private int keepAliveTimeSeconds;
        @Generated
        private int sessionExpirySeconds;
        @Generated
        private ClientInfo clientInfo;
        @Generated
        private InboxVersion inboxVersion;
        @Generated
        private LWT noDelayLWT;
        @Generated
        private ChannelHandlerContext ctx;

        @Generated
        MQTT5PersistentSessionHandlerBuilder() {
        }

        @Generated
        public MQTT5PersistentSessionHandlerBuilder connMsg(MqttConnectMessage connMsg) {
            this.connMsg = connMsg;
            return this;
        }

        @Generated
        public MQTT5PersistentSessionHandlerBuilder settings(TenantSettings settings) {
            this.settings = settings;
            return this;
        }

        @Generated
        public MQTT5PersistentSessionHandlerBuilder tenantMeter(ITenantMeter tenantMeter) {
            this.tenantMeter = tenantMeter;
            return this;
        }

        @Generated
        public MQTT5PersistentSessionHandlerBuilder oomCondition(Condition oomCondition) {
            this.oomCondition = oomCondition;
            return this;
        }

        @Generated
        public MQTT5PersistentSessionHandlerBuilder userSessionId(String userSessionId) {
            this.userSessionId = userSessionId;
            return this;
        }

        @Generated
        public MQTT5PersistentSessionHandlerBuilder keepAliveTimeSeconds(int keepAliveTimeSeconds) {
            this.keepAliveTimeSeconds = keepAliveTimeSeconds;
            return this;
        }

        @Generated
        public MQTT5PersistentSessionHandlerBuilder sessionExpirySeconds(int sessionExpirySeconds) {
            this.sessionExpirySeconds = sessionExpirySeconds;
            return this;
        }

        @Generated
        public MQTT5PersistentSessionHandlerBuilder clientInfo(ClientInfo clientInfo) {
            this.clientInfo = clientInfo;
            return this;
        }

        @Generated
        public MQTT5PersistentSessionHandlerBuilder inboxVersion(InboxVersion inboxVersion) {
            this.inboxVersion = inboxVersion;
            return this;
        }

        @Generated
        public MQTT5PersistentSessionHandlerBuilder noDelayLWT(LWT noDelayLWT) {
            this.noDelayLWT = noDelayLWT;
            return this;
        }

        @Generated
        public MQTT5PersistentSessionHandlerBuilder ctx(ChannelHandlerContext ctx) {
            this.ctx = ctx;
            return this;
        }

        @Generated
        public MQTT5PersistentSessionHandler build() {
            return new MQTT5PersistentSessionHandler(this.connMsg, this.settings, this.tenantMeter, this.oomCondition, this.userSessionId, this.keepAliveTimeSeconds, this.sessionExpirySeconds, this.clientInfo, this.inboxVersion, this.noDelayLWT, this.ctx);
        }

        @Generated
        public String toString() {
            return "MQTT5PersistentSessionHandler.MQTT5PersistentSessionHandlerBuilder(connMsg=" + String.valueOf(this.connMsg) + ", settings=" + String.valueOf(this.settings) + ", tenantMeter=" + String.valueOf(this.tenantMeter) + ", oomCondition=" + String.valueOf(this.oomCondition) + ", userSessionId=" + this.userSessionId + ", keepAliveTimeSeconds=" + this.keepAliveTimeSeconds + ", sessionExpirySeconds=" + this.sessionExpirySeconds + ", clientInfo=" + String.valueOf(this.clientInfo) + ", inboxVersion=" + String.valueOf(this.inboxVersion) + ", noDelayLWT=" + String.valueOf(this.noDelayLWT) + ", ctx=" + String.valueOf(this.ctx) + ")";
        }
    }
}

