/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.server;

import io.grpc.stub.StreamObserver;
import java.time.Duration;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.baserpc.server.UnaryResponse;
import org.apache.bifromq.dist.rpc.proto.DistReply;
import org.apache.bifromq.dist.rpc.proto.DistRequest;
import org.apache.bifromq.dist.rpc.proto.DistServiceGrpc;
import org.apache.bifromq.dist.rpc.proto.MatchReply;
import org.apache.bifromq.dist.rpc.proto.MatchRequest;
import org.apache.bifromq.dist.rpc.proto.UnmatchReply;
import org.apache.bifromq.dist.rpc.proto.UnmatchRequest;
import org.apache.bifromq.dist.server.DistResponsePipeline;
import org.apache.bifromq.dist.server.handler.MatchReqHandler;
import org.apache.bifromq.dist.server.handler.UnmatchReqHandler;
import org.apache.bifromq.dist.server.scheduler.BatchDistServerCallBuilderFactory;
import org.apache.bifromq.dist.server.scheduler.DistWorkerCallScheduler;
import org.apache.bifromq.dist.server.scheduler.IDistWorkerCallScheduler;
import org.apache.bifromq.dist.server.scheduler.MatchCallScheduler;
import org.apache.bifromq.dist.server.scheduler.UnmatchCallScheduler;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.sysprops.props.DistMaxCachedRoutesPerTenant;
import org.apache.bifromq.sysprops.props.DistTopicMatchExpirySeconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistService
extends DistServiceGrpc.DistServiceImplBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DistService.class);
    private final IEventCollector eventCollector;
    private final IDistWorkerCallScheduler distCallScheduler;
    private final MatchReqHandler matchReqHandler;
    private final UnmatchReqHandler unmatchReqHandler;

    DistService(IBaseKVStoreClient distWorkerClient, ISettingProvider settingProvider, IEventCollector eventCollector) {
        this.eventCollector = eventCollector;
        MatchCallScheduler matchCallScheduler = new MatchCallScheduler(distWorkerClient, settingProvider);
        this.matchReqHandler = new MatchReqHandler(eventCollector, matchCallScheduler);
        UnmatchCallScheduler unmatchCallScheduler = new UnmatchCallScheduler(distWorkerClient);
        this.unmatchReqHandler = new UnmatchReqHandler(eventCollector, unmatchCallScheduler);
        BatchDistServerCallBuilderFactory factory = new BatchDistServerCallBuilderFactory(distWorkerClient, (Long)DistMaxCachedRoutesPerTenant.INSTANCE.get(), Duration.ofSeconds(((Integer)DistTopicMatchExpirySeconds.INSTANCE.get()).intValue()));
        this.distCallScheduler = new DistWorkerCallScheduler(factory, Long.MAX_VALUE);
    }

    public void match(MatchRequest request, StreamObserver<MatchReply> responseObserver) {
        UnaryResponse.response(tenantId -> this.matchReqHandler.handle(request), responseObserver);
    }

    public void unmatch(UnmatchRequest request, StreamObserver<UnmatchReply> responseObserver) {
        UnaryResponse.response(tenantId -> this.unmatchReqHandler.handle(request), responseObserver);
    }

    public StreamObserver<DistRequest> dist(StreamObserver<DistReply> responseObserver) {
        return new DistResponsePipeline(this.distCallScheduler, responseObserver, this.eventCollector);
    }

    public void stop() {
        log.debug("stop dist worker call scheduler");
        this.distCallScheduler.close();
        log.debug("Stop match call handler");
        this.matchReqHandler.close();
        log.debug("Stop unmatch call handler");
        this.unmatchReqHandler.close();
    }
}

