/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basescheduler;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.bifromq.basescheduler.CallTask;
import org.apache.bifromq.basescheduler.EMALong;
import org.apache.bifromq.basescheduler.IBatchCall;
import org.apache.bifromq.basescheduler.IBatchCallBuilder;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.basescheduler.exception.BackPressureException;
import org.apache.bifromq.basescheduler.spi.IBatchCallWeighter;
import org.apache.bifromq.basescheduler.spi.ICapacityEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Batcher<CallT, CallResultT, BatcherKeyT> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Batcher.class);
    private final BatcherKeyT key;
    private final IBatchCallBuilder<CallT, CallResultT, BatcherKeyT> batchCallBuilder;
    private final Queue<IBatchCall<CallT, CallResultT, BatcherKeyT>> batchPool;
    private final Queue<ICallTask<CallT, CallResultT, BatcherKeyT>> callTaskBuffers = new ConcurrentLinkedQueue<ICallTask<CallT, CallResultT, BatcherKeyT>>();
    private final AtomicReference<State> state = new AtomicReference<State>(State.RUNNING);
    private final AtomicBoolean triggering = new AtomicBoolean();
    private final AtomicInteger pipelineDepth = new AtomicInteger();
    private final AtomicInteger queuedCallCount = new AtomicInteger(0);
    private final AtomicInteger inFlightCallCount = new AtomicInteger(0);
    private final ICapacityEstimator<BatcherKeyT> capacityEstimator;
    private final IBatchCallWeighter<CallT> batchCallWeighter;
    private final long maxBurstLatency;
    private final EMALong emaQueueingTime;
    private final Gauge pipelineDepthGauge;
    private final Counter dropCounter;
    private final Timer batchCallTimer;
    private final Timer batchExecTimer;
    private final Timer batchBuildTimer;
    private final DistributionSummary batchCountSummary;
    private final DistributionSummary batchWeightSizeSummary;
    private final DistributionSummary queueingTimeSummary;
    private final Gauge maxCapacityGauge;
    private final Gauge queueingCountGauge;
    private final Gauge inflightCountGauge;
    private final Gauge inflightWeightGauge;
    private final CompletableFuture<Void> shutdownFuture = new CompletableFuture();
    private final AtomicLong inFlightWeight = new AtomicLong(0L);

    Batcher(String name, BatcherKeyT key, IBatchCallBuilder<CallT, CallResultT, BatcherKeyT> batchCallBuilder, long maxBurstLatency, ICapacityEstimator<BatcherKeyT> capacityEstimator, IBatchCallWeighter<CallT> batchCallWeighter) {
        this.key = key;
        this.batchCallBuilder = batchCallBuilder;
        this.capacityEstimator = capacityEstimator;
        this.batchCallWeighter = batchCallWeighter;
        this.maxBurstLatency = maxBurstLatency;
        this.batchPool = new ConcurrentLinkedDeque<IBatchCall<CallT, CallResultT, BatcherKeyT>>();
        this.emaQueueingTime = new EMALong(System::nanoTime, 0.1, 0.9, maxBurstLatency);
        Tags tags = Tags.of((String[])new String[]{"name", name, "key", Integer.toUnsignedString(System.identityHashCode(this))});
        this.pipelineDepthGauge = Gauge.builder((String)"batcher.pipeline.depth", this.pipelineDepth::get).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.dropCounter = Counter.builder((String)"batcher.call.drop.count").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.batchCallTimer = Timer.builder((String)"batcher.call.time").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.batchExecTimer = Timer.builder((String)"batcher.exec.time").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.batchBuildTimer = Timer.builder((String)"batcher.build.time").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.batchCountSummary = DistributionSummary.builder((String)"batcher.batch.count").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.batchWeightSizeSummary = DistributionSummary.builder((String)"batcher.batch.size").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.queueingTimeSummary = DistributionSummary.builder((String)"batcher.queueing.time").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.maxCapacityGauge = Gauge.builder((String)"batcher.capacity.max", () -> capacityEstimator.maxCapacity(key)).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.queueingCountGauge = Gauge.builder((String)"batcher.queueing.count", this.queuedCallCount::get).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.inflightCountGauge = Gauge.builder((String)"batcher.inflight.count", this.inFlightCallCount::get).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
        this.inflightWeightGauge = Gauge.builder((String)"batcher.inflight.size", this.inFlightWeight::get).tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
    }

    public CompletableFuture<CallResultT> submit(BatcherKeyT batcherKey, CallT request) {
        if (this.state.get() != State.RUNNING) {
            return CompletableFuture.failedFuture(new RejectedExecutionException("Batcher has been shut down"));
        }
        if (this.emaQueueingTime.get() > this.maxBurstLatency) {
            this.dropCounter.increment();
            if (this.pipelineDepth.get() == 0 && !this.callTaskBuffers.isEmpty()) {
                this.trigger();
            }
            return CompletableFuture.failedFuture(new BackPressureException("Batch call busy"));
        }
        CallTask callTask = new CallTask(batcherKey, request);
        boolean offered = this.callTaskBuffers.offer(callTask);
        assert (offered);
        this.queuedCallCount.incrementAndGet();
        this.trigger();
        return callTask.resultPromise();
    }

    public CompletableFuture<Void> close() {
        if (this.state.compareAndSet(State.RUNNING, State.SHUTTING_DOWN)) {
            this.checkShutdownCompletion();
        }
        return this.shutdownFuture;
    }

    private void checkShutdownCompletion() {
        if (this.callTaskBuffers.isEmpty() && this.pipelineDepth.get() == 0) {
            this.cleanupMetrics();
            this.batchCallWeighter.reset();
            this.state.set(State.TERMINATED);
            this.shutdownFuture.complete(null);
        }
    }

    private void cleanupMetrics() {
        IBatchCall<CallT, CallResultT, BatcherKeyT> batchCall;
        Metrics.globalRegistry.remove((Meter)this.pipelineDepthGauge);
        Metrics.globalRegistry.remove((Meter)this.dropCounter);
        Metrics.globalRegistry.remove((Meter)this.batchCallTimer);
        Metrics.globalRegistry.remove((Meter)this.batchExecTimer);
        Metrics.globalRegistry.remove((Meter)this.batchBuildTimer);
        Metrics.globalRegistry.remove((Meter)this.batchCountSummary);
        Metrics.globalRegistry.remove((Meter)this.batchWeightSizeSummary);
        Metrics.globalRegistry.remove((Meter)this.queueingTimeSummary);
        Metrics.globalRegistry.remove((Meter)this.maxCapacityGauge);
        Metrics.globalRegistry.remove((Meter)this.queueingCountGauge);
        Metrics.globalRegistry.remove((Meter)this.inflightCountGauge);
        Metrics.globalRegistry.remove((Meter)this.inflightWeightGauge);
        while ((batchCall = this.batchPool.poll()) != null) {
            batchCall.destroy();
        }
        this.batchCallBuilder.close();
    }

    private void trigger() {
        if (this.triggering.compareAndSet(false, true)) {
            try {
                if (!this.callTaskBuffers.isEmpty() && this.capacityEstimator.hasCapacity(this.inFlightWeight.get(), this.key)) {
                    this.batchAndEmit();
                }
            }
            finally {
                this.triggering.set(false);
                if (!this.callTaskBuffers.isEmpty() && this.capacityEstimator.hasCapacity(this.inFlightWeight.get(), this.key)) {
                    this.trigger();
                }
            }
        }
    }

    private void batchAndEmit() {
        block4: {
            ICallTask<CallT, CallResultT, BatcherKeyT> callTask;
            this.pipelineDepth.incrementAndGet();
            long buildStart = System.nanoTime();
            IBatchCall<CallT, CallResultT, BatcherKeyT> batchCall = this.borrowBatchCall();
            int batchedCallNums = 0;
            LinkedList<ICallTask<CallT, CallResultT, BatcherKeyT>> batchedTasks = new LinkedList<ICallTask<CallT, CallResultT, BatcherKeyT>>();
            this.batchCallWeighter.reset();
            long avail = this.capacityEstimator.maxCapacity(this.key);
            while (this.batchCallWeighter.weight() < avail && (callTask = this.callTaskBuffers.poll()) != null) {
                this.batchCallWeighter.add(callTask.call());
                long queueingTime = System.nanoTime() - callTask.ts();
                this.emaQueueingTime.update(queueingTime);
                this.queueingTimeSummary.record((double)queueingTime);
                batchCall.add(callTask);
                batchedTasks.add(callTask);
                ++batchedCallNums;
            }
            long batchWeight = this.batchCallWeighter.weight();
            this.queuedCallCount.addAndGet(-batchedCallNums);
            this.inFlightCallCount.addAndGet(batchedCallNums);
            this.batchCountSummary.record((double)batchedCallNums);
            this.batchWeightSizeSummary.record((double)batchWeight);
            long execBegin = System.nanoTime();
            this.batchBuildTimer.record(execBegin - buildStart, TimeUnit.NANOSECONDS);
            try {
                int finalBatchSize = batchedCallNums;
                this.inFlightWeight.addAndGet(batchWeight);
                CompletableFuture<Void> future = batchCall.execute();
                future.orTimeout(this.maxBurstLatency, TimeUnit.NANOSECONDS).whenComplete((v, e) -> {
                    long execEnd = System.nanoTime();
                    if (e != null) {
                        if (e instanceof BackPressureException || e instanceof TimeoutException) {
                            this.capacityEstimator.onBackPressure();
                            batchedTasks.forEach(t -> t.resultPromise().completeExceptionally(new BackPressureException("Downstream Busy", (Throwable)e)));
                            this.returnBatchCall(batchCall, true);
                        } else {
                            batchedTasks.forEach(t -> t.resultPromise().completeExceptionally((Throwable)e));
                            this.returnBatchCall(batchCall, true);
                        }
                    } else {
                        long execLatency = execEnd - execBegin;
                        this.batchExecTimer.record(execLatency, TimeUnit.NANOSECONDS);
                        this.capacityEstimator.record(batchWeight, execLatency);
                        batchedTasks.forEach(t -> {
                            long callLatency = execEnd - t.ts();
                            this.batchCallTimer.record(callLatency, TimeUnit.NANOSECONDS);
                        });
                        this.returnBatchCall(batchCall, false);
                    }
                    this.inFlightCallCount.addAndGet(-finalBatchSize);
                    this.inFlightWeight.addAndGet(-batchWeight);
                    this.pipelineDepth.getAndDecrement();
                    if (this.state.get() == State.SHUTTING_DOWN) {
                        this.checkShutdownCompletion();
                    }
                    if (!this.callTaskBuffers.isEmpty()) {
                        this.trigger();
                    }
                });
            }
            catch (Throwable e2) {
                log.error("Batch call failed unexpectedly", e2);
                batchedTasks.forEach(t -> t.resultPromise().completeExceptionally(e2));
                this.returnBatchCall(batchCall, true);
                this.inFlightCallCount.addAndGet(-batchedCallNums);
                this.inFlightWeight.addAndGet(-batchWeight);
                this.pipelineDepth.getAndDecrement();
                if (this.state.get() == State.SHUTTING_DOWN) {
                    this.checkShutdownCompletion();
                }
                if (this.callTaskBuffers.isEmpty()) break block4;
                this.trigger();
            }
        }
    }

    private IBatchCall<CallT, CallResultT, BatcherKeyT> borrowBatchCall() {
        IBatchCall<CallT, CallResultT, BatcherKeyT> batchCall = this.batchPool.poll();
        if (batchCall == null) {
            batchCall = this.batchCallBuilder.newBatchCall();
        }
        return batchCall;
    }

    private void returnBatchCall(IBatchCall<CallT, CallResultT, BatcherKeyT> batchCall, boolean abort) {
        batchCall.reset(abort);
        this.batchPool.offer(batchCall);
    }

    private static enum State {
        RUNNING,
        SHUTTING_DOWN,
        TERMINATED;

    }
}

