/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.visitor;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.openapi.swagger.ObjectMapperFactory;
import io.micronaut.openapi.swagger.PrimitiveType;
import io.micronaut.openapi.visitor.Pair;
import io.micronaut.openapi.visitor.SchemaUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.servers.ServerVariable;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.xml.datatype.XMLGregorianCalendar;

@Internal
public final class ConvertUtils {
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private static final ObjectMapper JSON_MAPPER = ObjectMapperFactory.createJson().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private static final ObjectMapper JSON_MAPPER_31 = ObjectMapperFactory.createJson31().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private static final ObjectMapper CONVERT_JSON_MAPPER = ObjectMapperFactory.buildStrictGenericObjectMapper().enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS, new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING, new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY});
    private static final ObjectMapper YAML_MAPPER = ObjectMapperFactory.createYaml();

    private ConvertUtils() {
    }

    public static <T> T toValue(Map<CharSequence, Object> values, VisitorContext context, Class<T> type) {
        JsonNode node = ConvertUtils.toJson(values, context);
        try {
            return ConvertUtils.treeToValue(node, type, context);
        }
        catch (JsonProcessingException e) {
            context.warn("Error converting  [" + node + "]: to " + type + ": " + e.getMessage(), null);
            return null;
        }
    }

    public static JsonNode toJson(Map<CharSequence, Object> values, VisitorContext context) {
        Map<CharSequence, Object> newValues = ConvertUtils.toValueMap(values, context);
        return ConvertUtils.getJsonMapper().valueToTree(newValues);
    }

    public static Map<CharSequence, Object> toValueMap(Map<CharSequence, Object> values, VisitorContext context) {
        HashMap<CharSequence, Object> newValues = new HashMap<CharSequence, Object>(values.size());
        for (Map.Entry<CharSequence, Object> entry : values.entrySet()) {
            CharSequence key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof AnnotationValue) {
                AnnotationValue av = (AnnotationValue)value;
                Map<CharSequence, Object> valueMap = ConvertUtils.toValueMap(av.getValues(), context);
                newValues.put(key, valueMap);
                continue;
            }
            if (value instanceof AnnotationClassValue) {
                AnnotationClassValue acv = (AnnotationClassValue)value;
                acv.getType().ifPresent(aClass -> newValues.put(key, aClass));
                continue;
            }
            if (value == null) continue;
            if (value.getClass().isArray()) {
                Object[] a = (Object[])value;
                if (ArrayUtils.isNotEmpty((Object[])a)) {
                    Object first = a[0];
                    boolean areAnnotationValues = first instanceof AnnotationValue;
                    boolean areClassValues = first instanceof AnnotationClassValue;
                    if (areClassValues) {
                        ArrayList classes = new ArrayList(a.length);
                        for (Object o : a) {
                            AnnotationClassValue acv = (AnnotationClassValue)o;
                            acv.getType().ifPresent(classes::add);
                        }
                        newValues.put(key, classes);
                        continue;
                    }
                    if (areAnnotationValues) {
                        AnnotationValue sv;
                        String annotationName = ((AnnotationValue)first).getAnnotationName();
                        if (io.swagger.v3.oas.annotations.security.SecurityRequirement.class.getName().equals(annotationName)) {
                            ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>(a.length);
                            for (Object o : a) {
                                securityRequirements.add(ConvertUtils.mapToSecurityRequirement((AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement>)((AnnotationValue)o)));
                            }
                            newValues.put(key, securityRequirements);
                            continue;
                        }
                        if (Extension.class.getName().equals(annotationName)) {
                            HashMap<CharSequence, Object> extensions = new HashMap<CharSequence, Object>();
                            for (Object o : a) {
                                SchemaUtils.processExtensions(extensions, (AnnotationValue<Extension>)((AnnotationValue)o));
                            }
                            newValues.put("extensions", extensions);
                            continue;
                        }
                        if (Server.class.getName().equals(annotationName)) {
                            ArrayList<LinkedHashMap<CharSequence, Object>> servers = new ArrayList<LinkedHashMap<CharSequence, Object>>();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                LinkedHashMap<CharSequence, Object> variables = new LinkedHashMap<CharSequence, Object>(ConvertUtils.toValueMap(sv.getValues(), context));
                                servers.add(variables);
                            }
                            newValues.put(key, servers);
                            continue;
                        }
                        if (ServerVariable.class.getName().equals(annotationName)) {
                            LinkedHashMap variables = new LinkedHashMap();
                            for (Object o : a) {
                                sv = (AnnotationValue)o;
                                sv.stringValue("name").ifPresent(name -> {
                                    Map<CharSequence, Object> map = ConvertUtils.toValueMap(sv.getValues(), context);
                                    Object dv = map.get("defaultValue");
                                    if (dv != null) {
                                        map.put("default", dv);
                                    }
                                    if (map.containsKey("allowableValues")) {
                                        map.put("enum", map.remove("allowableValues"));
                                    }
                                    variables.put(name, map);
                                });
                            }
                            newValues.put(key, variables);
                            continue;
                        }
                        if (a.length == 1) {
                            AnnotationValue av = (AnnotationValue)a[0];
                            Map<CharSequence, Object> valueMap = ConvertUtils.toValueMap(av.getValues(), context);
                            newValues.put(key, ConvertUtils.toValueMap(valueMap, context));
                            continue;
                        }
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (Object o : a) {
                            if (o instanceof AnnotationValue) {
                                AnnotationValue av = (AnnotationValue)o;
                                Map<CharSequence, Object> valueMap = ConvertUtils.toValueMap(av.getValues(), context);
                                list.add(valueMap);
                                continue;
                            }
                            list.add(o);
                        }
                        newValues.put(key, list);
                        continue;
                    }
                    newValues.put(key, value);
                    continue;
                }
                newValues.put(key, a);
                continue;
            }
            newValues.put(key, ConvertUtils.parseJsonString(value).orElse(value));
        }
        return newValues;
    }

    public static Optional<Object> parseJsonString(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            try {
                return Optional.of(ConvertUtils.getConvertJsonMapper().readValue(string, Map.class));
            }
            catch (IOException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static <T> T treeToValue(JsonNode jn, Class<T> clazz, VisitorContext context) throws JsonProcessingException {
        JsonNode allowableValuesNode;
        Object defaultValue;
        Object value = CONVERT_JSON_MAPPER.treeToValue((TreeNode)jn, clazz);
        if (value == null) {
            return null;
        }
        ConvertUtils.resolveExtensions(jn).ifPresent(extensions -> BeanMap.of((Object)value).put((Object)"extensions", extensions));
        String elType = jn.has("type") ? jn.get("type").textValue() : null;
        String elFormat = jn.has("format") ? jn.get("format").textValue() : null;
        JsonNode defaultValueNode = jn.get("defaultValue");
        try {
            defaultValue = ConvertUtils.normalizeValue(defaultValueNode != null ? defaultValueNode.textValue() : null, elType, elFormat, context);
        }
        catch (JsonProcessingException e) {
            defaultValue = defaultValueNode != null ? defaultValueNode.textValue() : null;
        }
        BeanMap beanMap = BeanMap.of((Object)value);
        if (defaultValue != null) {
            beanMap.put((Object)"default", defaultValue);
        }
        if ((allowableValuesNode = jn.get("allowableValues")) != null && allowableValuesNode.isArray()) {
            ArrayList<Object> allowableValues = new ArrayList<Object>(allowableValuesNode.size());
            for (JsonNode allowableValueNode : allowableValuesNode) {
                if (allowableValueNode == null) continue;
                try {
                    allowableValues.add(ConvertUtils.normalizeValue(allowableValueNode.textValue(), elType, elFormat, context));
                }
                catch (IOException e) {
                    allowableValues.add(allowableValueNode.textValue());
                }
            }
            beanMap.put((Object)"allowableValues", allowableValues);
        }
        return (T)value;
    }

    public static Object normalizeValue(String valueStr, String type, String format, VisitorContext context) throws JsonProcessingException {
        return ConvertUtils.normalizeValue(valueStr, type, format, context, false);
    }

    public static Object normalizeValue(String valueStr, String type, String format, VisitorContext context, boolean isMicronautFormat) throws JsonProcessingException {
        if (valueStr == null) {
            return null;
        }
        if (type == null || type.equals("object")) {
            return CONVERT_JSON_MAPPER.readValue(valueStr, Map.class);
        }
        return ConvertUtils.parseByTypeAndFormat(valueStr, type, format, context, isMicronautFormat);
    }

    public static Optional<Map<String, Object>> resolveExtensions(JsonNode jn) {
        try {
            JsonNode extensionsNode = jn.get("extensions");
            if (extensionsNode != null) {
                return Optional.ofNullable((Map)CONVERT_JSON_MAPPER.convertValue((Object)extensionsNode, MAP_TYPE_REFERENCE));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static SecurityRequirement mapToSecurityRequirement(AnnotationValue<io.swagger.v3.oas.annotations.security.SecurityRequirement> r) {
        String name = (String)r.getRequiredValue("name", String.class);
        List scopes = r.get((CharSequence)"scopes", String[].class).map(Arrays::asList).orElse(Collections.emptyList());
        SecurityRequirement securityRequirement = new SecurityRequirement();
        securityRequirement.addList(name, scopes);
        return securityRequirement;
    }

    public static void setDefaultValueObject(Schema<?> schema, String defaultValue, @Nullable Element element, @Nullable String schemaType, @Nullable String schemaFormat, boolean isMicronautFormat, VisitorContext context) {
        try {
            Pair<String, String> typeAndFormat = element instanceof EnumElement ? ConvertUtils.checkEnumJsonValueType(context, (EnumElement)element, schemaType, schemaFormat) : Pair.of(schemaType, schemaFormat);
            schema.setDefault(ConvertUtils.normalizeValue(defaultValue, typeAndFormat.getFirst(), typeAndFormat.getSecond(), context, isMicronautFormat));
        }
        catch (JsonProcessingException e) {
            context.warn("Can't convert " + defaultValue + " to " + schemaType + ": " + e.getMessage(), element);
            schema.setDefault((Object)defaultValue);
        }
    }

    @NonNull
    public static Pair<String, String> checkEnumJsonValueType(VisitorContext context, @NonNull EnumElement type, @Nullable String schemaType, @Nullable String schemaFormat) {
        if (schemaType != null && !schemaType.equals(PrimitiveType.STRING.getCommonName())) {
            return Pair.of(schemaType, schemaFormat);
        }
        Pair<String, String> result = null;
        List methods = type.getEnclosedElements(ElementQuery.ALL_METHODS.annotated(metadata -> metadata.isAnnotationPresent(JsonValue.class)));
        if (CollectionUtils.isNotEmpty((Collection)methods)) {
            ClassElement returnType;
            MethodElement firstMethod = (MethodElement)methods.get(0);
            if (methods.size() > 1) {
                context.warn("Found " + methods.size() + " methods with @JsonValue. Process method " + firstMethod, (Element)type);
            }
            if ((returnType = firstMethod.getReturnType()).isEnum()) {
                return ConvertUtils.checkEnumJsonValueType(context, (EnumElement)returnType, null, null);
            }
            result = ConvertUtils.getTypeAndFormatByClass(returnType.getName(), firstMethod.getReturnType().isArray());
        }
        return result != null ? result : Pair.of(PrimitiveType.STRING.getCommonName(), schemaFormat);
    }

    public static Pair<String, String> getTypeAndFormatByClass(String className, boolean isArray) {
        if (className == null) {
            return Pair.of("object", null);
        }
        if (String.class.getName().equals(className) || Character.TYPE.getName().equals(className) || Character.class.getName().equals(className)) {
            return Pair.of("string", null);
        }
        if (Boolean.class.getName().equals(className) || Boolean.TYPE.getName().equals(className)) {
            return Pair.of("boolean", null);
        }
        if (Integer.class.getName().equals(className) || Integer.TYPE.getName().equals(className) || Short.class.getName().equals(className) || Short.TYPE.getName().equals(className)) {
            return Pair.of("integer", "int32");
        }
        if (BigInteger.class.getName().equals(className)) {
            return Pair.of("integer", null);
        }
        if (Long.class.getName().equals(className) || Long.TYPE.getName().equals(className)) {
            return Pair.of("integer", "int64");
        }
        if (Float.class.getName().equals(className) || Float.TYPE.getName().equals(className)) {
            return Pair.of("number", "float");
        }
        if (Double.class.getName().equals(className) || Double.TYPE.getName().equals(className)) {
            return Pair.of("number", "double");
        }
        if (isArray && (Byte.class.getName().equals(className) || Byte.TYPE.getName().equals(className))) {
            return Pair.of("string", "byte");
        }
        if (Byte.class.getName().equals(className) || Byte.TYPE.getName().equals(className)) {
            return Pair.of("integer", "int32");
        }
        if (BigDecimal.class.getName().equals(className)) {
            return Pair.of("number", null);
        }
        if (URI.class.getName().equals(className)) {
            return Pair.of("string", "uri");
        }
        if (URL.class.getName().equals(className)) {
            return Pair.of("string", "url");
        }
        if (UUID.class.getName().equals(className)) {
            return Pair.of("string", "uuid");
        }
        if (Number.class.getName().equals(className)) {
            return Pair.of("number", null);
        }
        if (File.class.getName().equals(className)) {
            return Pair.of("string", "binary");
        }
        if (LocalDate.class.getName().equals(className)) {
            return Pair.of("string", "date");
        }
        if (Date.class.getName().equals(className) || Calendar.class.getName().equals(className) || Instant.class.getName().equals(className) || LocalDateTime.class.getName().equals(className) || OffsetDateTime.class.getName().equals(className) || XMLGregorianCalendar.class.getName().equals(className) || ZonedDateTime.class.getName().equals(className)) {
            return Pair.of("string", "date-time");
        }
        if (LocalTime.class.getName().equals(className)) {
            return Pair.of("string", "partial-time");
        }
        return Pair.of("object", null);
    }

    public static Object parseByTypeAndFormat(String valueStr, String type, String format, VisitorContext context, boolean isMicronautFormat) {
        if (valueStr == null) {
            return null;
        }
        if ("array".equals(type) && isMicronautFormat) {
            return valueStr.split(",");
        }
        if (valueStr.isEmpty()) {
            return null;
        }
        try {
            if ("string".equals(type)) {
                if ("uri".equals(format)) {
                    return new URI(valueStr);
                }
                if ("url".equals(format)) {
                    return new URL(valueStr);
                }
                if ("uuid".equals(format)) {
                    return UUID.fromString(valueStr);
                }
                if (format == null) {
                    return valueStr;
                }
            } else {
                if ("boolean".equals(type)) {
                    return Boolean.parseBoolean(valueStr);
                }
                if ("array".equals(type)) {
                    return JSON_MAPPER.readValue(valueStr, List.class);
                }
                if ("integer".equals(type)) {
                    if ("int32".equals(format)) {
                        return Integer.parseInt(valueStr);
                    }
                    if ("int64".equals(format)) {
                        return Long.parseLong(valueStr);
                    }
                    return new BigInteger(valueStr);
                }
                if ("number".equals(type)) {
                    if ("float".equals(format)) {
                        return Float.valueOf(Float.parseFloat(valueStr));
                    }
                    if ("double".equals(format)) {
                        return Double.parseDouble(valueStr);
                    }
                    return new BigDecimal(valueStr);
                }
            }
        }
        catch (Exception e) {
            context.warn("Can't parse value " + valueStr + " with type " + type + " and format " + format, null);
        }
        return valueStr;
    }

    public static ObjectMapper getJsonMapper() {
        return JSON_MAPPER;
    }

    public static ObjectMapper getJsonMapper31() {
        return JSON_MAPPER_31;
    }

    public static ObjectMapper getConvertJsonMapper() {
        return CONVERT_JSON_MAPPER;
    }

    public static ObjectMapper getYamlMapper() {
        return YAML_MAPPER;
    }
}

