/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.tx.impl.FullyQualifiedResourceId;
import org.apache.ignite.internal.tx.impl.ResourceCloseException;
import org.jetbrains.annotations.TestOnly;

public class RemotelyTriggeredResourceRegistry {
    private static final IgniteLogger LOG = Loggers.forClass(RemotelyTriggeredResourceRegistry.class);
    private final ConcurrentNavigableMap<FullyQualifiedResourceId, RemotelyTriggeredResource> resources = new ConcurrentSkipListMap<FullyQualifiedResourceId, RemotelyTriggeredResource>();
    private final Map<UUID, Set<FullyQualifiedResourceId>> remoteHostsToResources = new ConcurrentHashMap<UUID, Set<FullyQualifiedResourceId>>();

    public <T extends ManuallyCloseable> T register(FullyQualifiedResourceId resourceId, UUID remoteHostId, Supplier<ManuallyCloseable> resourceProvider) {
        ManuallyCloseable r = this.resources.computeIfAbsent((FullyQualifiedResourceId)resourceId, (Function<FullyQualifiedResourceId, RemotelyTriggeredResource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$register$0(java.util.function.Supplier java.util.UUID org.apache.ignite.internal.tx.impl.FullyQualifiedResourceId ), (Lorg/apache/ignite/internal/tx/impl/FullyQualifiedResourceId;)Lorg/apache/ignite/internal/tx/impl/RemotelyTriggeredResourceRegistry$RemotelyTriggeredResource;)(resourceProvider, (UUID)remoteHostId)).resource;
        this.addRemoteHostResource(remoteHostId, resourceId);
        return (T)r;
    }

    public void close(FullyQualifiedResourceId resourceId) throws ResourceCloseException {
        RemotelyTriggeredResource remotelyTriggeredResource = (RemotelyTriggeredResource)this.resources.get(resourceId);
        if (remotelyTriggeredResource != null) {
            try {
                remotelyTriggeredResource.resource.close();
                this.resources.remove(resourceId);
                this.removeRemoteHostResource(remotelyTriggeredResource.remoteHostId(), resourceId);
            }
            catch (Exception e) {
                throw new ResourceCloseException(resourceId, remotelyTriggeredResource.remoteHostId(), e);
            }
        }
    }

    public void close(UUID contextId) throws ResourceCloseException {
        Map<FullyQualifiedResourceId, RemotelyTriggeredResource> resourcesWithContext = this.resources(contextId);
        ResourceCloseException ex = null;
        HashSet<FullyQualifiedResourceId> closedResources = new HashSet<FullyQualifiedResourceId>();
        UUID remoteHostId = null;
        for (Map.Entry<FullyQualifiedResourceId, RemotelyTriggeredResource> entry : resourcesWithContext.entrySet()) {
            try {
                entry.getValue().resource.close();
                closedResources.add(entry.getKey());
                if (remoteHostId == null) {
                    remoteHostId = entry.getValue().remoteHostId();
                }
                assert (remoteHostId.equals(entry.getValue().remoteHostId())) : "Resources of the same context triggered by different remote hosts [" + String.valueOf(remoteHostId) + ", " + String.valueOf(entry.getValue().remoteHostId()) + "].";
            }
            catch (Exception e) {
                if (ex == null) {
                    ex = new ResourceCloseException(entry.getKey(), entry.getValue().remoteHostId(), e);
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        if (!closedResources.isEmpty()) {
            assert (remoteHostId != null) : "Remote host is null, resources=" + String.valueOf(resourcesWithContext);
            for (FullyQualifiedResourceId resourceId : closedResources) {
                resourcesWithContext.remove(resourceId);
                this.removeRemoteHostResource(remoteHostId, resourceId);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void closeByRemoteHostId(UUID remoteHostId) {
        Set<FullyQualifiedResourceId> resourceIds = this.remoteHostsToResources.get(remoteHostId);
        for (FullyQualifiedResourceId resourceId : resourceIds) {
            try {
                this.close(resourceId);
            }
            catch (Exception e) {
                LOG.warn("Exception occurred during the orphan resource closing [resourceId={}].", (Throwable)e, new Object[]{resourceId});
            }
        }
    }

    private void addRemoteHostResource(UUID remoteHostId, FullyQualifiedResourceId resourceId) {
        this.remoteHostsToResources.compute(remoteHostId, (k, v) -> {
            if (v == null) {
                v = ConcurrentHashMap.newKeySet();
            }
            v.add(resourceId);
            return v;
        });
    }

    private void removeRemoteHostResource(UUID remoteHostId, FullyQualifiedResourceId resourceId) {
        this.remoteHostsToResources.computeIfPresent(remoteHostId, (k, v) -> {
            v.remove(resourceId);
            return v.isEmpty() ? null : v;
        });
    }

    private Map<FullyQualifiedResourceId, RemotelyTriggeredResource> resources(UUID contextId) {
        FullyQualifiedResourceId lowResourceId = FullyQualifiedResourceId.lower(contextId);
        FullyQualifiedResourceId upperResourceId = FullyQualifiedResourceId.upper(contextId);
        return this.resources.subMap((Object)lowResourceId, true, (Object)upperResourceId, true);
    }

    @TestOnly
    public Map<FullyQualifiedResourceId, RemotelyTriggeredResource> resources() {
        return Collections.unmodifiableMap(this.resources);
    }

    Set<UUID> registeredRemoteHosts() {
        return Collections.unmodifiableSet(this.remoteHostsToResources.keySet());
    }

    private static /* synthetic */ RemotelyTriggeredResource lambda$register$0(Supplier resourceProvider, UUID remoteHostId, FullyQualifiedResourceId k) {
        return new RemotelyTriggeredResource((ManuallyCloseable)resourceProvider.get(), remoteHostId);
    }

    public static class RemotelyTriggeredResource {
        private final ManuallyCloseable resource;
        private final UUID remoteHostId;

        public RemotelyTriggeredResource(ManuallyCloseable resource, UUID remoteHostId) {
            this.resource = resource;
            this.remoteHostId = remoteHostId;
        }

        public ManuallyCloseable resource() {
            return this.resource;
        }

        public UUID remoteHostId() {
            return this.remoteHostId;
        }
    }
}

