/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.closure;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.ignite.raft.jraft.Closure;
import org.apache.ignite.raft.jraft.Status;
import org.apache.ignite.raft.jraft.util.Requires;

public class JoinableClosure
implements Closure {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Closure closure;

    public JoinableClosure(Closure closure) {
        this.closure = Requires.requireNonNull(closure, "closure");
    }

    @Override
    public void run(Status status) {
        try {
            this.closure.run(status);
        }
        finally {
            this.latch.countDown();
        }
    }

    public void join() throws InterruptedException {
        this.latch.await();
    }

    public void join(long timeoutMillis) throws InterruptedException, TimeoutException {
        if (!this.latch.await(timeoutMillis, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("joined timeout");
        }
    }

    public Closure getClosure() {
        return this.closure;
    }
}

