/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.catalog.ColumnSorted;
import org.apache.ignite.catalog.IndexType;
import org.apache.ignite.internal.catalog.sql.AbstractCatalogQuery;
import org.apache.ignite.internal.catalog.sql.IndexColumnImpl;
import org.apache.ignite.internal.catalog.sql.Name;
import org.apache.ignite.internal.catalog.sql.QueryContext;
import org.apache.ignite.internal.catalog.sql.QueryPartCollection;
import org.apache.ignite.sql.IgniteSql;

class CreateIndexImpl
extends AbstractCatalogQuery<Name> {
    private Name indexName;
    private boolean ifNotExists;
    private final List<IndexColumnImpl> columns = new ArrayList<IndexColumnImpl>();
    private Name tableName;
    private IndexType indexType;

    CreateIndexImpl(IgniteSql sql) {
        super(sql);
    }

    @Override
    protected Name result() {
        return this.indexName;
    }

    CreateIndexImpl name(String name) {
        Objects.requireNonNull(name, "Index name must not be null.");
        this.indexName = Name.simple(name);
        return this;
    }

    CreateIndexImpl ifNotExists() {
        this.ifNotExists = true;
        return this;
    }

    public CreateIndexImpl on(Name tableName, List<ColumnSorted> columns) {
        this.tableName = tableName;
        for (ColumnSorted column : columns) {
            this.columns.add(IndexColumnImpl.wrap(column));
        }
        return this;
    }

    public CreateIndexImpl using(IndexType type) {
        this.indexType = type;
        return this;
    }

    @Override
    protected void accept(QueryContext ctx) {
        ctx.sql("CREATE INDEX ");
        if (this.ifNotExists) {
            ctx.sql("IF NOT EXISTS ");
        }
        ctx.visit(this.indexName);
        ctx.sql(" ON ");
        ctx.visit(this.tableName);
        if (this.indexType != null && this.indexType != IndexType.DEFAULT) {
            ctx.sql(" USING ").sql(this.indexType.name());
        }
        ctx.sql(" (");
        if (!this.columns.isEmpty()) {
            ctx.visit(QueryPartCollection.partsList(this.columns));
        }
        ctx.sql(");");
    }
}

