/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.hc.core5.http.message.BasicHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHeader {
    TestHeader() {
    }

    @Test
    void testBasicConstructor() {
        BasicHeader header = new BasicHeader("name", (Object)"value");
        Assertions.assertEquals((Object)"name", (Object)header.getName());
        Assertions.assertEquals((Object)"value", (Object)header.getValue());
    }

    @Test
    void testBasicConstructorNullValue() {
        BasicHeader header = new BasicHeader("name", null);
        Assertions.assertEquals((Object)"name", (Object)header.getName());
        Assertions.assertNull((Object)header.getValue());
    }

    @Test
    void testInvalidName() {
        Assertions.assertThrows(NullPointerException.class, () -> new BasicHeader(null, null));
    }

    @Test
    void testToString() {
        BasicHeader header1 = new BasicHeader("name1", (Object)"value1");
        Assertions.assertEquals((Object)"name1: value1", (Object)header1.toString());
        BasicHeader header2 = new BasicHeader("name2", null);
        Assertions.assertEquals((Object)"name2: ", (Object)header2.toString());
    }

    @Test
    void testSerialization() throws Exception {
        BasicHeader orig = new BasicHeader("name1", (Object)"value1");
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        try (ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);){
            outStream.writeObject(orig);
        }
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        BasicHeader clone = (BasicHeader)inStream.readObject();
        Assertions.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assertions.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
    }

    @Test
    void testClone() throws Exception {
        BasicHeader orig = new BasicHeader("name1", (Object)"value1");
        BasicHeader clone = orig.clone();
        Assertions.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assertions.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
    }
}

