/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.examples;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.ServerBootstrap;
import org.apache.hc.core5.http.impl.bootstrap.StandardFilter;
import org.apache.hc.core5.http.io.HttpFilterChain;
import org.apache.hc.core5.http.io.HttpFilterHandler;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.AbstractHttpServerAuthFilter;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.TimeValue;

public class ClassicServerFilterExample {
    public static void main(String[] args) throws Exception {
        int port = 8080;
        if (args.length >= 1) {
            port = Integer.parseInt(args[0]);
        }
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(15, TimeUnit.SECONDS).setTcpNoDelay(true).build();
        HttpServer server = ServerBootstrap.bootstrap().setListenerPort(port).setSocketConfig(socketConfig).replaceFilter(StandardFilter.EXPECT_CONTINUE.name(), (HttpFilterHandler)new AbstractHttpServerAuthFilter<String>(false){

            protected String parseChallengeResponse(String authorizationValue, HttpContext context) throws HttpException {
                return authorizationValue;
            }

            protected boolean authenticate(String challengeResponse, URIAuthority authority, String requestUri, HttpContext context) {
                return "let me pass".equals(challengeResponse);
            }

            protected String generateChallenge(String challengeResponse, URIAuthority authority, String requestUri, HttpContext context) {
                return "who goes there?";
            }
        }).addFilterFirst("my-filter", (request, responseTrigger, context, chain) -> {
            if (request.getRequestUri().equals("/back-door")) {
                BasicClassicHttpResponse response = new BasicClassicHttpResponse(200);
                response.setEntity((HttpEntity)new StringEntity("Welcome", ContentType.TEXT_PLAIN));
                responseTrigger.submitResponse((ClassicHttpResponse)response);
            } else {
                chain.proceed(request, new HttpFilterChain.ResponseTrigger(){

                    public void sendInformation(ClassicHttpResponse response) throws HttpException, IOException {
                        responseTrigger.sendInformation(response);
                    }

                    public void submitResponse(ClassicHttpResponse response) throws HttpException, IOException {
                        response.addHeader("X-Filter", (Object)"My-Filter");
                        responseTrigger.submitResponse(response);
                    }
                }, context);
            }
        }).register("*", (request, response, context) -> {
            response.setCode(200);
            response.setEntity((HttpEntity)new StringEntity("Hello"));
        }).create();
        server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> server.close(CloseMode.GRACEFUL)));
        System.out.println("Listening on port " + port);
        server.awaitTermination(TimeValue.MAX_VALUE);
    }
}

