/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogUtils {
    private static final String HIVE_L4J = "hive-log4j2.properties";
    private static final String HIVE_EXEC_L4J = "hive-exec-log4j2.properties";
    private static final Logger l4j = LoggerFactory.getLogger(LogUtils.class);
    private static final String KEY_TO_MASK_WITH = "password";
    private static final String MASKED_VALUE = "###_MASKED_###";
    public static final String SESSIONID_LOG_KEY = "sessionId";
    public static final String QUERYID_LOG_KEY = "queryId";
    public static final String DAGID_KEY = "dagId";
    public static final String OPERATIONLOG_LEVEL_KEY = "operationLogLevel";
    public static final String OPERATIONLOG_LOCATION_KEY = "operationLogLocation";

    public static String initHiveLog4j() throws LogInitializationException {
        return LogUtils.initHiveLog4jCommon(HiveConf.ConfVars.HIVE_LOG4J_FILE);
    }

    public static String initHiveExecLog4j() throws LogInitializationException {
        return LogUtils.initHiveLog4jCommon(HiveConf.ConfVars.HIVE_EXEC_LOG4J_FILE);
    }

    private static String initHiveLog4jCommon(HiveConf.ConfVars confVarName) throws LogInitializationException {
        HiveConf conf = new HiveConf();
        return LogUtils.initHiveLog4jCommon(conf, confVarName);
    }

    @VisibleForTesting
    public static String initHiveLog4jCommon(HiveConf conf, HiveConf.ConfVars confVarName) throws LogInitializationException {
        if (HiveConf.getVar(conf, confVarName).equals("")) {
            return LogUtils.initHiveLog4jDefault(conf, "", confVarName);
        }
        String log4jFileName = HiveConf.getVar(conf, confVarName);
        File log4jConfigFile = new File(log4jFileName);
        boolean fileExists = log4jConfigFile.exists();
        if (!fileExists) {
            return LogUtils.initHiveLog4jDefault(conf, "Not able to find conf file: " + String.valueOf(log4jConfigFile), confVarName);
        }
        if (confVarName == HiveConf.ConfVars.HIVE_EXEC_LOG4J_FILE) {
            Object queryId = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_QUERY_ID);
            if (queryId == null || ((String)(queryId = ((String)queryId).trim())).isEmpty()) {
                queryId = "unknown-" + System.currentTimeMillis();
            }
            System.setProperty(HiveConf.ConfVars.HIVE_QUERY_ID.toString(), (String)queryId);
        }
        boolean async = LogUtils.checkAndSetAsyncLogging(conf);
        System.setProperty("isThreadContextMapInheritable", "true");
        Configurator.initialize(null, (String)log4jFileName);
        LogUtils.logConfigLocation(conf);
        return "Logging initialized using configuration in " + String.valueOf(log4jConfigFile) + " Async: " + async;
    }

    public static boolean checkAndSetAsyncLogging(Configuration conf) {
        boolean asyncLogging = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_ASYNC_LOG_ENABLED);
        if (asyncLogging) {
            System.setProperty("Log4jContextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
            LogManager.setFactory((LoggerContextFactory)new Log4jContextFactory());
        }
        return asyncLogging;
    }

    private static String initHiveLog4jDefault(HiveConf conf, String logMessage, HiveConf.ConfVars confVarName) throws LogInitializationException {
        URL hive_l4j = null;
        switch (confVarName) {
            case HIVE_EXEC_LOG4J_FILE: {
                hive_l4j = LogUtils.class.getClassLoader().getResource(HIVE_EXEC_L4J);
                if (hive_l4j == null) {
                    hive_l4j = LogUtils.class.getClassLoader().getResource(HIVE_L4J);
                }
                System.setProperty(HiveConf.ConfVars.HIVE_QUERY_ID.toString(), HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_QUERY_ID));
                break;
            }
            case HIVE_LOG4J_FILE: {
                hive_l4j = LogUtils.class.getClassLoader().getResource(HIVE_L4J);
                break;
            }
        }
        if (hive_l4j != null) {
            boolean async = LogUtils.checkAndSetAsyncLogging(conf);
            System.setProperty("isThreadContextMapInheritable", "true");
            Configurator.initialize(null, (String)hive_l4j.toString());
            LogUtils.logConfigLocation(conf);
            return logMessage + "\nLogging initialized using configuration in " + String.valueOf(hive_l4j) + " Async: " + async;
        }
        throw new LogInitializationException(logMessage + "Unable to initialize logging using hive-log4j2.properties, not found on CLASSPATH!");
    }

    private static void logConfigLocation(HiveConf conf) throws LogInitializationException {
        if (conf.getHiveDefaultLocation() != null) {
            l4j.warn("DEPRECATED: Ignoring hive-default.xml found on the CLASSPATH at " + conf.getHiveDefaultLocation().getPath());
        }
        if (conf.getHiveSiteLocation() == null) {
            l4j.warn("hive-site.xml not found on CLASSPATH");
        } else {
            l4j.debug("Using hive-site.xml found on CLASSPATH at " + conf.getHiveSiteLocation().getPath());
        }
    }

    public static String maskIfPassword(String key, String value) {
        if (key != null && value != null && key.toLowerCase().indexOf(KEY_TO_MASK_WITH) != -1) {
            return MASKED_VALUE;
        }
        return value;
    }

    public static void registerLoggingContext(Configuration conf) {
        if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED)) {
            MDC.put((String)SESSIONID_LOG_KEY, (String)HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_SESSION_ID));
            MDC.put((String)QUERYID_LOG_KEY, (String)HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_QUERY_ID));
            MDC.put((String)OPERATIONLOG_LEVEL_KEY, (String)HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LEVEL));
            MDC.put((String)OPERATIONLOG_LOCATION_KEY, (String)HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LOG_LOCATION));
            l4j.info("Thread context registration is done.");
        } else {
            l4j.info("Thread context registration is skipped.");
        }
    }

    public static void unregisterLoggingContext() {
        MDC.remove((String)SESSIONID_LOG_KEY);
        MDC.remove((String)QUERYID_LOG_KEY);
        MDC.remove((String)DAGID_KEY);
        MDC.remove((String)OPERATIONLOG_LEVEL_KEY);
        MDC.remove((String)OPERATIONLOG_LOCATION_KEY);
        l4j.info("Unregistered logging context.");
    }

    public static String getLogFilePath() {
        String logFilePath = null;
        org.apache.logging.log4j.Logger rootLogger = LogManager.getRootLogger();
        if (rootLogger instanceof org.apache.logging.log4j.core.Logger) {
            org.apache.logging.log4j.core.Logger coreLogger = (org.apache.logging.log4j.core.Logger)rootLogger;
            for (Appender appender : coreLogger.getAppenders().values()) {
                if (appender instanceof FileAppender) {
                    FileAppender fileAppender = (FileAppender)appender;
                    logFilePath = fileAppender.getFileName();
                    continue;
                }
                if (appender instanceof RollingFileAppender) {
                    RollingFileAppender fileAppender = (RollingFileAppender)appender;
                    logFilePath = fileAppender.getFileName();
                    continue;
                }
                if (!(appender instanceof RollingRandomAccessFileAppender)) continue;
                RollingRandomAccessFileAppender fileAppender = (RollingRandomAccessFileAppender)appender;
                logFilePath = fileAppender.getFileName();
            }
        }
        return logFilePath;
    }

    public static void putToMDC(String key, String value) {
        MDC.put((String)key, (String)value);
    }

    public static class LogInitializationException
    extends Exception {
        public LogInitializationException(String msg) {
            super(msg);
        }
    }
}

