/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.federation;

import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.federation.FederatedStoreManager;

public class FederatedPersistenceHandler
implements StorePersistenceHandler {
    FederatedStoreManager storeMgr;

    public FederatedPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (FederatedStoreManager)storeMgr;
    }

    @Override
    public void close() {
    }

    public boolean useReferentialIntegrity() {
        return false;
    }

    @Override
    public void insertObjects(DNStateManager ... sms) {
        for (int i = 0; i < sms.length; ++i) {
            this.insertObject(sms[i]);
        }
    }

    @Override
    public void deleteObjects(DNStateManager ... sms) {
        for (int i = 0; i < sms.length; ++i) {
            this.deleteObject(sms[i]);
        }
    }

    @Override
    public void batchStart(ExecutionContext ec, StorePersistenceHandler.PersistenceBatchType batchType) {
    }

    @Override
    public void batchEnd(ExecutionContext ec, StorePersistenceHandler.PersistenceBatchType type) {
    }

    @Override
    public void insertObject(DNStateManager sm) {
        StoreManager classStoreMgr = this.storeMgr.getStoreManagerForClass(sm.getClassMetaData());
        classStoreMgr.getPersistenceHandler().insertObject(sm);
    }

    @Override
    public void updateObject(DNStateManager sm, int[] fieldNumbers) {
        StoreManager classStoreMgr = this.storeMgr.getStoreManagerForClass(sm.getClassMetaData());
        classStoreMgr.getPersistenceHandler().updateObject(sm, fieldNumbers);
    }

    @Override
    public void deleteObject(DNStateManager sm) {
        StoreManager classStoreMgr = this.storeMgr.getStoreManagerForClass(sm.getClassMetaData());
        classStoreMgr.getPersistenceHandler().deleteObject(sm);
    }

    @Override
    public void fetchObject(DNStateManager sm, int[] fieldNumbers) {
        StoreManager classStoreMgr = this.storeMgr.getStoreManagerForClass(sm.getClassMetaData());
        classStoreMgr.getPersistenceHandler().fetchObject(sm, fieldNumbers);
    }

    @Override
    public void fetchObjects(int[] fieldNumbers, DNStateManager ... sms) {
        for (DNStateManager sm : sms) {
            this.fetchObject(sm, fieldNumbers);
        }
    }

    @Override
    public void locateObject(DNStateManager sm) {
        StoreManager classStoreMgr = this.storeMgr.getStoreManagerForClass(sm.getClassMetaData());
        classStoreMgr.getPersistenceHandler().locateObject(sm);
    }

    @Override
    public void locateObjects(DNStateManager[] sms) {
        StoreManager classStoreMgr = this.storeMgr.getStoreManagerForClass(sms[0].getClassMetaData());
        classStoreMgr.getPersistenceHandler().locateObjects(sms);
    }

    @Override
    public Object findObject(ExecutionContext ec, Object id) {
        return null;
    }

    @Override
    public Object[] findObjects(ExecutionContext ec, Object[] ids) {
        return null;
    }

    @Override
    public Object findObjectForUnique(ExecutionContext ec, AbstractClassMetaData cmd, String[] memberNames, Object[] values) {
        return null;
    }
}

