/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.HashSet;
import java.util.Set;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;

public class PersistenceFileMetaData
extends MetaData {
    private static final long serialVersionUID = -5448349113062382507L;
    protected String filename = null;
    protected Set<PersistenceUnitMetaData> persistenceUnits = new HashSet<PersistenceUnitMetaData>();

    public PersistenceFileMetaData(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getNoOfPersistenceUnits() {
        return this.persistenceUnits.size();
    }

    public PersistenceUnitMetaData getPersistenceUnit(String name) {
        for (PersistenceUnitMetaData pumd : this.persistenceUnits) {
            if (!pumd.name.equals(name)) continue;
            return pumd;
        }
        return null;
    }

    public PersistenceUnitMetaData[] getPersistenceUnits() {
        if (this.persistenceUnits.isEmpty()) {
            return null;
        }
        return this.persistenceUnits.toArray(new PersistenceUnitMetaData[this.persistenceUnits.size()]);
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void addPersistenceUnit(PersistenceUnitMetaData pumd) {
        if (pumd == null) {
            return;
        }
        pumd.parent = this;
        for (PersistenceUnitMetaData persistenceUnitMD : this.persistenceUnits) {
            if (!pumd.getName().equals(persistenceUnitMD.getName())) continue;
            return;
        }
        this.persistenceUnits.add(pumd);
    }

    public String toString(String indent) {
        if (indent == null) {
            indent = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<persistence>\n");
        for (PersistenceUnitMetaData pumd : this.persistenceUnits) {
            sb.append(pumd.toString(indent, indent));
        }
        sb.append("</persistence>");
        return sb.toString();
    }
}

