/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.metadata.api;

import javax.jdo.metadata.ClassMetadata;
import javax.jdo.metadata.FetchPlanMetadata;
import javax.jdo.metadata.InterfaceMetadata;
import javax.jdo.metadata.JDOMetadata;
import javax.jdo.metadata.PackageMetadata;
import javax.jdo.metadata.QueryMetadata;
import org.datanucleus.api.jdo.metadata.api.AbstractMetadataImpl;
import org.datanucleus.api.jdo.metadata.api.ClassMetadataImpl;
import org.datanucleus.api.jdo.metadata.api.FetchPlanMetadataImpl;
import org.datanucleus.api.jdo.metadata.api.InterfaceMetadataImpl;
import org.datanucleus.api.jdo.metadata.api.PackageMetadataImpl;
import org.datanucleus.api.jdo.metadata.api.QueryMetadataImpl;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.FetchPlanMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataFileType;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.QueryMetaData;
import org.datanucleus.util.ClassUtils;

public class JDOMetadataImpl
extends AbstractMetadataImpl
implements JDOMetadata {
    public JDOMetadataImpl() {
        super((MetaData)new FileMetaData());
        this.getInternal().setType(MetaDataFileType.JDO_FILE);
    }

    public JDOMetadataImpl(FileMetaData filemd) {
        super((MetaData)filemd);
    }

    public FileMetaData getInternal() {
        return (FileMetaData)this.internalMD;
    }

    public FetchPlanMetadata[] getFetchPlans() {
        FetchPlanMetaData[] baseFps = this.getInternal().getFetchPlans();
        if (baseFps == null) {
            return null;
        }
        FetchPlanMetadata[] fps = new FetchPlanMetadataImpl[baseFps.length];
        for (int i = 0; i < fps.length; ++i) {
            fps[i] = new FetchPlanMetadataImpl(baseFps[i]);
            fps[i].parent = this;
        }
        return fps;
    }

    public FetchPlanMetadata newFetchPlanMetadata(String name) {
        FetchPlanMetaData internalFpmd = this.getInternal().newFetchPlanMetaData(name);
        FetchPlanMetadataImpl fpmd = new FetchPlanMetadataImpl(internalFpmd);
        fpmd.parent = this;
        return fpmd;
    }

    public int getNumberOfFetchPlans() {
        return this.getInternal().getNoOfFetchPlans();
    }

    public QueryMetadata[] getQueries() {
        QueryMetaData[] baseQueries = this.getInternal().getQueries();
        if (baseQueries == null) {
            return null;
        }
        QueryMetadata[] queries = new QueryMetadataImpl[this.getInternal().getNoOfQueries()];
        for (int i = 0; i < queries.length; ++i) {
            queries[i] = new QueryMetadataImpl(baseQueries[i]);
            queries[i].parent = this;
        }
        return queries;
    }

    public int getNumberOfQueries() {
        return this.getInternal().getNoOfQueries();
    }

    public QueryMetadata newQueryMetadata(String name) {
        QueryMetaData internalQmd = this.getInternal().newQueryMetaData(name);
        QueryMetadataImpl qmd = new QueryMetadataImpl(internalQmd);
        qmd.parent = this;
        return qmd;
    }

    public PackageMetadata[] getPackages() {
        PackageMetadata[] pmds = new PackageMetadataImpl[this.getInternal().getNoOfPackages()];
        for (int i = 0; i < pmds.length; ++i) {
            pmds[i] = new PackageMetadataImpl(this.getInternal().getPackage(i));
            pmds[i].parent = this;
        }
        return pmds;
    }

    public int getNumberOfPackages() {
        return this.getInternal().getNoOfPackages();
    }

    public PackageMetadata newPackageMetadata(String name) {
        PackageMetaData internalPmd = this.getInternal().newPackageMetaData(name);
        PackageMetadataImpl pmd = new PackageMetadataImpl(internalPmd);
        pmd.parent = this;
        return pmd;
    }

    public PackageMetadata newPackageMetadata(Package pkg) {
        PackageMetaData internalPmd = this.getInternal().newPackageMetaData(pkg.getName());
        PackageMetadataImpl pmd = new PackageMetadataImpl(internalPmd);
        pmd.parent = this;
        return pmd;
    }

    public ClassMetadata newClassMetadata(Class cls) {
        String packageName = ClassUtils.getPackageNameForClass((Class)cls);
        PackageMetaData internalPmd = this.getInternal().newPackageMetaData(packageName);
        PackageMetadataImpl pmd = new PackageMetadataImpl(internalPmd);
        pmd.parent = this;
        String className = ClassUtils.getClassNameForClass((Class)cls);
        ClassMetaData internalCmd = internalPmd.newClassMetaData(className);
        ClassMetadataImpl cmd = new ClassMetadataImpl(internalCmd);
        cmd.parent = pmd;
        return cmd;
    }

    public InterfaceMetadata newInterfaceMetadata(Class cls) {
        String packageName = ClassUtils.getPackageNameForClass((Class)cls);
        PackageMetaData internalPmd = this.getInternal().newPackageMetaData(packageName);
        PackageMetadataImpl pmd = new PackageMetadataImpl(internalPmd);
        pmd.parent = this;
        String className = ClassUtils.getClassNameForClass((Class)cls);
        InterfaceMetaData internalImd = internalPmd.newInterfaceMetaData(className);
        InterfaceMetadataImpl imd = new InterfaceMetadataImpl(internalImd);
        imd.parent = pmd;
        return imd;
    }

    public String getCatalog() {
        return this.getInternal().getCatalog();
    }

    public JDOMetadata setCatalog(String cat) {
        this.getInternal().setCatalog(cat);
        return this;
    }

    public String getSchema() {
        return this.getInternal().getSchema();
    }

    public JDOMetadata setSchema(String sch) {
        this.getInternal().setSchema(sch);
        return this;
    }
}

