/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.compaction.evaluator.amoro;

import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.TableFileScanHelper;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class IcebergTableFileScanHelper
implements TableFileScanHelper {
    private final Table table;
    private Expression partitionFilter = Expressions.alwaysTrue();
    private final long snapshotId;

    public IcebergTableFileScanHelper(Table table, long snapshotId) {
        this.table = table;
        this.snapshotId = snapshotId;
    }

    @Override
    public CloseableIterable<TableFileScanHelper.FileScanResult> scan() {
        return CloseableIterable.transform(((TableScan)this.table.newScan().useSnapshot(this.snapshotId).filter(this.partitionFilter)).planFiles(), this::buildFileScanResult);
    }

    protected TableFileScanHelper.FileScanResult buildFileScanResult(FileScanTask fileScanTask) {
        return new TableFileScanHelper.FileScanResult((DataFile)fileScanTask.file(), Lists.newArrayList(fileScanTask.deletes()));
    }

    @Override
    public TableFileScanHelper withPartitionFilter(Expression filter) {
        this.partitionFilter = filter;
        return this;
    }
}

