/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import org.apache.hive.iceberg.org.apache.avro.generic.GenericData;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;

public class IdentityPartitionConverters {
    private IdentityPartitionConverters() {
    }

    public static Object convertConstant(Type type, Object value) {
        if (value == null) {
            return null;
        }
        switch (type.typeId()) {
            case STRING: {
                return value.toString();
            }
            case TIME: {
                return DateTimeUtil.timeFromMicros((Long)value);
            }
            case DATE: {
                return DateTimeUtil.dateFromDays((Integer)value);
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    return DateTimeUtil.timestamptzFromMicros((Long)value);
                }
                return DateTimeUtil.timestampFromMicros((Long)value);
            }
            case FIXED: {
                if (value instanceof GenericData.Fixed) {
                    return ((GenericData.Fixed)value).bytes();
                }
                return value;
            }
        }
        return value;
    }
}

