/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import java.security.Key;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;

public interface JwtSecretProvider {
    public Key getEncryptionSecret();

    public Key getDecryptionSecret();

    public void init(Configuration var1);

    public static JwtSecretProvider initAndGet(Configuration conf) {
        JwtSecretProvider provider;
        String providerClass = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_EXTERNAL_CLIENT_CLOUD_JWT_SHARED_SECRET_PROVIDER);
        try {
            provider = (JwtSecretProvider)Class.forName(providerClass).newInstance();
            provider.init(conf);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Unable to instantiate provider: " + providerClass, e);
        }
        return provider;
    }
}

