/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.auth.jwt;

import com.google.common.collect.Sets;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.proc.BadJOSEException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.auth.jwt.JWTValidator;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJWTAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger((String)SimpleJWTAuthenticator.class.getName());
    private static final Set<JOSEObjectType> ACCEPTABLE_TYPES = Sets.newHashSet((Object[])new JOSEObjectType[]{null, JOSEObjectType.JWT});
    private final JWTValidator validator;

    public static SimpleJWTAuthenticator create(Configuration conf) throws IOException {
        Collection plainJwksURLs = MetastoreConf.getStringCollection((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_METASTORE_AUTHENTICATION_JWT_JWKS_URL);
        if (plainJwksURLs.isEmpty()) {
            throw new IOException("Invalid value of property: " + MetastoreConf.ConfVars.THRIFT_METASTORE_AUTHENTICATION_JWT_JWKS_URL.getHiveName());
        }
        ArrayList<URL> jwksURLs = new ArrayList<URL>(plainJwksURLs.size());
        for (String url : plainJwksURLs) {
            jwksURLs.add(URI.create(url).toURL());
            LOG.info("Loaded JWKS from {}", (Object)url);
        }
        JWTValidator validator = new JWTValidator(ACCEPTABLE_TYPES, jwksURLs, null, null, Collections.singleton("sub"));
        return new SimpleJWTAuthenticator(validator);
    }

    public SimpleJWTAuthenticator(JWTValidator validator) {
        this.validator = validator;
    }

    public String resolveUserName(String bearerToken) throws ParseException, BadJOSEException, JOSEException {
        return this.validator.validateJWT(bearerToken).getSubject();
    }
}

