/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.Msck;
import org.apache.hadoop.hive.metastore.MsckInfo;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.conf.TimeValidator;
import org.apache.hadoop.hive.metastore.utils.TableFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionManagementTask
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionManagementTask.class);
    public static final String DISCOVER_PARTITIONS_TBLPROPERTY = "discover.partitions";
    public static final String PARTITION_RETENTION_PERIOD_TBLPROPERTY = "partition.retention.period";
    private static final Lock lock = new ReentrantLock();
    private static int completedAttempts;
    private static int skippedAttempts;
    private Configuration conf;

    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_MANAGEMENT_TASK_FREQUENCY, (TimeUnit)unit);
    }

    public void setConf(Configuration configuration) {
        this.conf = new Configuration(configuration);
    }

    public Configuration getConf() {
        return this.conf;
    }

    private static boolean partitionDiscoveryEnabled(Map<String, String> params) {
        return params != null && params.containsKey(DISCOVER_PARTITIONS_TBLPROPERTY) && params.get(DISCOVER_PARTITIONS_TBLPROPERTY).equalsIgnoreCase("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (lock.tryLock()) {
            skippedAttempts = 0;
            String qualifiedTableName = null;
            HiveMetaStoreClient msc = null;
            try {
                msc = new HiveMetaStoreClient(this.conf);
                String catalogName = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_MANAGEMENT_CATALOG_NAME);
                String dbPattern = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_MANAGEMENT_DATABASE_PATTERN);
                String tablePattern = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_MANAGEMENT_TABLE_PATTERN);
                String tableTypes = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_MANAGEMENT_TABLE_TYPES);
                List candidates = new TableFetcher.Builder((IMetaStoreClient)msc, catalogName, dbPattern, tablePattern).tableTypes(tableTypes).tableCondition("hive_filter_field_params__discover__partitions like \"true\" ").build().getTableNames();
                if (candidates.isEmpty()) {
                    LOG.info("Got empty table list in catalog: {}, dbPattern: {}", (Object)catalogName, (Object)dbPattern);
                    return;
                }
                int threadPoolSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_MANAGEMENT_TASK_THREAD_POOL_SIZE);
                ExecutorService executorService = Executors.newFixedThreadPool(Math.min(candidates.size(), threadPoolSize), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("PartitionDiscoveryTask-%d").build());
                CountDownLatch countDownLatch = new CountDownLatch(candidates.size());
                LOG.info("Found {} candidate tables for partition discovery", (Object)candidates.size());
                this.setupMsckPathInvalidation();
                Configuration msckConf = Msck.getMsckConf(this.conf);
                for (TableName table : candidates) {
                    MsckInfo msckInfo = new MsckInfo(table.getCat(), table.getDb(), table.getTable(), null, null, true, true, true, -1L);
                    executorService.submit(new MsckThread(msckInfo, msckConf, qualifiedTableName, countDownLatch));
                }
                countDownLatch.await();
                executorService.shutdownNow();
            }
            catch (Exception e) {
                LOG.error("Exception while running partition discovery task for table: " + qualifiedTableName, (Throwable)e);
            }
            finally {
                if (msc != null) {
                    msc.close();
                }
                lock.unlock();
            }
            ++completedAttempts;
        } else {
            LOG.info("Lock is held by some other partition discovery task. Skipping this attempt..#{}", (Object)(++skippedAttempts));
        }
    }

    public static long getRetentionPeriodInSeconds(Table table) {
        long retentionSeconds = -1L;
        if (table.getParameters() != null && table.getParameters().containsKey(PARTITION_RETENTION_PERIOD_TBLPROPERTY)) {
            String retentionPeriod = (String)table.getParameters().get(PARTITION_RETENTION_PERIOD_TBLPROPERTY);
            if (retentionPeriod.isEmpty()) {
                LOG.warn("'{}' table property is defined but empty. Skipping retention period..", (Object)PARTITION_RETENTION_PERIOD_TBLPROPERTY);
            } else {
                try {
                    TimeValidator timeValidator = new TimeValidator(TimeUnit.SECONDS);
                    timeValidator.validate(retentionPeriod);
                    retentionSeconds = MetastoreConf.convertTimeStr((String)retentionPeriod, (TimeUnit)TimeUnit.SECONDS, (TimeUnit)TimeUnit.SECONDS);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("'{}' retentionPeriod value is invalid. Skipping retention period..", (Object)retentionPeriod);
                }
            }
        }
        return retentionSeconds;
    }

    private void setupMsckPathInvalidation() {
        this.conf.set(MetastoreConf.ConfVars.MSCK_PATH_VALIDATION.getVarname(), "skip");
    }

    @VisibleForTesting
    public static int getSkippedAttempts() {
        return skippedAttempts;
    }

    @VisibleForTesting
    public static int getCompletedAttempts() {
        return completedAttempts;
    }

    private static class MsckThread
    implements Runnable {
        private MsckInfo msckInfo;
        private Configuration conf;
        private String qualifiedTableName;
        private CountDownLatch countDownLatch;

        MsckThread(MsckInfo msckInfo, Configuration conf, String qualifiedTableName, CountDownLatch countDownLatch) {
            this.msckInfo = msckInfo;
            this.conf = conf;
            this.qualifiedTableName = qualifiedTableName;
            this.countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            try {
                Msck msck = new Msck(true, true);
                msck.init(this.conf);
                msck.repair(this.msckInfo);
            }
            catch (Exception e) {
                LOG.error("Exception while running partition discovery task for table: " + this.qualifiedTableName, (Throwable)e);
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }
}

