/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.datastore.JDOConnection;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.metastore.AggregateStatsCache;
import org.apache.hadoop.hive.metastore.Batchable;
import org.apache.hadoop.hive.metastore.ColumnType;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.DirectSqlInsertPart;
import org.apache.hadoop.hive.metastore.DirectSqlUpdatePart;
import org.apache.hadoop.hive.metastore.IExtrapolatePartStatus;
import org.apache.hadoop.hive.metastore.LinearExtrapolatePartStatus;
import org.apache.hadoop.hive.metastore.MetastoreDirectSqlUtils;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.PartitionProjectionEvaluator;
import org.apache.hadoop.hive.metastore.PersistenceManagerProvider;
import org.apache.hadoop.hive.metastore.QueryWrapper;
import org.apache.hadoop.hive.metastore.StatObjectConverter;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DatabaseType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.GetPartitionsFilterSpec;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.GetPartitionsArgs;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.model.MConstraint;
import org.apache.hadoop.hive.metastore.model.MCreationMetadata;
import org.apache.hadoop.hive.metastore.model.MDatabase;
import org.apache.hadoop.hive.metastore.model.MNotificationLog;
import org.apache.hadoop.hive.metastore.model.MNotificationNextId;
import org.apache.hadoop.hive.metastore.model.MPartition;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnStatistics;
import org.apache.hadoop.hive.metastore.model.MPartitionPrivilege;
import org.apache.hadoop.hive.metastore.model.MTable;
import org.apache.hadoop.hive.metastore.model.MTableColumnStatistics;
import org.apache.hadoop.hive.metastore.model.MWMResourcePlan;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hive.common.util.BloomFilter;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetaStoreDirectSql {
    private static final int NO_BATCHING = -1;
    private static final int DETECT_BATCHING = 0;
    private static final Set<String> ALLOWED_TABLES_TO_LOCK = Set.of("NOTIFICATION_SEQUENCE");
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreDirectSql.class);
    private final PersistenceManager pm;
    private final Configuration conf;
    private final String schema;
    private final DatabaseProduct dbType;
    private final int batchSize;
    private final boolean convertMapNullsToEmptyStrings;
    private final String defaultPartName;
    private final boolean isTxnStatsEnabled;
    private final boolean isCompatibleDatastore;
    private final boolean isAggregateStatsCacheEnabled;
    private final ImmutableMap<String, String> fieldnameToTableName;
    private AggregateStatsCache aggrStatsCache;
    private DirectSqlUpdatePart directSqlUpdatePart;
    private DirectSqlInsertPart directSqlInsertPart;
    @TableName
    private String DBS;
    @TableName
    private String TBLS;
    @TableName
    private String PARTITIONS;
    @TableName
    private String DATABASE_PARAMS;
    @TableName
    private String PARTITION_PARAMS;
    @TableName
    private String SORT_COLS;
    @TableName
    private String SD_PARAMS;
    @TableName
    private String SDS;
    @TableName
    private String SERDES;
    @TableName
    private String SKEWED_STRING_LIST_VALUES;
    @TableName
    private String SKEWED_VALUES;
    @TableName
    private String BUCKETING_COLS;
    @TableName
    private String SKEWED_COL_NAMES;
    @TableName
    private String SKEWED_COL_VALUE_LOC_MAP;
    @TableName
    private String COLUMNS_V2;
    @TableName
    private String PARTITION_KEYS;
    @TableName
    private String SERDE_PARAMS;
    @TableName
    private String PART_COL_STATS;
    @TableName
    private String KEY_CONSTRAINTS;
    @TableName
    private String TAB_COL_STATS;
    @TableName
    private String PARTITION_KEY_VALS;
    @TableName
    private String PART_PRIVS;
    @TableName
    private String PART_COL_PRIVS;
    @TableName
    private String SKEWED_STRING_LIST;
    @TableName
    private String CDS;
    @TableName
    private String TBL_COL_PRIVS;
    @TableName
    private String FUNCS;
    @TableName
    private String FUNC_RU;
    public static final Object[] STATS_TABLE_TYPES = new Object[]{TableType.MANAGED_TABLE.toString(), TableType.MATERIALIZED_VIEW.toString()};

    public static <T> String getIdListForIn(Collection<T> objectIds) throws MetaException {
        return objectIds.stream().map(i -> i.toString()).collect(Collectors.joining(","));
    }

    public MetaStoreDirectSql(PersistenceManager pm, Configuration conf, String schema) {
        this.pm = pm;
        this.conf = conf;
        this.schema = schema;
        this.dbType = PersistenceManagerProvider.getDatabaseProduct();
        int batchSize = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DIRECT_SQL_PARTITION_BATCH_SIZE);
        this.directSqlInsertPart = new DirectSqlInsertPart(pm, this.dbType, batchSize);
        if (batchSize == 0) {
            batchSize = this.dbType.needsInBatching() ? 1000 : -1;
        }
        this.batchSize = batchSize;
        this.isTxnStatsEnabled = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_TXN_STATS_ENABLED);
        this.directSqlUpdatePart = new DirectSqlUpdatePart(pm, conf, this.dbType, batchSize);
        ImmutableMap.Builder fieldNameToTableNameBuilder = new ImmutableMap.Builder();
        for (Field f : this.getClass().getDeclaredFields()) {
            if (f.getAnnotation(TableName.class) == null) continue;
            try {
                String value = MetaStoreDirectSql.getFullyQualifiedName(schema, f.getName());
                f.set(this, value);
                fieldNameToTableNameBuilder.put((Object)f.getName(), (Object)value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException("Internal error, cannot set " + f.getName());
            }
        }
        this.convertMapNullsToEmptyStrings = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ORM_RETRIEVE_MAPNULLS_AS_EMPTY_STRINGS);
        this.defaultPartName = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DEFAULTPARTITIONNAME);
        String jdoIdFactory = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.IDENTIFIER_FACTORY);
        if (!"datanucleus1".equalsIgnoreCase(jdoIdFactory)) {
            LOG.warn("Underlying metastore does not use 'datanucleus1' for its ORM naming scheme. Disabling directSQL as it uses hand-hardcoded SQL with that assumption.");
            this.isCompatibleDatastore = false;
        } else {
            boolean isInTest = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST);
            boolean bl = this.isCompatibleDatastore = (!isInTest || this.ensureDbInit()) && this.runTestQuery();
            if (this.isCompatibleDatastore) {
                LOG.debug("Using direct SQL, underlying DB is " + String.valueOf(this.dbType));
            }
        }
        this.isAggregateStatsCacheEnabled = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_ENABLED);
        if (this.isAggregateStatsCacheEnabled) {
            this.aggrStatsCache = AggregateStatsCache.getInstance(conf);
        }
        this.fieldnameToTableName = fieldNameToTableNameBuilder.put((Object)"createTime", (Object)(this.PARTITIONS + ".\"CREATE_TIME\"")).put((Object)"lastAccessTime", (Object)(this.PARTITIONS + ".\"LAST_ACCESS_TIME\"")).put((Object)"writeId", (Object)(this.PARTITIONS + ".\"WRITE_ID\"")).put((Object)"sd.location", (Object)(this.SDS + ".\"LOCATION\"")).put((Object)"sd.inputFormat", (Object)(this.SDS + ".\"INPUT_FORMAT\"")).put((Object)"sd.outputFormat", (Object)(this.SDS + ".\"OUTPUT_FORMAT\"")).put((Object)"sd.storedAsSubDirectories", (Object)(this.SDS + ".\"IS_STOREDASSUBDIRECTORIES\"")).put((Object)"sd.compressed", (Object)(this.SDS + ".\"IS_COMPRESSED\"")).put((Object)"sd.numBuckets", (Object)(this.SDS + ".\"NUM_BUCKETS\"")).put((Object)"sd.serdeInfo.name", (Object)(this.SERDES + ".\"NAME\"")).put((Object)"sd.serdeInfo.serializationLib", (Object)(this.SERDES + ".\"SLIB\"")).put((Object)"PART_ID", (Object)(this.PARTITIONS + ".\"PART_ID\"")).put((Object)"SD_ID", (Object)(this.SDS + ".\"SD_ID\"")).put((Object)"SERDE_ID", (Object)(this.SERDES + ".\"SERDE_ID\"")).put((Object)"CD_ID", (Object)(this.SDS + ".\"CD_ID\"")).build();
    }

    private static String getFullyQualifiedName(String schema, String tblName) {
        return (String)(schema == null || schema.isEmpty() ? "" : "\"" + schema + "\".\"") + "\"" + tblName + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureDbInit() {
        Transaction tx = this.pm.currentTransaction();
        boolean doCommit = false;
        if (!tx.isActive()) {
            tx.begin();
            doCommit = true;
        }
        LinkedList<Query> initQueries = new LinkedList<Query>();
        try {
            initQueries.add(this.pm.newQuery(MDatabase.class, "name == ''"));
            initQueries.add(this.pm.newQuery(MTableColumnStatistics.class, "colName == ''"));
            initQueries.add(this.pm.newQuery(MPartitionColumnStatistics.class, "colName == ''"));
            initQueries.add(this.pm.newQuery(MConstraint.class, "childIntegerIndex < 0"));
            initQueries.add(this.pm.newQuery(MNotificationLog.class, "dbName == ''"));
            initQueries.add(this.pm.newQuery(MNotificationNextId.class, "nextEventId < -1"));
            initQueries.add(this.pm.newQuery(MWMResourcePlan.class, "name == ''"));
            initQueries.add(this.pm.newQuery(MCreationMetadata.class, "dbName == ''"));
            initQueries.add(this.pm.newQuery(MPartitionPrivilege.class, "principalName == ''"));
            initQueries.add(this.pm.newQuery(MPartitionColumnPrivilege.class, "principalName == ''"));
            for (Query q : initQueries) {
                q.execute();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            doCommit = false;
            LOG.warn("Database initialization failed; direct SQL is disabled", (Throwable)ex);
            tx.rollback();
            boolean bl = false;
            return bl;
        }
        finally {
            if (doCommit) {
                tx.commit();
            }
            for (Query q : initQueries) {
                try {
                    q.closeAll();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runTestQuery() {
        boolean doTrace = LOG.isDebugEnabled();
        Transaction tx = this.pm.currentTransaction();
        boolean doCommit = false;
        if (!tx.isActive()) {
            tx.begin();
            doCommit = true;
        }
        String selfTestQuery = "select \"DB_ID\" from " + this.DBS + " WHERE \"DB_ID\"=1";
        try {
            QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)selfTestQuery));
            try {
                this.prepareTxn();
                long start = doTrace ? System.nanoTime() : 0L;
                query.execute();
                MetastoreDirectSqlUtils.timingTrace(doTrace, selfTestQuery, start, doTrace ? System.nanoTime() : 0L);
                boolean bl = true;
                query.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        query.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    doCommit = false;
                    LOG.warn("Self-test query [" + selfTestQuery + "] failed; direct SQL is disabled", t);
                    tx.rollback();
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            if (doCommit) {
                tx.commit();
            }
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean isCompatibleDatastore() {
        return this.isCompatibleDatastore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNoResult(String queryText) throws SQLException {
        JDOConnection jdoConn = this.pm.getDataStoreConnection();
        Statement statement = null;
        boolean doTrace = LOG.isDebugEnabled();
        try {
            long start = doTrace ? System.nanoTime() : 0L;
            statement = ((Connection)jdoConn.getNativeConnection()).createStatement();
            statement.execute(queryText);
            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, doTrace ? System.nanoTime() : 0L);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            jdoConn.close();
        }
    }

    public Database getDatabase(String catName, String dbName) throws MetaException {
        String queryTextDbSelector = "select \"DB_ID\", \"NAME\", \"DB_LOCATION_URI\", \"DESC\", \"OWNER_NAME\", \"OWNER_TYPE\", \"CTLG_NAME\" , \"CREATE_TIME\", \"DB_MANAGED_LOCATION_URI\", \"TYPE\", \"DATACONNECTOR_NAME\", \"REMOTE_DBNAME\" FROM " + this.DBS + " where \"NAME\" = ? and \"CTLG_NAME\" = ? ";
        String queryTextDbParams = "select \"PARAM_KEY\", \"PARAM_VALUE\"  from " + this.DATABASE_PARAMS + "  WHERE \"DB_ID\" = ?  AND \"PARAM_KEY\" IS NOT NULL";
        try (QueryWrapper queryDbSelector = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryTextDbSelector));){
            List sqlResult;
            Object[] params;
            QueryWrapper queryDbParams;
            block24: {
                block23: {
                    queryDbParams = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryTextDbParams));
                    dbName = dbName.toLowerCase();
                    catName = catName.toLowerCase();
                    params = new Object[]{dbName, catName};
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("getDatabase:query instantiated : " + queryTextDbSelector + " with param [" + String.valueOf(params[0]) + "]");
                    }
                    if ((sqlResult = (List)this.executeWithArray(queryDbSelector.getInnerQuery(), params, queryTextDbSelector)) != null && !sqlResult.isEmpty()) break block23;
                    Database database = null;
                    queryDbParams.close();
                    return database;
                }
                assert (sqlResult.size() == 1);
                if (sqlResult.get(0) != null) break block24;
                Database database = null;
                queryDbParams.close();
                return database;
            }
            try {
                Object[] dbline = (Object[])sqlResult.get(0);
                Long dbid = MetastoreDirectSqlUtils.extractSqlLong(dbline[0]);
                params[0] = dbid;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("getDatabase:query2 instantiated : " + queryTextDbParams + " with param [" + String.valueOf(params[0]) + "]");
                }
                HashMap<String, String> dbParams = new HashMap<String, String>();
                List<Object[]> sqlResult2 = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(queryDbParams.getInnerQuery(), params, queryTextDbParams));
                if (!sqlResult2.isEmpty()) {
                    for (Object[] line : sqlResult2) {
                        dbParams.put(MetastoreDirectSqlUtils.extractSqlString(line[0]), MetastoreDirectSqlUtils.extractSqlString(line[1]));
                    }
                }
                Database db = new Database();
                db.setName(MetastoreDirectSqlUtils.extractSqlString(dbline[1]));
                db.setLocationUri(MetastoreDirectSqlUtils.extractSqlString(dbline[2]));
                db.setDescription(MetastoreDirectSqlUtils.extractSqlString(dbline[3]));
                db.setOwnerName(MetastoreDirectSqlUtils.extractSqlString(dbline[4]));
                String type = MetastoreDirectSqlUtils.extractSqlString(dbline[5]);
                db.setOwnerType(null == type || type.trim().isEmpty() ? null : PrincipalType.valueOf((String)type));
                db.setCatalogName(MetastoreDirectSqlUtils.extractSqlString(dbline[6]));
                if (dbline[7] != null) {
                    db.setCreateTime(MetastoreDirectSqlUtils.extractSqlInt(dbline[7]));
                }
                db.setManagedLocationUri(MetastoreDirectSqlUtils.extractSqlString(dbline[8]));
                String dbType = MetastoreDirectSqlUtils.extractSqlString(dbline[9]);
                if (dbType != null && dbType.equalsIgnoreCase(DatabaseType.REMOTE.name())) {
                    db.setType(DatabaseType.REMOTE);
                    db.setConnector_name(MetastoreDirectSqlUtils.extractSqlString(dbline[10]));
                    db.setRemote_dbname(MetastoreDirectSqlUtils.extractSqlString(dbline[11]));
                } else {
                    db.setType(DatabaseType.NATIVE);
                }
                db.setParameters(MetaStoreServerUtils.trimMapNulls(dbParams, this.convertMapNullsToEmptyStrings));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getDatabase: directsql returning db " + db.getName() + " locn[" + db.getLocationUri() + "] desc [" + db.getDescription() + "] owner [" + db.getOwnerName() + "] ownertype [" + String.valueOf(db.getOwnerType()) + "]");
                }
                Database database = db;
                queryDbParams.close();
                return database;
            }
            catch (Throwable throwable) {
                try {
                    queryDbParams.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public List<String> getTables(String catName, String dbName, TableType tableType, int limit) throws MetaException {
        String queryText = "SELECT " + this.TBLS + ".\"TBL_NAME\" FROM " + this.TBLS + "  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  WHERE " + this.DBS + ".\"NAME\" = ? AND " + this.DBS + ".\"CTLG_NAME\" = ? " + (String)(tableType == null ? "" : "AND " + this.TBLS + ".\"TBL_TYPE\" = ? ");
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(dbName);
        pms.add(catName);
        if (tableType != null) {
            pms.add(tableType.toString());
        }
        try (QueryWrapper queryParams = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            ArrayList<String> results;
            List tableNames = (List)this.executeWithArray(queryParams.getInnerQuery(), pms.toArray(), queryText, limit);
            ArrayList<String> arrayList = results = new ArrayList<String>(tableNames);
            return arrayList;
        }
    }

    public List<String> getMaterializedViewsForRewriting(String dbName) throws MetaException {
        String queryText = "SELECT " + this.TBLS + ".\"TBL_NAME\" FROM " + this.TBLS + "  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  WHERE " + this.DBS + ".\"NAME\" = ? AND " + this.TBLS + ".\"TBL_TYPE\" = ? ";
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(dbName);
        pms.add(TableType.MATERIALIZED_VIEW.toString());
        try (QueryWrapper queryParams = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            ArrayList<String> results;
            List mvs = (List)this.executeWithArray(queryParams.getInnerQuery(), pms.toArray(), queryText);
            ArrayList<String> arrayList = results = new ArrayList<String>(mvs);
            return arrayList;
        }
    }

    public void addPartitions(List<MPartition> parts, List<List<MPartitionPrivilege>> partPrivilegesList, List<List<MPartitionColumnPrivilege>> partColPrivilegesList) throws MetaException {
        this.directSqlInsertPart.addPartitions(parts, partPrivilegesList, partColPrivilegesList);
    }

    public List<Partition> alterPartitions(final MTable table, List<String> partNames, List<Partition> newParts, String queryWriteIdList) throws MetaException {
        List<Object[]> rows = Batchable.runBatched(this.batchSize, partNames, new Batchable<String, Object[]>(){

            @Override
            public List<Object[]> run(List<String> input) throws Exception {
                String filter = MetaStoreDirectSql.this.PARTITIONS + ".\"PART_NAME\" in (" + MetaStoreDirectSql.this.makeParams(input.size()) + ")";
                List<String> columns = Arrays.asList("\"PART_ID\"", "\"PART_NAME\"", "\"SD_ID\"", "\"WRITE_ID\"");
                return MetaStoreDirectSql.this.getPartitionFieldsViaSqlFilter(table.getDatabase().getCatalogName(), table.getDatabase().getName(), table.getTableName(), columns, filter, input, Collections.emptyList(), null);
            }
        });
        HashMap<List<String>, Long> partValuesToId = new HashMap<List<String>, Long>();
        HashMap<Long, Long> partIdToSdId = new HashMap<Long, Long>();
        HashMap<Long, Long> partIdToWriteId = new HashMap<Long, Long>();
        for (Object[] row : rows) {
            Long partId = MetastoreDirectSqlUtils.extractSqlLong(row[0]);
            Long sdId = MetastoreDirectSqlUtils.extractSqlLong(row[2]);
            Long writeId = MetastoreDirectSqlUtils.extractSqlLong(row[3]);
            partIdToSdId.put(partId, sdId);
            partIdToWriteId.put(partId, writeId);
            List partValues = Warehouse.getPartValuesFromPartName((String)((String)row[1]));
            partValuesToId.put(partValues, partId);
        }
        boolean isTxn = TxnUtils.isTransactionalTable(table.getParameters());
        for (Partition newPart : newParts) {
            Long partId = (Long)partValuesToId.get(newPart.getValues());
            boolean useOldWriteId = true;
            if (isTxn) {
                if (!this.isTxnStatsEnabled) {
                    StatsSetupConst.setBasicStatsState((Map)newPart.getParameters(), (String)"false");
                } else if (queryWriteIdList != null && newPart.getWriteId() > 0L) {
                    if (!ObjectStore.isCurrentStatsValidForTheQuery(newPart.getParameters(), (Long)partIdToWriteId.get(partId), queryWriteIdList, true)) {
                        StatsSetupConst.setBasicStatsState((Map)newPart.getParameters(), (String)"false");
                        LOG.info("Removed COLUMN_STATS_ACCURATE from the parameters of the partition " + Warehouse.getQualifiedName((Partition)newPart) + " will be made persistent.");
                    }
                    useOldWriteId = false;
                }
            }
            if (!useOldWriteId || (Long)partIdToWriteId.get(partId) == 0L) continue;
            newPart.setWriteId(((Long)partIdToWriteId.get(partId)).longValue());
        }
        this.directSqlUpdatePart.alterPartitions(partValuesToId, partIdToSdId, newParts);
        return newParts;
    }

    public List<String> getPartitionNamesViaSql(SqlFilterForPushdown filter, List<FieldSchema> partitionKeys, String defaultPartName, String order, Integer max) throws MetaException {
        boolean doTrace = LOG.isDebugEnabled();
        List orderSpecs = MetaStoreUtils.makeOrderSpecs((String)order);
        String catName = filter.catName.toLowerCase();
        String dbName = filter.dbName.toLowerCase();
        String tblName = filter.tableName.toLowerCase();
        String sqlFilter = filter.filter;
        List<Object> paramsForFilter = filter.params;
        List<String> joins = filter.joins;
        if (joins.isEmpty()) {
            for (int i = 0; i < partitionKeys.size(); ++i) {
                joins.add(null);
            }
        }
        StringBuilder orderColumns = new StringBuilder();
        StringBuilder orderClause = new StringBuilder();
        int i = 0;
        ArrayList<String> paramsForOrder = new ArrayList<String>();
        boolean dbHasJoinCastBug = this.dbType.hasJoinOperationOrderBug();
        for (Object[] orderSpec : orderSpecs) {
            Object tableValue;
            String tableAlias;
            int partColIndex = (Integer)orderSpec[0];
            String orderAlias = "ODR" + i++;
            if (joins.get(partColIndex) == null) {
                tableAlias = "ORDER" + partColIndex;
                joins.set(partColIndex, "inner join " + this.PARTITION_KEY_VALS + " \"" + tableAlias + "\" on \"" + tableAlias + "\".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" and \"" + tableAlias + "\".\"INTEGER_IDX\" = " + partColIndex);
                tableValue = " \"" + tableAlias + "\".\"PART_KEY_VAL\" ";
            } else {
                tableAlias = "FILTER" + partColIndex;
                tableValue = " \"" + tableAlias + "\".\"PART_KEY_VAL\" ";
            }
            String tableColumn = tableValue;
            String colType = partitionKeys.get(partColIndex).getType();
            PartitionFilterGenerator.FilterType type = PartitionFilterGenerator.FilterType.fromType(colType);
            if (type == PartitionFilterGenerator.FilterType.Date) {
                tableValue = this.dbType.toDate((String)tableValue);
            } else if (type == PartitionFilterGenerator.FilterType.Timestamp) {
                tableValue = this.dbType.toTimestamp((String)tableValue);
            } else if (type == PartitionFilterGenerator.FilterType.Integral) {
                tableValue = "CAST(" + tableColumn + " AS decimal(21,0))";
            }
            Object tableValue0 = tableValue;
            tableValue = " (case when " + tableColumn + " <> ?";
            paramsForOrder.add(defaultPartName);
            if (dbHasJoinCastBug) {
                tableValue = (String)tableValue + " and " + this.TBLS + ".\"TBL_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.DBS + ".\"CTLG_NAME\" = ? and \"" + tableAlias + "\".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" and \"" + tableAlias + "\".\"INTEGER_IDX\" = " + partColIndex;
                paramsForOrder.add(tblName);
                paramsForOrder.add(dbName);
                paramsForOrder.add(catName);
            }
            tableValue = (String)tableValue + " then " + (String)tableValue0 + " else null end) AS \"" + orderAlias + "\" ";
            orderColumns.append((String)tableValue).append(",");
            orderClause.append(" \"").append(orderAlias).append("\" ").append((String)orderSpec[1]).append(",");
        }
        for (int j = 0; j < joins.size(); ++j) {
            if (joins.get(j) != null) continue;
            joins.remove(j--);
        }
        if (orderClause.length() > 0) {
            orderClause.setLength(orderClause.length() - 1);
            orderColumns.setLength(orderColumns.length() - 1);
        }
        String orderCls = " order by " + (orderClause.length() > 0 ? orderClause.toString() : "\"PART_NAME\" asc");
        String columns = orderColumns.length() > 0 ? ", " + orderColumns.toString() : "";
        String queryText = "select " + this.PARTITIONS + ".\"PART_NAME\"" + columns + " from " + this.PARTITIONS + "   inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\"   and " + this.TBLS + ".\"TBL_NAME\" = ?   inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"   and " + this.DBS + ".\"NAME\" = ? " + StringUtils.join(joins, (char)' ') + " where " + this.DBS + ".\"CTLG_NAME\" = ? " + (String)(StringUtils.isBlank((CharSequence)sqlFilter) ? "" : " and " + sqlFilter) + orderCls;
        Object[] params = new Object[paramsForFilter.size() + paramsForOrder.size() + 3];
        for (i = 0; i < paramsForOrder.size(); ++i) {
            params[i] = paramsForOrder.get(i);
        }
        params[i] = tblName;
        params[i + 1] = dbName;
        params[i + 2] = catName;
        for (int j = 0; j < paramsForFilter.size(); ++j) {
            params[i + j + 3] = paramsForFilter.get(j);
        }
        LinkedList<String> partNames = new LinkedList<String>();
        int limit = max == null ? -1 : max;
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            long start = doTrace ? System.nanoTime() : 0L;
            List sqlResult = (List)this.executeWithArray(query.getInnerQuery(), params, queryText, limit);
            long queryTime = doTrace ? System.nanoTime() : 0L;
            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, queryTime);
            for (Object result : sqlResult) {
                Object obj = !columns.isEmpty() ? ((Object[])result)[0] : result;
                partNames.add((String)obj);
            }
        }
        return partNames;
    }

    public List<Partition> getPartitionsViaPartNames(final String catName, final String dbName, final String tblName, final GetPartitionsArgs args) throws MetaException {
        final List<String> partNames = args.getPartNames();
        if (partNames.isEmpty()) {
            return Collections.emptyList();
        }
        return Batchable.runBatched(this.batchSize, partNames, new Batchable<String, Partition>(){

            @Override
            public List<Partition> run(List<String> input) throws MetaException {
                return MetaStoreDirectSql.this.getPartitionsByNames(catName, dbName, tblName, partNames, false, args);
            }
        });
    }

    public List<Partition> getPartitionsViaSqlFilter(String catName, String dbName, String tableName, SqlFilterForPushdown filter, boolean isAcidTable, GetPartitionsArgs args) throws MetaException {
        List<Long> partitionIds = this.getPartitionIdsViaSqlFilter(catName, dbName, tableName, filter.filter, filter.params, filter.joins, args.getMax());
        return this.getPartitionsByPartitionIdsInBatch(catName, dbName, tableName, partitionIds, isAcidTable, args);
    }

    public List<Partition> getPartitionsViaSqlPs(Table table, final GetPartitionsArgs args) throws MetaException {
        final String catName = table.getCatName();
        final String dbName = table.getDbName();
        final String tblName = table.getTableName();
        String sqlFilter = this.PARTITIONS + ".\"PART_NAME\" like ? ";
        String partialName = MetaStoreUtils.makePartNameMatcher((Table)table, args.getPart_vals(), (String)"_%");
        List partitionIds = this.getPartitionFieldsViaSqlFilter(catName, dbName, tblName, Arrays.asList("\"PART_ID\""), sqlFilter, Arrays.asList(partialName), Collections.emptyList(), args.getMax());
        if (partitionIds.isEmpty()) {
            return Collections.emptyList();
        }
        final boolean isAcidTable = TxnUtils.isAcidTable(table);
        return Batchable.runBatched(this.batchSize, partitionIds, new Batchable<Long, Partition>(){

            @Override
            public List<Partition> run(List<Long> input) throws MetaException {
                return MetaStoreDirectSql.this.getPartitionsByPartitionIds(catName, dbName, tblName, input, isAcidTable, args);
            }
        });
    }

    public List<Partition> getPartitionsUsingProjectionAndFilterSpec(Table tbl, List<String> partitionFields, String includeParamKeyPattern, String excludeParamKeyPattern, GetPartitionsFilterSpec filterSpec, SqlFilterForPushdown filter) throws MetaException {
        String tblName = tbl.getTableName();
        String dbName = tbl.getDbName();
        String catName = tbl.getCatName();
        List<Long> partitionIds = null;
        if (filterSpec.isSetFilterMode()) {
            List filters = filterSpec.getFilters();
            if (filters == null || filters.isEmpty()) {
                throw new MetaException("Invalid filter expressions in the filter spec");
            }
            switch (filterSpec.getFilterMode()) {
                case BY_EXPR: {
                    partitionIds = this.getPartitionIdsViaSqlFilter(catName, dbName, tblName, filter.filter, filter.params, filter.joins, null);
                    break;
                }
                case BY_NAMES: {
                    String partNamesFilter = this.PARTITIONS + ".\"PART_NAME\" in (" + this.makeParams(filterSpec.getFilters().size()) + ")";
                    partitionIds = this.getPartitionIdsViaSqlFilter(catName, dbName, tblName, partNamesFilter, filterSpec.getFilters(), Collections.EMPTY_LIST, null);
                    break;
                }
                case BY_VALUES: {
                    String partNameMatcher = MetaStoreUtils.makePartNameMatcher((Table)tbl, (List)filters, (String)"_%");
                    String partNamesLikeFilter = this.PARTITIONS + ".\"PART_NAME\" LIKE (?)";
                    partitionIds = this.getPartitionIdsViaSqlFilter(catName, dbName, tblName, partNamesLikeFilter, Arrays.asList(partNameMatcher), Collections.EMPTY_LIST, null);
                    break;
                }
                default: {
                    throw new MetaException("Unsupported filter mode " + String.valueOf(filterSpec.getFilterMode()));
                }
            }
        } else {
            partitionIds = this.getPartitionIdsViaSqlFilter(catName, dbName, tblName, null, Collections.EMPTY_LIST, Collections.EMPTY_LIST, null);
        }
        if (partitionIds.isEmpty()) {
            return Collections.emptyList();
        }
        Boolean isView = MetaStoreDirectSql.isViewTable(tbl);
        if (isView == null) {
            isView = this.isViewTable(catName, dbName, tblName);
        }
        final PartitionProjectionEvaluator projectionEvaluator = new PartitionProjectionEvaluator(this.pm, this.fieldnameToTableName, partitionFields, this.convertMapNullsToEmptyStrings, isView, includeParamKeyPattern, excludeParamKeyPattern);
        return Batchable.runBatched(this.batchSize, partitionIds, new Batchable<Long, Partition>(this){

            @Override
            public List<Partition> run(List<Long> input) throws MetaException {
                return projectionEvaluator.getPartitionsUsingProjectionList(input);
            }
        });
    }

    public boolean generateSqlFilterForPushdown(String catName, String dbName, String tableName, List<FieldSchema> partitionKeys, ExpressionTree tree, String defaultPartitionName, SqlFilterForPushdown result) throws MetaException {
        assert (partitionKeys != null);
        boolean dbHasJoinCastBug = this.dbType.hasJoinOperationOrderBug();
        result.tableName = tableName;
        result.dbName = dbName;
        result.catName = catName;
        result.filter = PartitionFilterGenerator.generateSqlFilter(catName, dbName, tableName, partitionKeys, tree, result.params, result.joins, dbHasJoinCastBug, defaultPartitionName == null ? this.defaultPartName : defaultPartitionName, this.dbType, this.schema, result.compactJoins);
        return result.filter != null;
    }

    public List<Partition> getPartitions(String catName, String dbName, String tblName, GetPartitionsArgs args) throws MetaException {
        List<Long> partitionIds = this.getPartitionIdsViaSqlFilter(catName, dbName, tblName, null, Collections.emptyList(), Collections.emptyList(), args.getMax());
        return this.getPartitionsByPartitionIdsInBatch(catName, dbName, tblName, partitionIds, false, args);
    }

    private static Boolean isViewTable(Table t) {
        return t.isSetTableType() ? Boolean.valueOf(t.getTableType().equals(TableType.VIRTUAL_VIEW.toString())) : null;
    }

    private boolean isViewTable(String catName, String dbName, String tblName) throws MetaException {
        String queryText = "select \"TBL_TYPE\" from " + this.TBLS + " inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  where " + this.TBLS + ".\"TBL_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.DBS + ".\"CTLG_NAME\" = ?";
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            Object[] params = new Object[]{tblName, dbName, catName};
            query.setUnique(true);
            Object result = this.executeWithArray(query.getInnerQuery(), params, queryText);
            boolean bl = result != null && result.toString().equals(TableType.VIRTUAL_VIEW.toString());
            return bl;
        }
    }

    private List<Long> getPartitionIdsViaSqlFilter(String catName, String dbName, String tblName, String sqlFilter, List<? extends Object> paramsForFilter, List<String> joinsForFilter, Integer max) throws MetaException {
        return this.getPartitionFieldsViaSqlFilter(catName, dbName, tblName, Arrays.asList("\"PART_ID\""), sqlFilter, paramsForFilter, joinsForFilter, max);
    }

    public <T> List<T> getPartitionFieldsViaSqlFilter(String catName, String dbName, String tblName, List<String> partColumns, String sqlFilter, List<? extends Object> paramsForFilter, List<String> joinsForFilter, Integer max) throws MetaException {
        boolean doTrace = LOG.isDebugEnabled();
        String dbNameLcase = dbName.toLowerCase();
        String tblNameLcase = tblName.toLowerCase();
        String catNameLcase = StringUtils.normalizeSpace((String)catName).toLowerCase();
        String orderForFilter = max != null ? " order by " + MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_ORDER_EXPR) : "";
        String columns = partColumns.stream().map(col -> this.PARTITIONS + "." + col).collect(Collectors.joining(","));
        String queryText = "select " + columns + " from " + this.PARTITIONS + "  inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\"     and " + this.TBLS + ".\"TBL_NAME\" = ?   inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"      and " + this.DBS + ".\"NAME\" = ? " + StringUtils.join(joinsForFilter, (char)' ') + " where " + this.DBS + ".\"CTLG_NAME\" = ? " + (String)(StringUtils.isBlank((CharSequence)sqlFilter) ? "" : " and " + sqlFilter) + orderForFilter;
        Object[] params = new Object[paramsForFilter.size() + 3];
        params[0] = tblNameLcase;
        params[1] = dbNameLcase;
        params[2] = catNameLcase;
        for (int i = 0; i < paramsForFilter.size(); ++i) {
            params[i + 3] = paramsForFilter.get(i);
        }
        long start = doTrace ? System.nanoTime() : 0L;
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            ArrayList result;
            List sqlResult = (List)this.executeWithArray(query.getInnerQuery(), params, queryText, max == null ? -1 : max);
            long queryTime = doTrace ? System.nanoTime() : 0L;
            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, queryTime);
            ArrayList arrayList = result = new ArrayList(sqlResult);
            return arrayList;
        }
    }

    private List<Partition> getPartitionsByNames(String catName, String dbName, String tblName, List<String> partNameList, boolean isAcidTable, GetPartitionsArgs args) throws MetaException {
        String quotedPartNames = partNameList.stream().map(DirectSqlUpdatePart::quoteString).collect(Collectors.joining(","));
        String queryText = "select " + this.PARTITIONS + ".\"PART_ID\"," + this.SDS + ".\"SD_ID\"," + this.SDS + ".\"CD_ID\"," + this.SERDES + ".\"SERDE_ID\"," + this.PARTITIONS + ".\"CREATE_TIME\"," + this.PARTITIONS + ".\"LAST_ACCESS_TIME\"," + this.SDS + ".\"INPUT_FORMAT\"," + this.SDS + ".\"IS_COMPRESSED\"," + this.SDS + ".\"IS_STOREDASSUBDIRECTORIES\"," + this.SDS + ".\"LOCATION\"," + this.SDS + ".\"NUM_BUCKETS\"," + this.SDS + ".\"OUTPUT_FORMAT\"," + this.SERDES + ".\"NAME\"," + this.SERDES + ".\"SLIB\"," + this.PARTITIONS + ".\"WRITE_ID\" from " + this.PARTITIONS + " left outer join " + this.SDS + " on " + this.PARTITIONS + ".\"SD_ID\" = " + this.SDS + ".\"SD_ID\"  left outer join " + this.SERDES + " on " + this.SDS + ".\"SERDE_ID\" = " + this.SERDES + ".\"SERDE_ID\"  inner join " + this.TBLS + " on " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITIONS + ".\"TBL_ID\"  inner join " + this.DBS + " on " + this.DBS + ".\"DB_ID\" = " + this.TBLS + ".\"DB_ID\"  where \"PART_NAME\" in (" + quotedPartNames + ")  and " + this.TBLS + ".\"TBL_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.DBS + ".\"CTLG_NAME\" = ? order by \"PART_NAME\" asc";
        Object[] params = new Object[]{tblName, dbName, catName};
        return this.getPartitionsByQuery(catName, dbName, tblName, queryText, params, isAcidTable, args);
    }

    private List<Partition> getPartitionsByPartitionIdsInBatch(final String catName, final String dbName, final String tblName, List<Long> partIdList, final boolean isAcidTable, final GetPartitionsArgs args) throws MetaException {
        if (partIdList.isEmpty()) {
            return Collections.emptyList();
        }
        return Batchable.runBatched(this.batchSize, partIdList, new Batchable<Long, Partition>(){

            @Override
            public List<Partition> run(List<Long> input) throws MetaException {
                return MetaStoreDirectSql.this.getPartitionsByPartitionIds(catName, dbName, tblName, input, isAcidTable, args);
            }
        });
    }

    private List<Partition> getPartitionsByPartitionIds(String catName, String dbName, String tblName, List<Long> partIdList, boolean isAcidTable, GetPartitionsArgs args) throws MetaException {
        String partIds = MetaStoreDirectSql.getIdListForIn(partIdList);
        String queryText = "select " + this.PARTITIONS + ".\"PART_ID\", " + this.SDS + ".\"SD_ID\", " + this.SDS + ".\"CD_ID\", " + this.SERDES + ".\"SERDE_ID\", " + this.PARTITIONS + ".\"CREATE_TIME\", " + this.PARTITIONS + ".\"LAST_ACCESS_TIME\", " + this.SDS + ".\"INPUT_FORMAT\", " + this.SDS + ".\"IS_COMPRESSED\", " + this.SDS + ".\"IS_STOREDASSUBDIRECTORIES\", " + this.SDS + ".\"LOCATION\", " + this.SDS + ".\"NUM_BUCKETS\", " + this.SDS + ".\"OUTPUT_FORMAT\", " + this.SERDES + ".\"NAME\", " + this.SERDES + ".\"SLIB\", " + this.PARTITIONS + ".\"WRITE_ID\" from " + this.PARTITIONS + "  left outer join " + this.SDS + " on " + this.PARTITIONS + ".\"SD_ID\" = " + this.SDS + ".\"SD_ID\"   left outer join " + this.SERDES + " on " + this.SDS + ".\"SERDE_ID\" = " + this.SERDES + ".\"SERDE_ID\" where \"PART_ID\" in (" + partIds + ") order by \"PART_NAME\" asc";
        return this.getPartitionsByQuery(catName, dbName, tblName, queryText, null, isAcidTable, args);
    }

    private List<Partition> getPartitionsByQuery(String catName, String dbName, String tblName, String queryText, Object[] params, boolean isAcidTable, GetPartitionsArgs args) throws MetaException {
        ArrayList<Partition> orderedResult;
        boolean doTrace = LOG.isDebugEnabled();
        TreeMap<Long, Partition> partitions = new TreeMap<Long, Partition>();
        TreeMap<Long, StorageDescriptor> sds = new TreeMap<Long, StorageDescriptor>();
        TreeMap<Long, SerDeInfo> serdes = new TreeMap<Long, SerDeInfo>();
        TreeMap<Long, List<FieldSchema>> colss = new TreeMap<Long, List<FieldSchema>>();
        StringBuilder sdSb = new StringBuilder();
        StringBuilder serdeSb = new StringBuilder();
        StringBuilder colsSb = new StringBuilder(7);
        tblName = tblName.toLowerCase();
        dbName = dbName.toLowerCase();
        catName = StringUtils.normalizeSpace((String)catName).toLowerCase();
        partitions.navigableKeySet();
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            long start = doTrace ? System.nanoTime() : 0L;
            List sqlResult = (List)this.executeWithArray(query.getInnerQuery(), params, queryText);
            long queryTime = doTrace ? System.nanoTime() : 0L;
            Deadline.checkTimeout();
            orderedResult = new ArrayList<Partition>(sqlResult.size());
            for (Object[] fields : sqlResult) {
                SerDeInfo serde;
                SerDeInfo oldSerde;
                Long writeId;
                long partitionId = MetastoreDirectSqlUtils.extractSqlLong(fields[0]);
                Long sdId = MetastoreDirectSqlUtils.extractSqlLong(fields[1]);
                Long colId = MetastoreDirectSqlUtils.extractSqlLong(fields[2]);
                Long serdeId = MetastoreDirectSqlUtils.extractSqlLong(fields[3]);
                Partition part = new Partition();
                orderedResult.add(part);
                part.setParameters(new HashMap());
                part.setValues(new ArrayList());
                part.setCatName(catName);
                part.setDbName(dbName);
                part.setTableName(tblName);
                if (fields[4] != null) {
                    part.setCreateTime(MetastoreDirectSqlUtils.extractSqlInt(fields[4]));
                }
                if (fields[5] != null) {
                    part.setLastAccessTime(MetastoreDirectSqlUtils.extractSqlInt(fields[5]));
                }
                if ((writeId = MetastoreDirectSqlUtils.extractSqlLong(fields[14])) != null && writeId > 0L) {
                    part.setWriteId(writeId.longValue());
                } else {
                    part.setWriteId(-1L);
                }
                partitions.put(partitionId, part);
                if (sdId == null) continue;
                assert (serdeId != null);
                StorageDescriptor sd = new StorageDescriptor();
                StorageDescriptor oldSd = sds.put(sdId, sd);
                if (oldSd != null) {
                    throw new MetaException("Partitions reuse SDs; we don't expect that");
                }
                sd.setSortCols(new ArrayList());
                sd.setBucketCols(new ArrayList());
                sd.setParameters(new HashMap());
                sd.setSkewedInfo(new SkewedInfo(new ArrayList(), new ArrayList(), new HashMap()));
                sd.setInputFormat((String)fields[6]);
                Boolean tmpBoolean = MetastoreDirectSqlUtils.extractSqlBoolean(fields[7]);
                if (tmpBoolean != null) {
                    sd.setCompressed(tmpBoolean.booleanValue());
                }
                if ((tmpBoolean = MetastoreDirectSqlUtils.extractSqlBoolean(fields[8])) != null) {
                    sd.setStoredAsSubDirectories(tmpBoolean.booleanValue());
                }
                sd.setLocation((String)fields[9]);
                if (fields[10] != null) {
                    sd.setNumBuckets(MetastoreDirectSqlUtils.extractSqlInt(fields[10]));
                }
                sd.setOutputFormat((String)fields[11]);
                sdSb.append(sdId).append(",");
                part.setSd(sd);
                if (colId != null) {
                    List<FieldSchema> cols = colss.get(colId);
                    if (cols == null) {
                        cols = new ArrayList<FieldSchema>();
                        colss.put(colId, cols);
                        colsSb.append(colId).append(",");
                    }
                    sd.setCols(cols);
                }
                if ((oldSerde = serdes.put(serdeId, serde = new SerDeInfo())) != null) {
                    throw new MetaException("SDs reuse serdes; we don't expect that");
                }
                serde.setParameters(new HashMap());
                serde.setName((String)fields[12]);
                serde.setSerializationLib((String)fields[13]);
                serdeSb.append(serdeId).append(",");
                sd.setSerdeInfo(serde);
                Deadline.checkTimeout();
            }
            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, queryTime);
        }
        String partIds = MetaStoreDirectSql.getIdListForIn(partitions.keySet());
        if (partIds.isEmpty()) {
            return orderedResult;
        }
        MetastoreDirectSqlUtils.setPartitionParametersWithFilter(this.PARTITION_PARAMS, this.convertMapNullsToEmptyStrings, this.pm, partIds, partitions, args.getIncludeParamKeyPattern(), args.getExcludeParamKeyPattern());
        MetastoreDirectSqlUtils.setPartitionValues(this.PARTITION_KEY_VALS, this.pm, partIds, partitions);
        if (sdSb.length() == 0) {
            assert (serdeSb.length() == 0 && colsSb.length() == 0);
            return orderedResult;
        }
        String sdIds = MetaStoreDirectSql.trimCommaList(sdSb);
        String serdeIds = MetaStoreDirectSql.trimCommaList(serdeSb);
        String colIds = MetaStoreDirectSql.trimCommaList(colsSb);
        if (!isAcidTable) {
            MetastoreDirectSqlUtils.setSDParameters(this.SD_PARAMS, this.convertMapNullsToEmptyStrings, this.pm, sds, sdIds);
        }
        boolean hasSkewedColumns = false;
        if (!isAcidTable) {
            MetastoreDirectSqlUtils.setSDSortCols(this.SORT_COLS, this.pm, sds, sdIds);
        }
        MetastoreDirectSqlUtils.setSDBucketCols(this.BUCKETING_COLS, this.pm, sds, sdIds);
        if (!isAcidTable) {
            hasSkewedColumns = MetastoreDirectSqlUtils.setSkewedColNames(this.SKEWED_COL_NAMES, this.pm, sds, sdIds);
        }
        if (hasSkewedColumns) {
            MetastoreDirectSqlUtils.setSkewedColValues(this.SKEWED_STRING_LIST_VALUES, this.SKEWED_VALUES, this.pm, sds, sdIds);
            MetastoreDirectSqlUtils.setSkewedColLocationMaps(this.SKEWED_COL_VALUE_LOC_MAP, this.SKEWED_STRING_LIST_VALUES, this.pm, sds, sdIds);
        }
        if (!colss.isEmpty() && !args.isSkipColumnSchemaForPartition()) {
            MetastoreDirectSqlUtils.setSDCols(this.COLUMNS_V2, this.pm, colss, colIds);
        }
        if (!isAcidTable) {
            MetastoreDirectSqlUtils.setSerdeParams(this.SERDE_PARAMS, this.convertMapNullsToEmptyStrings, this.pm, serdes, serdeIds);
        }
        return orderedResult;
    }

    public int getNumPartitionsViaSqlFilter(SqlFilterForPushdown filter) throws MetaException {
        String catName = filter.catName.toLowerCase();
        String dbName = filter.dbName.toLowerCase();
        String tblName = filter.tableName.toLowerCase();
        String queryText = "select count(" + this.PARTITIONS + ".\"PART_ID\") from " + this.PARTITIONS + "  inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\"     and " + this.TBLS + ".\"TBL_NAME\" = ?   inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"      and " + this.DBS + ".\"NAME\" = ? " + StringUtils.join(filter.joins, (char)' ') + " where " + this.DBS + ".\"CTLG_NAME\" = ? " + (String)(filter.filter == null || filter.filter.trim().isEmpty() ? "" : " and " + filter.filter);
        Object[] params = new Object[filter.params.size() + 3];
        params[0] = tblName;
        params[1] = dbName;
        params[2] = catName;
        for (int i = 0; i < filter.params.size(); ++i) {
            params[i + 3] = filter.params.get(i);
        }
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            query.setUnique(true);
            int n = MetastoreDirectSqlUtils.extractSqlInt(this.executeWithArray(query.getInnerQuery(), params, queryText));
            return n;
        }
    }

    public int getNumPartitionsViaSqlPs(Table table, List<String> partVals) throws MetaException {
        String partialName = MetaStoreUtils.makePartNameMatcher((Table)table, partVals, (String)"_%");
        String queryText = "select count(" + this.PARTITIONS + ".\"PART_ID\") from " + this.PARTITIONS + "  inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\"     and " + this.TBLS + ".\"TBL_NAME\" = ?   inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"      and " + this.DBS + ".\"NAME\" = ?  where " + this.DBS + ".\"CTLG_NAME\" = ? and " + this.PARTITIONS + ".\"PART_NAME\" like ? ";
        Object[] params = new Object[]{table.getTableName(), table.getDbName(), table.getCatName(), partialName};
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            query.setUnique(true);
            int n = MetastoreDirectSqlUtils.extractSqlInt(this.executeWithArray(query.getInnerQuery(), params, queryText));
            return n;
        }
    }

    private static String trimCommaList(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnStatistics getTableStats(final String catName, final String dbName, final String tableName, List<String> colNames, final String engine, boolean enableBitVector, boolean enableKll) throws MetaException {
        List<Object[]> list;
        if (colNames == null || colNames.isEmpty()) {
            return null;
        }
        final boolean doTrace = LOG.isDebugEnabled();
        final String queryText0 = "select " + this.getStatsList(enableBitVector, enableKll) + " from " + this.TAB_COL_STATS + " inner join " + this.TBLS + " on " + this.TAB_COL_STATS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\"  inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  where " + this.DBS + ".\"CTLG_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.TBLS + ".\"TBL_NAME\" = ? and \"ENGINE\" = ? and \"COLUMN_NAME\" in (";
        Batchable<String, Object[]> b = new Batchable<String, Object[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Object[]> run(List<String> input) throws MetaException {
                String queryText = queryText0 + MetaStoreDirectSql.this.makeParams(input.size()) + ")";
                Object[] params = new Object[input.size() + 4];
                params[0] = catName;
                params[1] = dbName;
                params[2] = tableName;
                params[3] = engine;
                for (int i = 0; i < input.size(); ++i) {
                    params[i + 4] = input.get(i);
                }
                long start = doTrace ? System.nanoTime() : 0L;
                Query query = MetaStoreDirectSql.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
                try {
                    Object qResult = MetaStoreDirectSql.this.executeWithArray(query, params, queryText);
                    MetastoreDirectSqlUtils.timingTrace(doTrace, queryText0 + "...)", start, doTrace ? System.nanoTime() : 0L);
                    if (qResult == null) {
                        List<Object[]> list = null;
                        return list;
                    }
                    List<Object[]> list = MetastoreDirectSqlUtils.ensureList(qResult);
                    return list;
                }
                finally {
                    this.addQueryAfterUse(query);
                }
            }
        };
        try {
            list = Batchable.runBatched(this.batchSize, colNames, b);
            if (list != null) {
                list = new ArrayList<Object[]>(list);
            }
        }
        finally {
            b.closeAllQueries();
        }
        if (list == null || list.isEmpty()) {
            return null;
        }
        ColumnStatisticsDesc csd = new ColumnStatisticsDesc(true, dbName, tableName);
        csd.setCatName(catName);
        return this.makeColumnStats(list, csd, 0, engine);
    }

    public List<HiveObjectPrivilege> getTableAllColumnGrants(String catName, String dbName, String tableName, String authorizer) throws MetaException {
        boolean authorizerIndex = false;
        boolean columnNameIndex = true;
        int createTimeIndex = 2;
        int grantOptionIndex = 3;
        int grantorIndex = 4;
        int grantorTypeIndex = 5;
        int principalNameIndex = 6;
        int principalTypeIndex = 7;
        int privilegeIndex = 8;
        String queryText = "select " + this.TBL_COL_PRIVS + ".\"AUTHORIZER\", " + this.TBL_COL_PRIVS + ".\"COLUMN_NAME\", " + this.TBL_COL_PRIVS + ".\"CREATE_TIME\", " + this.TBL_COL_PRIVS + ".\"GRANT_OPTION\", " + this.TBL_COL_PRIVS + ".\"GRANTOR\", " + this.TBL_COL_PRIVS + ".\"GRANTOR_TYPE\", " + this.TBL_COL_PRIVS + ".\"PRINCIPAL_NAME\", " + this.TBL_COL_PRIVS + ".\"PRINCIPAL_TYPE\", " + this.TBL_COL_PRIVS + ".\"TBL_COL_PRIV\" FROM " + this.TBL_COL_PRIVS + " JOIN " + this.TBLS + " ON " + this.TBL_COL_PRIVS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\" JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  WHERE " + this.TBLS + ".\"TBL_NAME\" = ? AND " + this.DBS + ".\"NAME\" = ? AND " + this.DBS + ".\"CTLG_NAME\" = ?";
        int numParams = authorizer != null ? 4 : 3;
        Object[] params = new Object[numParams];
        params[0] = tableName;
        params[1] = dbName;
        params[2] = catName;
        if (authorizer != null) {
            queryText = queryText + " AND " + this.TBL_COL_PRIVS + ".\"AUTHORIZER\" = ?";
            params[3] = authorizer;
        }
        ArrayList<HiveObjectPrivilege> result = new ArrayList<HiveObjectPrivilege>();
        boolean doTrace = LOG.isDebugEnabled();
        long start = doTrace ? System.nanoTime() : 0L;
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            List<Object[]> queryResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(query.getInnerQuery(), params, queryText));
            long end = doTrace ? System.nanoTime() : 0L;
            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
            for (Object[] privLine : queryResult) {
                String privAuthorizer = MetastoreDirectSqlUtils.extractSqlString(privLine[0]);
                String principalName = MetastoreDirectSqlUtils.extractSqlString(privLine[6]);
                PrincipalType ptype = PrincipalType.valueOf((String)MetastoreDirectSqlUtils.extractSqlString(privLine[7]));
                String columnName = MetastoreDirectSqlUtils.extractSqlString(privLine[1]);
                String privilege = MetastoreDirectSqlUtils.extractSqlString(privLine[8]);
                int createTime = MetastoreDirectSqlUtils.extractSqlInt(privLine[2]);
                String grantor = MetastoreDirectSqlUtils.extractSqlString(privLine[4]);
                PrincipalType grantorType = PrincipalType.valueOf((String)MetastoreDirectSqlUtils.extractSqlString(privLine[5]));
                boolean grantOption = MetastoreDirectSqlUtils.extractSqlBoolean(privLine[3]);
                HiveObjectRef objectRef = new HiveObjectRef(HiveObjectType.COLUMN, dbName, tableName, null, columnName);
                objectRef.setCatName(catName);
                PrivilegeGrantInfo grantInfo = new PrivilegeGrantInfo(privilege, createTime, grantor, grantorType, grantOption);
                result.add(new HiveObjectPrivilege(objectRef, principalName, ptype, grantInfo, privAuthorizer));
            }
        }
        return result;
    }

    public AggrStats aggrColStatsForPartitions(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, String engine, boolean useDensityFunctionForNDVEstimation, double ndvTuner, boolean enableBitVector, boolean enableKll) throws MetaException {
        List<Object> colStatsList;
        if (colNames.isEmpty() || partNames.isEmpty()) {
            LOG.debug("Columns is empty or partNames is empty : Short-circuiting stats eval");
            return new AggrStats(Collections.emptyList(), 0L);
        }
        long partsFound = 0L;
        if (this.isAggregateStatsCacheEnabled && partNames.size() < this.aggrStatsCache.getMaxPartsPerCacheNode()) {
            int maxPartsPerCacheNode = this.aggrStatsCache.getMaxPartsPerCacheNode();
            double fpp = this.aggrStatsCache.getFalsePositiveProbability();
            colStatsList = new ArrayList();
            BloomFilter bloomFilter = this.createPartsBloomFilter(maxPartsPerCacheNode, fpp, partNames);
            boolean computePartsFound = true;
            for (String colName : colNames) {
                AggregateStatsCache.AggrColStats colStatsAggrCached = this.aggrStatsCache.get(catName, dbName, tableName, colName, partNames);
                if (colStatsAggrCached != null) {
                    colStatsList.add(colStatsAggrCached.getColStats());
                    partsFound = colStatsAggrCached.getNumPartsCached();
                    continue;
                }
                if (computePartsFound) {
                    partsFound = this.partsFoundForPartitions(catName, dbName, tableName, partNames, colNames, engine);
                    computePartsFound = false;
                }
                ArrayList<String> colNamesForDB = new ArrayList<String>();
                colNamesForDB.add(colName);
                List<ColumnStatisticsObj> colStatsAggrFromDB = this.columnStatisticsObjForPartitions(catName, dbName, tableName, partNames, colNamesForDB, engine, partsFound, useDensityFunctionForNDVEstimation, ndvTuner, enableBitVector, enableKll);
                if (colStatsAggrFromDB.isEmpty()) continue;
                ColumnStatisticsObj colStatsAggr = colStatsAggrFromDB.get(0);
                colStatsList.add(colStatsAggr);
                this.aggrStatsCache.add(catName, dbName, tableName, colName, partsFound, colStatsAggr, bloomFilter);
            }
        } else {
            partsFound = this.partsFoundForPartitions(catName, dbName, tableName, partNames, colNames, engine);
            colStatsList = this.columnStatisticsObjForPartitions(catName, dbName, tableName, partNames, colNames, engine, partsFound, useDensityFunctionForNDVEstimation, ndvTuner, enableBitVector, enableKll);
        }
        LOG.debug("useDensityFunctionForNDVEstimation = " + useDensityFunctionForNDVEstimation + "\npartsFound = " + partsFound + "\nColumnStatisticsObj = " + Arrays.toString(colStatsList.toArray()));
        return new AggrStats(colStatsList, partsFound);
    }

    private BloomFilter createPartsBloomFilter(int maxPartsPerCacheNode, double fpp, List<String> partNames) {
        BloomFilter bloomFilter = BloomFilter.build((long)maxPartsPerCacheNode, (double)fpp);
        for (String partName : partNames) {
            bloomFilter.add(partName.getBytes());
        }
        return bloomFilter;
    }

    private long partsFoundForPartitions(final String catName, final String dbName, final String tableName, final List<String> partNames, List<String> colNames, final String engine) throws MetaException {
        assert (!colNames.isEmpty() && !partNames.isEmpty());
        final boolean doTrace = LOG.isDebugEnabled();
        final String queryText0 = "select count(\"COLUMN_NAME\") from " + this.PART_COL_STATS + " inner join " + this.PARTITIONS + " on " + this.PART_COL_STATS + ".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\" inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" where " + this.DBS + ".\"CTLG_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.TBLS + ".\"TBL_NAME\" = ? and " + this.PART_COL_STATS + ".\"COLUMN_NAME\" in (%1$s) and " + this.PARTITIONS + ".\"PART_NAME\" in (%2$s) and " + this.PART_COL_STATS + ".\"ENGINE\" = ? group by " + this.PART_COL_STATS + ".\"PART_ID\"";
        List<Long> allCounts = Batchable.runBatched(this.batchSize, colNames, new Batchable<String, Long>(){

            @Override
            public List<Long> run(final List<String> inputColName) throws MetaException {
                return Batchable.runBatched(MetaStoreDirectSql.this.batchSize, partNames, new Batchable<String, Long>(){

                    @Override
                    public List<Long> run(List<String> inputPartNames) throws MetaException {
                        long partsFound = 0L;
                        String queryText = String.format(queryText0, MetaStoreDirectSql.this.makeParams(inputColName.size()), MetaStoreDirectSql.this.makeParams(inputPartNames.size()));
                        long start = doTrace ? System.nanoTime() : 0L;
                        try (QueryWrapper query = new QueryWrapper(MetaStoreDirectSql.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
                            Object qResult = MetaStoreDirectSql.this.executeWithArray(query.getInnerQuery(), MetaStoreDirectSql.this.prepareParams(catName, dbName, tableName, inputPartNames, inputColName, engine), queryText);
                            long end = doTrace ? System.nanoTime() : 0L;
                            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
                            ForwardQueryResult fqr = (ForwardQueryResult)qResult;
                            Iterator iter = fqr.iterator();
                            while (iter.hasNext()) {
                                if (MetastoreDirectSqlUtils.extractSqlLong(iter.next()) != (long)inputColName.size()) continue;
                                ++partsFound;
                            }
                            ArrayList arrayList = Lists.newArrayList((Object[])new Long[]{partsFound});
                            return arrayList;
                        }
                    }
                });
            }
        });
        long partsFound = 0L;
        for (Long val : allCounts) {
            partsFound += val.longValue();
        }
        return partsFound;
    }

    private List<ColumnStatisticsObj> columnStatisticsObjForPartitions(final String catName, final String dbName, final String tableName, final List<String> partNames, List<String> colNames, final String engine, long partsFound, final boolean useDensityFunctionForNDVEstimation, final double ndvTuner, final boolean enableBitVector, final boolean enableKll) throws MetaException {
        final boolean areAllPartsFound = partsFound == (long)partNames.size();
        return Batchable.runBatched(this.batchSize, colNames, new Batchable<String, ColumnStatisticsObj>(){

            @Override
            public List<ColumnStatisticsObj> run(final List<String> inputColNames) throws MetaException {
                return Batchable.runBatched(MetaStoreDirectSql.this.batchSize, partNames, new Batchable<String, ColumnStatisticsObj>(){

                    @Override
                    public List<ColumnStatisticsObj> run(List<String> inputPartNames) throws MetaException {
                        return MetaStoreDirectSql.this.columnStatisticsObjForPartitionsBatch(catName, dbName, tableName, inputPartNames, inputColNames, engine, areAllPartsFound, useDensityFunctionForNDVEstimation, ndvTuner, enableBitVector, enableKll);
                    }
                });
            }
        });
    }

    public List<MetaStoreServerUtils.ColStatsObjWithSourceInfo> getColStatsForAllTablePartitions(String catName, String dbName, boolean enableBitVector, boolean enableKll) throws MetaException {
        String queryText = "select \"TBLS\".\"TBL_NAME\", \"PARTITIONS\".\"PART_NAME\", " + this.getStatsList(enableBitVector, enableKll) + " from " + this.PART_COL_STATS + " inner join " + this.PARTITIONS + " on " + this.PART_COL_STATS + ".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\" inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" where " + this.DBS + ".\"NAME\" = ? and " + this.DBS + ".\"CTLG_NAME\" = ?";
        long start = 0L;
        long end = 0L;
        boolean doTrace = LOG.isDebugEnabled();
        Object qResult = null;
        start = doTrace ? System.nanoTime() : 0L;
        ArrayList<MetaStoreServerUtils.ColStatsObjWithSourceInfo> colStatsForDB = new ArrayList<MetaStoreServerUtils.ColStatsObjWithSourceInfo>();
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            qResult = this.executeWithArray(query.getInnerQuery(), new Object[]{dbName, catName}, queryText);
            if (qResult == null) {
                ArrayList<MetaStoreServerUtils.ColStatsObjWithSourceInfo> arrayList = colStatsForDB;
                return arrayList;
            }
            end = doTrace ? System.nanoTime() : 0L;
            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
            List<Object[]> list = MetastoreDirectSqlUtils.ensureList(qResult);
            for (Object[] row : list) {
                String tblName = (String)row[0];
                String partName = (String)row[1];
                ColumnStatisticsObj colStatObj = this.prepareCSObj(row, 2);
                colStatsForDB.add(new MetaStoreServerUtils.ColStatsObjWithSourceInfo(colStatObj, catName, dbName, tblName, partName));
                Deadline.checkTimeout();
            }
        }
        return colStatsForDB;
    }

    private List<ColumnStatisticsObj> columnStatisticsObjForPartitionsBatch(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, String engine, boolean areAllPartsFound, boolean useDensityFunctionForNDVEstimation, double ndvTuner, boolean enableBitVector, boolean enableKll) throws MetaException {
        if (enableBitVector || enableKll) {
            return this.aggrStatsUseJava(catName, dbName, tableName, partNames, colNames, engine, areAllPartsFound, useDensityFunctionForNDVEstimation, ndvTuner, enableBitVector, enableKll);
        }
        return this.aggrStatsUseDB(catName, dbName, tableName, partNames, colNames, engine, areAllPartsFound, useDensityFunctionForNDVEstimation, ndvTuner);
    }

    private List<ColumnStatisticsObj> aggrStatsUseJava(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, String engine, boolean areAllPartsFound, boolean useDensityFunctionForNDVEstimation, double ndvTuner, boolean enableBitVector, boolean enableKll) throws MetaException {
        List<ColumnStatistics> partStats = this.getPartitionStats(catName, dbName, tableName, partNames, colNames, engine, enableBitVector, enableKll);
        return MetaStoreServerUtils.aggrPartitionStats(partStats, catName, dbName, tableName, partNames, colNames, areAllPartsFound, useDensityFunctionForNDVEstimation, ndvTuner);
    }

    private List<ColumnStatisticsObj> aggrStatsUseDB(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, String engine, boolean areAllPartsFound, boolean useDensityFunctionForNDVEstimation, double ndvTuner) throws MetaException {
        List<Object[]> list;
        Object colType;
        String commonPrefix = "select \"COLUMN_NAME\", \"COLUMN_TYPE\", min(\"LONG_LOW_VALUE\"), max(\"LONG_HIGH_VALUE\"), min(\"DOUBLE_LOW_VALUE\"), max(\"DOUBLE_HIGH_VALUE\"), min(cast(\"BIG_DECIMAL_LOW_VALUE\" as decimal)), max(cast(\"BIG_DECIMAL_HIGH_VALUE\" as decimal)), sum(\"NUM_NULLS\"), max(\"NUM_DISTINCTS\"), max(\"AVG_COL_LEN\"), max(\"MAX_COL_LEN\"), sum(\"NUM_TRUES\"), sum(\"NUM_FALSES\"), avg((\"LONG_HIGH_VALUE\"-\"LONG_LOW_VALUE\")/cast(\"NUM_DISTINCTS\" as decimal)),avg((\"DOUBLE_HIGH_VALUE\"-\"DOUBLE_LOW_VALUE\")/\"NUM_DISTINCTS\"),avg((cast(\"BIG_DECIMAL_HIGH_VALUE\" as decimal)-cast(\"BIG_DECIMAL_LOW_VALUE\" as decimal))/\"NUM_DISTINCTS\"),sum(\"NUM_DISTINCTS\") from " + this.PART_COL_STATS + " inner join " + this.PARTITIONS + " on " + this.PART_COL_STATS + ".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\" inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" where " + this.DBS + ".\"CTLG_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.TBLS + ".\"TBL_NAME\" = ? ";
        String queryText = null;
        long start = 0L;
        long end = 0L;
        boolean doTrace = LOG.isDebugEnabled();
        ForwardQueryResult fqr = null;
        if (areAllPartsFound) {
            queryText = commonPrefix + " and \"COLUMN_NAME\" in (" + this.makeParams(colNames.size()) + ") and " + this.PARTITIONS + ".\"PART_NAME\" in (" + this.makeParams(partNames.size()) + ") and \"ENGINE\" = ?  group by \"COLUMN_NAME\", \"COLUMN_TYPE\"";
            start = doTrace ? System.nanoTime() : 0L;
            try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
                Object qResult = this.executeWithArray(query.getInnerQuery(), this.prepareParams(catName, dbName, tableName, partNames, colNames, engine), queryText);
                if (qResult == null) {
                    List<ColumnStatisticsObj> list2 = Collections.emptyList();
                    return list2;
                }
                end = doTrace ? System.nanoTime() : 0L;
                MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
                List<Object[]> list3 = MetastoreDirectSqlUtils.ensureList(qResult);
                ArrayList<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>(list3.size());
                for (Object[] row : list3) {
                    colStats.add(this.prepareCSObjWithAdjustedNDV(row, 0, useDensityFunctionForNDVEstimation, ndvTuner));
                    Deadline.checkTimeout();
                }
                ArrayList<ColumnStatisticsObj> arrayList = colStats;
                return arrayList;
            }
        }
        ArrayList<ColumnStatisticsObj> colStats = new ArrayList<ColumnStatisticsObj>(colNames.size());
        queryText = "select \"COLUMN_NAME\", \"COLUMN_TYPE\", count(\"PART_COL_STATS\".\"PART_ID\")  from " + this.PART_COL_STATS + " inner join " + this.PARTITIONS + " on " + this.PART_COL_STATS + ".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\" inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" where " + this.DBS + ".\"CTLG_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.TBLS + ".\"TBL_NAME\" = ?  and " + this.PART_COL_STATS + ".\"COLUMN_NAME\" in (" + this.makeParams(colNames.size()) + ") and " + this.PARTITIONS + ".\"PART_NAME\" in (" + this.makeParams(partNames.size()) + ") and " + this.PART_COL_STATS + ".\"ENGINE\" = ?  group by " + this.PART_COL_STATS + ".\"COLUMN_NAME\", " + this.PART_COL_STATS + ".\"COLUMN_TYPE\"";
        start = doTrace ? System.nanoTime() : 0L;
        ArrayList<String> noExtraColumnNames = new ArrayList<String>();
        HashMap<String, String[]> extraColumnNameTypeParts = new HashMap<String, String[]>();
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            Object qResult = this.executeWithArray(query.getInnerQuery(), this.prepareParams(catName, dbName, tableName, partNames, colNames, engine), queryText);
            end = doTrace ? System.nanoTime() : 0L;
            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
            if (qResult == null) {
                List<ColumnStatisticsObj> row = Collections.emptyList();
                return row;
            }
            List<Object[]> list4 = MetastoreDirectSqlUtils.ensureList(qResult);
            for (Object[] objectArray : list4) {
                String colName = (String)objectArray[0];
                colType = (String)objectArray[1];
                Long count = MetastoreDirectSqlUtils.extractSqlLong(objectArray[2]);
                if (count == (long)partNames.size() || count < 2L) {
                    noExtraColumnNames.add(colName);
                } else {
                    extraColumnNameTypeParts.put(colName, new String[]{colType, String.valueOf(count)});
                }
                Deadline.checkTimeout();
            }
        }
        if (noExtraColumnNames.size() != 0) {
            queryText = commonPrefix + " and \"COLUMN_NAME\" in (" + this.makeParams(noExtraColumnNames.size()) + ") and \"PARTITION_NAME\" in (" + this.makeParams(partNames.size()) + ") and \"ENGINE\" = ?  group by \"COLUMN_NAME\", \"COLUMN_TYPE\"";
            start = doTrace ? System.nanoTime() : 0L;
            try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
                Object qResult = this.executeWithArray(query.getInnerQuery(), this.prepareParams(catName, dbName, tableName, partNames, noExtraColumnNames, engine), queryText);
                if (qResult == null) {
                    Iterator<Object> iterator = Collections.emptyList();
                    return iterator;
                }
                list = MetastoreDirectSqlUtils.ensureList(qResult);
                for (Object[] objectArray : list) {
                    colStats.add(this.prepareCSObjWithAdjustedNDV(objectArray, 0, useDensityFunctionForNDVEstimation, ndvTuner));
                    Deadline.checkTimeout();
                }
                end = doTrace ? System.nanoTime() : 0L;
                MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
            }
        }
        if (extraColumnNameTypeParts.size() != 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            for (int index = 0; index < partNames.size(); ++index) {
                indexMap.put(partNames.get(index), index);
            }
            HashMap sumMap = new HashMap();
            queryText = "select \"COLUMN_NAME\", sum(\"NUM_NULLS\"), sum(\"NUM_TRUES\"), sum(\"NUM_FALSES\"), sum(\"NUM_DISTINCTS\") from " + this.PART_COL_STATS + " inner join " + this.PARTITIONS + " on " + this.PART_COL_STATS + ".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\" inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" where " + this.DBS + ".\"CTLG_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.TBLS + ".\"TBL_NAME\" = ?  and " + this.PART_COL_STATS + ".\"COLUMN_NAME\" in (" + this.makeParams(extraColumnNameTypeParts.size()) + ") and " + this.PARTITIONS + ".\"PART_NAME\" in (" + this.makeParams(partNames.size()) + ") and " + this.PART_COL_STATS + ".\"ENGINE\" = ?  group by " + this.PART_COL_STATS + ".\"COLUMN_NAME\"";
            start = doTrace ? System.nanoTime() : 0L;
            try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(extraColumnNameTypeParts.keySet());
                Object qResult = this.executeWithArray(query.getInnerQuery(), this.prepareParams(catName, dbName, tableName, partNames, arrayList, engine), queryText);
                if (qResult == null) {
                    colType = Collections.emptyList();
                    return colType;
                }
                list = MetastoreDirectSqlUtils.ensureList(qResult);
                Integer[] sumIndex = new Integer[]{6, 10, 11, 15};
                for (Object[] row : list) {
                    HashMap<Integer, Object> indexToObject = new HashMap<Integer, Object>();
                    for (int ind = 1; ind < row.length; ++ind) {
                        indexToObject.put(sumIndex[ind - 1], row[ind]);
                    }
                    sumMap.put((String)row[0], indexToObject);
                    Deadline.checkTimeout();
                }
                end = doTrace ? System.nanoTime() : 0L;
                MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
            }
            for (Map.Entry entry : extraColumnNameTypeParts.entrySet()) {
                Object[] row = new Object[IExtrapolatePartStatus.colStatNames.length + 2];
                String colName = (String)entry.getKey();
                String colType2 = ((String[])entry.getValue())[0];
                Long sumVal = Long.parseLong(((String[])entry.getValue())[1]);
                row[0] = colName;
                row[1] = colType2;
                LinearExtrapolatePartStatus extrapolateMethod = new LinearExtrapolatePartStatus();
                Integer[] index = null;
                boolean decimal = false;
                if (colType2.toLowerCase().startsWith("decimal")) {
                    index = IExtrapolatePartStatus.indexMaps.get("decimal");
                    decimal = true;
                } else {
                    index = IExtrapolatePartStatus.indexMaps.get(colType2.toLowerCase());
                }
                if (index == null) {
                    index = IExtrapolatePartStatus.indexMaps.get("default");
                }
                Integer[] integerArray = index;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    Object[] min;
                    Object qResult;
                    QueryWrapper query;
                    int colStatIndex = integerArray[i];
                    String colStatName = IExtrapolatePartStatus.colStatNames[colStatIndex];
                    if (IExtrapolatePartStatus.aggrTypes[colStatIndex] == IExtrapolatePartStatus.AggrType.Sum) {
                        Object o = ((Map)sumMap.get(colName)).get(colStatIndex);
                        if (o == null) {
                            row[2 + colStatIndex] = null;
                            continue;
                        }
                        Long val = MetastoreDirectSqlUtils.extractSqlLong(o);
                        row[2 + colStatIndex] = val / sumVal * (long)partNames.size();
                        continue;
                    }
                    if (IExtrapolatePartStatus.aggrTypes[colStatIndex] == IExtrapolatePartStatus.AggrType.Min || IExtrapolatePartStatus.aggrTypes[colStatIndex] == IExtrapolatePartStatus.AggrType.Max) {
                        queryText = !decimal ? "select \"" + colStatName + "\",\"PART_NAME\" from " + this.PART_COL_STATS + " inner join " + this.PARTITIONS + " on " + this.PART_COL_STATS + ".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\" inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" where " + this.DBS + ".\"CTLG_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.TBLS + ".\"TBL_NAME\" = ?  and " + this.PART_COL_STATS + ".\"COLUMN_NAME\" = ?  and " + this.PARTITIONS + ".\"PART_NAME\" in (" + this.makeParams(partNames.size()) + ") and " + this.PART_COL_STATS + ".\"ENGINE\" = ?  order by \"" + colStatName + "\"" : "select \"" + colStatName + "\",\"PART_NAME\" from " + this.PART_COL_STATS + " inner join " + this.PARTITIONS + " on " + this.PART_COL_STATS + ".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\" inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" where " + this.DBS + ".\"CTLG_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.TBLS + ".\"TBL_NAME\" = ?  and " + this.PART_COL_STATS + ".\"COLUMN_NAME\" = ?  and " + this.PARTITIONS + ".\"PART_NAME\" in (" + this.makeParams(partNames.size()) + ") and " + this.PART_COL_STATS + ".\"ENGINE\" = ?  order by cast(\"" + colStatName + "\" as decimal)";
                        start = doTrace ? System.nanoTime() : 0L;
                        query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));
                        try {
                            qResult = this.executeWithArray(query.getInnerQuery(), this.prepareParams(catName, dbName, tableName, partNames, Arrays.asList(colName), engine), queryText);
                            if (qResult == null) {
                                List<ColumnStatisticsObj> list2 = Collections.emptyList();
                                return list2;
                            }
                            fqr = (ForwardQueryResult)qResult;
                            min = (Object[])fqr.get(0);
                            Object[] max = (Object[])fqr.get(fqr.size() - 1);
                            end = doTrace ? System.nanoTime() : 0L;
                            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
                            if (min[0] == null || max[0] == null) {
                                row[2 + colStatIndex] = null;
                                continue;
                            }
                            row[2 + colStatIndex] = extrapolateMethod.extrapolate(min, max, colStatIndex, indexMap);
                            continue;
                        }
                        finally {
                            query.close();
                        }
                    }
                    queryText = "select avg((\"LONG_HIGH_VALUE\"-\"LONG_LOW_VALUE\")/cast(\"NUM_DISTINCTS\" as decimal)),avg((\"DOUBLE_HIGH_VALUE\"-\"DOUBLE_LOW_VALUE\")/\"NUM_DISTINCTS\"),avg((cast(\"BIG_DECIMAL_HIGH_VALUE\" as decimal)-cast(\"BIG_DECIMAL_LOW_VALUE\" as decimal))/\"NUM_DISTINCTS\") from " + this.PART_COL_STATS + " inner join " + this.PARTITIONS + " on " + this.PART_COL_STATS + ".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\" inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" where " + this.DBS + ".\"CTLG_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.TBLS + ".\"TBL_NAME\" = ?  and " + this.PART_COL_STATS + ".\"COLUMN_NAME\" = ?  and " + this.PARTITIONS + ".\"PART_NAME\" in (" + this.makeParams(partNames.size()) + ") and " + this.PART_COL_STATS + ".\"ENGINE\" = ?  group by \"COLUMN_NAME\"";
                    start = doTrace ? System.nanoTime() : 0L;
                    query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));
                    try {
                        qResult = this.executeWithArray(query.getInnerQuery(), this.prepareParams(catName, dbName, tableName, partNames, Arrays.asList(colName), engine), queryText);
                        if (qResult == null) {
                            min = Collections.emptyList();
                            return min;
                        }
                        fqr = (ForwardQueryResult)qResult;
                        Object[] avg = (Object[])fqr.get(0);
                        row[2 + colStatIndex] = avg[colStatIndex - 12];
                        end = doTrace ? System.nanoTime() : 0L;
                        MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
                        continue;
                    }
                    finally {
                        query.close();
                    }
                }
                colStats.add(this.prepareCSObjWithAdjustedNDV(row, 0, useDensityFunctionForNDVEstimation, ndvTuner));
                Deadline.checkTimeout();
            }
        }
        return colStats;
    }

    private ColumnStatisticsObj prepareCSObj(Object[] row, int i) throws MetaException {
        ColumnStatisticsData data = new ColumnStatisticsData();
        ColumnStatisticsObj cso = new ColumnStatisticsObj((String)row[i++], (String)row[i++], data);
        Object llow = row[i++];
        Object lhigh = row[i++];
        Object dlow = row[i++];
        Object dhigh = row[i++];
        Object declow = row[i++];
        Object dechigh = row[i++];
        Object nulls = row[i++];
        Object dist = row[i++];
        Object bitVector = row[i++];
        Object histogram = row[i++];
        Object avglen = row[i++];
        Object maxlen = row[i++];
        Object trues = row[i++];
        Object falses = row[i];
        StatObjectConverter.fillColumnStatisticsData(cso.getColType(), data, llow, lhigh, dlow, dhigh, declow, dechigh, nulls, dist, bitVector, histogram, avglen, maxlen, trues, falses);
        return cso;
    }

    private ColumnStatisticsObj prepareCSObjWithAdjustedNDV(Object[] row, int i, boolean useDensityFunctionForNDVEstimation, double ndvTuner) throws MetaException {
        ColumnStatisticsData data = new ColumnStatisticsData();
        ColumnStatisticsObj cso = new ColumnStatisticsObj((String)row[i++], (String)row[i++], data);
        Object llow = row[i++];
        Object lhigh = row[i++];
        Object dlow = row[i++];
        Object dhigh = row[i++];
        Object declow = row[i++];
        Object dechigh = row[i++];
        Object nulls = row[i++];
        Object dist = row[i++];
        Object avglen = row[i++];
        Object maxlen = row[i++];
        Object trues = row[i++];
        Object falses = row[i++];
        Object avgLong = row[i++];
        Object avgDouble = row[i++];
        Object avgDecimal = row[i++];
        Object sumDist = row[i++];
        StatObjectConverter.fillColumnStatisticsData(cso.getColType(), data, llow, lhigh, dlow, dhigh, declow, dechigh, nulls, dist, avglen, maxlen, trues, falses, avgLong, avgDouble, avgDecimal, sumDist, useDensityFunctionForNDVEstimation, ndvTuner);
        return cso;
    }

    private Object[] prepareParams(String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, String engine) throws MetaException {
        Object[] params = new Object[colNames.size() + partNames.size() + 4];
        int paramI = 0;
        params[paramI++] = catName;
        params[paramI++] = dbName;
        params[paramI++] = tableName;
        for (String colName : colNames) {
            params[paramI++] = colName;
        }
        for (String partName : partNames) {
            params[paramI++] = partName;
        }
        params[paramI++] = engine;
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ColumnStatistics> getPartitionStats(final String catName, final String dbName, final String tableName, final List<String> partNames, List<String> colNames, final String engine, boolean enableBitVector, boolean enableKll) throws MetaException {
        if (colNames.isEmpty() || partNames.isEmpty()) {
            return Collections.emptyList();
        }
        final boolean doTrace = LOG.isDebugEnabled();
        final String queryText0 = "select \"PARTITIONS\".\"PART_NAME\", " + this.getStatsList(enableBitVector, enableKll) + " from " + this.PART_COL_STATS + " inner join " + this.PARTITIONS + " on " + this.PART_COL_STATS + ".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" inner join " + this.TBLS + " on " + this.PARTITIONS + ".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\" inner join " + this.DBS + " on " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" where " + this.DBS + ".\"CTLG_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.TBLS + ".\"TBL_NAME\" = ?  and " + this.PART_COL_STATS + ".\"COLUMN_NAME\" in (%1$s) and " + this.PARTITIONS + ".\"PART_NAME\" in (%2$s) and " + this.PART_COL_STATS + ".\"ENGINE\" = ?  order by " + this.PARTITIONS + ".\"PART_NAME\"";
        Batchable<String, Object[]> b = new Batchable<String, Object[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Object[]> run(final List<String> inputColNames) throws MetaException {
                Batchable<String, Object[]> b2 = new Batchable<String, Object[]>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public List<Object[]> run(List<String> inputPartNames) throws MetaException {
                        String queryText = String.format(queryText0, MetaStoreDirectSql.this.makeParams(inputColNames.size()), MetaStoreDirectSql.this.makeParams(inputPartNames.size()));
                        long start = doTrace ? System.nanoTime() : 0L;
                        Query query = MetaStoreDirectSql.this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText);
                        try {
                            Object qResult = MetaStoreDirectSql.this.executeWithArray(query, MetaStoreDirectSql.this.prepareParams(catName, dbName, tableName, inputPartNames, inputColNames, engine), queryText);
                            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText0, start, doTrace ? System.nanoTime() : 0L);
                            if (qResult == null) {
                                List<Object[]> list = Collections.emptyList();
                                return list;
                            }
                            List<Object[]> list = MetastoreDirectSqlUtils.ensureList(qResult);
                            return list;
                        }
                        finally {
                            this.addQueryAfterUse(query);
                        }
                    }
                };
                try {
                    List<Object[]> list = Batchable.runBatched(MetaStoreDirectSql.this.batchSize, partNames, b2);
                    return list;
                }
                finally {
                    this.addQueryAfterUse(b2);
                }
            }
        };
        ArrayList<ColumnStatistics> result = new ArrayList<ColumnStatistics>(partNames.size());
        String lastPartName = null;
        int from = 0;
        try {
            List<Object[]> list = Batchable.runBatched(this.batchSize, colNames, b);
            for (int i = 0; i <= list.size(); ++i) {
                String partName;
                boolean isLast = i == list.size();
                String string = partName = isLast ? null : (String)list.get(i)[0];
                if (!isLast && partName.equals(lastPartName)) continue;
                if (from != i) {
                    ColumnStatisticsDesc csd = new ColumnStatisticsDesc(false, dbName, tableName);
                    csd.setCatName(catName);
                    csd.setPartName(lastPartName);
                    result.add(this.makeColumnStats(list.subList(from, i), csd, 1, engine));
                }
                lastPartName = partName;
                from = i;
                Deadline.checkTimeout();
            }
        }
        finally {
            b.closeAllQueries();
        }
        return result;
    }

    private String getStatsList(boolean enableBitVector, boolean enableKll) {
        return "\"COLUMN_NAME\", \"COLUMN_TYPE\", \"LONG_LOW_VALUE\", \"LONG_HIGH_VALUE\", \"DOUBLE_LOW_VALUE\", \"DOUBLE_HIGH_VALUE\", \"BIG_DECIMAL_LOW_VALUE\", \"BIG_DECIMAL_HIGH_VALUE\", \"NUM_NULLS\", \"NUM_DISTINCTS\", " + (enableBitVector ? "\"BIT_VECTOR\", " : "'', ") + (enableKll ? "\"HISTOGRAM\", " : "'', ") + "\"AVG_COL_LEN\", \"MAX_COL_LEN\", \"NUM_TRUES\", \"NUM_FALSES\", \"LAST_ANALYZED\" ";
    }

    private ColumnStatistics makeColumnStats(List<Object[]> list, ColumnStatisticsDesc csd, int offset, String engine) throws MetaException {
        ColumnStatistics result = new ColumnStatistics();
        result.setStatsDesc(csd);
        ArrayList<ColumnStatisticsObj> csos = new ArrayList<ColumnStatisticsObj>(list.size());
        for (Object[] row : list) {
            Object laObj = row[offset + 16];
            if (!(laObj == null || csd.isSetLastAnalyzed() && csd.getLastAnalyzed() <= MetastoreDirectSqlUtils.extractSqlLong(laObj))) {
                csd.setLastAnalyzed(MetastoreDirectSqlUtils.extractSqlLong(laObj).longValue());
            }
            csos.add(this.prepareCSObj(row, offset));
            Deadline.checkTimeout();
        }
        result.setStatsObj(csos);
        result.setEngine(engine);
        return result;
    }

    private String makeParams(int size) {
        return size == 0 ? "" : StringUtils.repeat((String)",?", (int)size).substring(1);
    }

    private <T> T executeWithArray(Query query, Object[] params, String sql) throws MetaException {
        return this.executeWithArray(query, params, sql, -1);
    }

    private <T> T executeWithArray(Query query, Object[] params, String sql, int limit) throws MetaException {
        return MetastoreDirectSqlUtils.executeWithArray(query, params, sql, limit);
    }

    public void prepareTxn() throws MetaException {
        String stmt = this.dbType.getPrepareTxnStmt();
        if (stmt == null) {
            return;
        }
        try {
            assert (this.pm.currentTransaction().isActive());
            this.executeNoResult(stmt);
        }
        catch (SQLException sqlEx) {
            throw new MetaException("Error setting ansi quotes: " + sqlEx.getMessage());
        }
    }

    public List<SQLForeignKey> getForeignKeys(String catName, String parent_db_name, String parent_tbl_name, String foreign_db_name, String foreign_tbl_name) throws MetaException {
        ArrayList<SQLForeignKey> ret = new ArrayList<SQLForeignKey>();
        Object queryText = "SELECT  \"D2\".\"NAME\", \"T2\".\"TBL_NAME\", CASE WHEN \"C2\".\"COLUMN_NAME\" IS NOT NULL THEN \"C2\".\"COLUMN_NAME\" ELSE \"P2\".\"PKEY_NAME\" END, " + this.DBS + ".\"NAME\", " + this.TBLS + ".\"TBL_NAME\", CASE WHEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" IS NOT NULL THEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" ELSE " + this.PARTITION_KEYS + ".\"PKEY_NAME\" END, " + this.KEY_CONSTRAINTS + ".\"POSITION\", " + this.KEY_CONSTRAINTS + ".\"UPDATE_RULE\", " + this.KEY_CONSTRAINTS + ".\"DELETE_RULE\", " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_NAME\" , \"KEY_CONSTRAINTS2\".\"CONSTRAINT_NAME\", " + this.KEY_CONSTRAINTS + ".\"ENABLE_VALIDATE_RELY\"  from " + this.TBLS + "  INNER JOIN " + this.KEY_CONSTRAINTS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.KEY_CONSTRAINTS + ".\"CHILD_TBL_ID\"  INNER JOIN " + this.KEY_CONSTRAINTS + " \"KEY_CONSTRAINTS2\" ON \"KEY_CONSTRAINTS2\".\"PARENT_TBL_ID\"  = " + this.KEY_CONSTRAINTS + ".\"PARENT_TBL_ID\"  AND \"KEY_CONSTRAINTS2\".\"PARENT_CD_ID\"  = " + this.KEY_CONSTRAINTS + ".\"PARENT_CD_ID\" AND  \"KEY_CONSTRAINTS2\".\"PARENT_INTEGER_IDX\"  = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  INNER JOIN " + this.TBLS + " \"T2\" ON  " + this.KEY_CONSTRAINTS + ".\"PARENT_TBL_ID\" = \"T2\".\"TBL_ID\"  INNER JOIN " + this.DBS + " \"D2\" ON \"T2\".\"DB_ID\" = \"D2\".\"DB_ID\"  LEFT OUTER JOIN " + this.COLUMNS_V2 + "  ON " + this.COLUMNS_V2 + ".\"CD_ID\" = " + this.KEY_CONSTRAINTS + ".\"CHILD_CD_ID\" AND  " + this.COLUMNS_V2 + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"CHILD_INTEGER_IDX\"  LEFT OUTER JOIN " + this.PARTITION_KEYS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITION_KEYS + ".\"TBL_ID\" AND  " + this.PARTITION_KEYS + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"CHILD_INTEGER_IDX\"  LEFT OUTER JOIN " + this.COLUMNS_V2 + " \"C2\" ON \"C2\".\"CD_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_CD_ID\" AND  \"C2\".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  LEFT OUTER JOIN " + this.PARTITION_KEYS + " \"P2\" ON \"P2\".\"TBL_ID\" = " + this.TBLS + ".\"TBL_ID\" AND  \"P2\".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  WHERE " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_TYPE\" = 1 AND \"KEY_CONSTRAINTS2\".\"CONSTRAINT_TYPE\" = 0 AND " + this.DBS + ".\"CTLG_NAME\" = ? AND" + (String)(foreign_db_name == null ? "" : " " + this.DBS + ".\"NAME\" = ? AND") + (String)(foreign_tbl_name == null ? "" : " " + this.TBLS + ".\"TBL_NAME\" = ? AND") + (parent_tbl_name == null ? "" : " \"T2\".\"TBL_NAME\" = ? AND") + (parent_db_name == null ? "" : " \"D2\".\"NAME\" = ?");
        if (((String)(queryText = ((String)queryText).trim())).endsWith("AND")) {
            queryText = ((String)queryText).substring(0, ((String)queryText).length() - 3);
        }
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(catName);
        if (foreign_db_name != null) {
            pms.add(foreign_db_name);
        }
        if (foreign_tbl_name != null) {
            pms.add(foreign_tbl_name);
        }
        if (parent_tbl_name != null) {
            pms.add(parent_tbl_name);
        }
        if (parent_db_name != null) {
            pms.add(parent_db_name);
        }
        try (QueryWrapper queryParams = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", queryText));){
            List<Object[]> sqlResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(queryParams.getInnerQuery(), pms.toArray(), (String)queryText));
            if (!sqlResult.isEmpty()) {
                for (Object[] line : sqlResult) {
                    int enableValidateRely = MetastoreDirectSqlUtils.extractSqlInt(line[11]);
                    boolean enable = (enableValidateRely & 4) != 0;
                    boolean validate = (enableValidateRely & 2) != 0;
                    boolean rely = (enableValidateRely & 1) != 0;
                    SQLForeignKey currKey = new SQLForeignKey(MetastoreDirectSqlUtils.extractSqlString(line[0]), MetastoreDirectSqlUtils.extractSqlString(line[1]), MetastoreDirectSqlUtils.extractSqlString(line[2]), MetastoreDirectSqlUtils.extractSqlString(line[3]), MetastoreDirectSqlUtils.extractSqlString(line[4]), MetastoreDirectSqlUtils.extractSqlString(line[5]), MetastoreDirectSqlUtils.extractSqlInt(line[6]), MetastoreDirectSqlUtils.extractSqlInt(line[7]), MetastoreDirectSqlUtils.extractSqlInt(line[8]), MetastoreDirectSqlUtils.extractSqlString(line[9]), MetastoreDirectSqlUtils.extractSqlString(line[10]), enable, validate, rely);
                    currKey.setCatName(catName);
                    ret.add(currKey);
                }
            }
            ArrayList<SQLForeignKey> arrayList = ret;
            return arrayList;
        }
    }

    public List<SQLPrimaryKey> getPrimaryKeys(String catName, String db_name, String tbl_name) throws MetaException {
        ArrayList<SQLPrimaryKey> ret = new ArrayList<SQLPrimaryKey>();
        Object queryText = "SELECT " + this.DBS + ".\"NAME\", " + this.TBLS + ".\"TBL_NAME\", CASE WHEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" IS NOT NULL THEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" ELSE " + this.PARTITION_KEYS + ".\"PKEY_NAME\" END, " + this.KEY_CONSTRAINTS + ".\"POSITION\", " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_NAME\", " + this.KEY_CONSTRAINTS + ".\"ENABLE_VALIDATE_RELY\", " + this.DBS + ".\"CTLG_NAME\" from " + this.TBLS + "  INNER JOIN " + this.KEY_CONSTRAINTS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_TBL_ID\"  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  LEFT OUTER JOIN " + this.COLUMNS_V2 + " ON " + this.COLUMNS_V2 + ".\"CD_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_CD_ID\" AND  " + this.COLUMNS_V2 + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  LEFT OUTER JOIN " + this.PARTITION_KEYS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITION_KEYS + ".\"TBL_ID\" AND  " + this.PARTITION_KEYS + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  WHERE " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_TYPE\" = 0 AND " + this.DBS + ".\"CTLG_NAME\" = ? AND" + (String)(db_name == null ? "" : " " + this.DBS + ".\"NAME\" = ? AND") + (String)(tbl_name == null ? "" : " " + this.TBLS + ".\"TBL_NAME\" = ? ");
        if (((String)(queryText = ((String)queryText).trim())).endsWith("AND")) {
            queryText = ((String)queryText).substring(0, ((String)queryText).length() - 3);
        }
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(catName);
        if (db_name != null) {
            pms.add(db_name);
        }
        if (tbl_name != null) {
            pms.add(tbl_name);
        }
        try (QueryWrapper queryParams = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", queryText));){
            List<Object[]> sqlResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(queryParams.getInnerQuery(), pms.toArray(), (String)queryText));
            if (!sqlResult.isEmpty()) {
                for (Object[] line : sqlResult) {
                    int enableValidateRely = MetastoreDirectSqlUtils.extractSqlInt(line[5]);
                    boolean enable = (enableValidateRely & 4) != 0;
                    boolean validate = (enableValidateRely & 2) != 0;
                    boolean rely = (enableValidateRely & 1) != 0;
                    SQLPrimaryKey currKey = new SQLPrimaryKey(MetastoreDirectSqlUtils.extractSqlString(line[0]), MetastoreDirectSqlUtils.extractSqlString(line[1]), MetastoreDirectSqlUtils.extractSqlString(line[2]), MetastoreDirectSqlUtils.extractSqlInt(line[3]), MetastoreDirectSqlUtils.extractSqlString(line[4]), enable, validate, rely);
                    currKey.setCatName(MetastoreDirectSqlUtils.extractSqlString(line[6]));
                    ret.add(currKey);
                }
            }
            ArrayList<SQLPrimaryKey> arrayList = ret;
            return arrayList;
        }
    }

    public List<SQLUniqueConstraint> getUniqueConstraints(String catName, String db_name, String tbl_name) throws MetaException {
        ArrayList<SQLUniqueConstraint> ret = new ArrayList<SQLUniqueConstraint>();
        Object queryText = "SELECT " + this.DBS + ".\"NAME\", " + this.TBLS + ".\"TBL_NAME\", CASE WHEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" IS NOT NULL THEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" ELSE " + this.PARTITION_KEYS + ".\"PKEY_NAME\" END, " + this.KEY_CONSTRAINTS + ".\"POSITION\", " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_NAME\", " + this.KEY_CONSTRAINTS + ".\"ENABLE_VALIDATE_RELY\"  from " + this.TBLS + "  INNER JOIN " + this.KEY_CONSTRAINTS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_TBL_ID\"  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  LEFT OUTER JOIN " + this.COLUMNS_V2 + " ON " + this.COLUMNS_V2 + ".\"CD_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_CD_ID\" AND  " + this.COLUMNS_V2 + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  LEFT OUTER JOIN " + this.PARTITION_KEYS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITION_KEYS + ".\"TBL_ID\" AND  " + this.PARTITION_KEYS + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  WHERE " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_TYPE\" = 2 AND " + this.DBS + ".\"CTLG_NAME\" = ? AND" + (String)(db_name == null ? "" : " " + this.DBS + ".\"NAME\" = ? AND") + (String)(tbl_name == null ? "" : " " + this.TBLS + ".\"TBL_NAME\" = ? ");
        if (((String)(queryText = ((String)queryText).trim())).endsWith("AND")) {
            queryText = ((String)queryText).substring(0, ((String)queryText).length() - 3);
        }
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(catName);
        if (db_name != null) {
            pms.add(db_name);
        }
        if (tbl_name != null) {
            pms.add(tbl_name);
        }
        try (QueryWrapper queryParams = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", queryText));){
            List<Object[]> sqlResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(queryParams.getInnerQuery(), pms.toArray(), (String)queryText));
            if (!sqlResult.isEmpty()) {
                for (Object[] line : sqlResult) {
                    int enableValidateRely = MetastoreDirectSqlUtils.extractSqlInt(line[5]);
                    boolean enable = (enableValidateRely & 4) != 0;
                    boolean validate = (enableValidateRely & 2) != 0;
                    boolean rely = (enableValidateRely & 1) != 0;
                    ret.add(new SQLUniqueConstraint(catName, MetastoreDirectSqlUtils.extractSqlString(line[0]), MetastoreDirectSqlUtils.extractSqlString(line[1]), MetastoreDirectSqlUtils.extractSqlString(line[2]), MetastoreDirectSqlUtils.extractSqlInt(line[3]), MetastoreDirectSqlUtils.extractSqlString(line[4]), enable, validate, rely));
                }
            }
            ArrayList<SQLUniqueConstraint> arrayList = ret;
            return arrayList;
        }
    }

    public List<SQLNotNullConstraint> getNotNullConstraints(String catName, String db_name, String tbl_name) throws MetaException {
        ArrayList<SQLNotNullConstraint> ret = new ArrayList<SQLNotNullConstraint>();
        Object queryText = "SELECT " + this.DBS + ".\"NAME\", " + this.TBLS + ".\"TBL_NAME\",CASE WHEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" IS NOT NULL THEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" ELSE " + this.PARTITION_KEYS + ".\"PKEY_NAME\" END, " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_NAME\", " + this.KEY_CONSTRAINTS + ".\"ENABLE_VALIDATE_RELY\"  from " + this.TBLS + "  INNER JOIN " + this.KEY_CONSTRAINTS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_TBL_ID\"  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  LEFT OUTER JOIN " + this.COLUMNS_V2 + " ON " + this.COLUMNS_V2 + ".\"CD_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_CD_ID\" AND  " + this.COLUMNS_V2 + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  LEFT OUTER JOIN " + this.PARTITION_KEYS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITION_KEYS + ".\"TBL_ID\" AND  " + this.PARTITION_KEYS + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  WHERE " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_TYPE\" = 3 AND " + this.DBS + ".\"CTLG_NAME\" = ? AND" + (String)(db_name == null ? "" : " " + this.DBS + ".\"NAME\" = ? AND") + (String)(tbl_name == null ? "" : " " + this.TBLS + ".\"TBL_NAME\" = ? ");
        if (((String)(queryText = ((String)queryText).trim())).endsWith("AND")) {
            queryText = ((String)queryText).substring(0, ((String)queryText).length() - 3);
        }
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(catName);
        if (db_name != null) {
            pms.add(db_name);
        }
        if (tbl_name != null) {
            pms.add(tbl_name);
        }
        try (QueryWrapper queryParams = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", queryText));){
            List<Object[]> sqlResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(queryParams.getInnerQuery(), pms.toArray(), (String)queryText));
            if (!sqlResult.isEmpty()) {
                for (Object[] line : sqlResult) {
                    int enableValidateRely = MetastoreDirectSqlUtils.extractSqlInt(line[4]);
                    boolean enable = (enableValidateRely & 4) != 0;
                    boolean validate = (enableValidateRely & 2) != 0;
                    boolean rely = (enableValidateRely & 1) != 0;
                    ret.add(new SQLNotNullConstraint(catName, MetastoreDirectSqlUtils.extractSqlString(line[0]), MetastoreDirectSqlUtils.extractSqlString(line[1]), MetastoreDirectSqlUtils.extractSqlString(line[2]), MetastoreDirectSqlUtils.extractSqlString(line[3]), enable, validate, rely));
                }
            }
            ArrayList<SQLNotNullConstraint> arrayList = ret;
            return arrayList;
        }
    }

    public List<SQLDefaultConstraint> getDefaultConstraints(String catName, String db_name, String tbl_name) throws MetaException {
        ArrayList<SQLDefaultConstraint> ret = new ArrayList<SQLDefaultConstraint>();
        Object queryText = "SELECT " + this.DBS + ".\"NAME\", " + this.TBLS + ".\"TBL_NAME\",CASE WHEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" IS NOT NULL THEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" ELSE " + this.PARTITION_KEYS + ".\"PKEY_NAME\" END, " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_NAME\", " + this.KEY_CONSTRAINTS + ".\"ENABLE_VALIDATE_RELY\", " + this.KEY_CONSTRAINTS + ".\"DEFAULT_VALUE\"  from " + this.TBLS + "  INNER JOIN " + this.KEY_CONSTRAINTS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_TBL_ID\"  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  LEFT OUTER JOIN " + this.COLUMNS_V2 + " ON " + this.COLUMNS_V2 + ".\"CD_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_CD_ID\" AND  " + this.COLUMNS_V2 + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  LEFT OUTER JOIN " + this.PARTITION_KEYS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITION_KEYS + ".\"TBL_ID\" AND  " + this.PARTITION_KEYS + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  WHERE " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_TYPE\" = 4 AND " + this.DBS + ".\"CTLG_NAME\" = ? AND" + (String)(db_name == null ? "" : " " + this.DBS + ".\"NAME\" = ? AND") + (String)(tbl_name == null ? "" : " " + this.TBLS + ".\"TBL_NAME\" = ? ");
        if (((String)(queryText = ((String)queryText).trim())).endsWith("AND")) {
            queryText = ((String)queryText).substring(0, ((String)queryText).length() - 3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getDefaultConstraints: directsql : " + (String)queryText);
        }
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(catName);
        if (db_name != null) {
            pms.add(db_name);
        }
        if (tbl_name != null) {
            pms.add(tbl_name);
        }
        try (QueryWrapper queryParams = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", queryText));){
            List<Object[]> sqlResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(queryParams.getInnerQuery(), pms.toArray(), (String)queryText));
            if (!sqlResult.isEmpty()) {
                for (Object[] line : sqlResult) {
                    int enableValidateRely = MetastoreDirectSqlUtils.extractSqlInt(line[4]);
                    boolean enable = (enableValidateRely & 4) != 0;
                    boolean validate = (enableValidateRely & 2) != 0;
                    boolean rely = (enableValidateRely & 1) != 0;
                    SQLDefaultConstraint currConstraint = new SQLDefaultConstraint(catName, MetastoreDirectSqlUtils.extractSqlString(line[0]), MetastoreDirectSqlUtils.extractSqlString(line[1]), MetastoreDirectSqlUtils.extractSqlString(line[2]), MetastoreDirectSqlUtils.extractSqlString(line[5]), MetastoreDirectSqlUtils.extractSqlString(line[3]), enable, validate, rely);
                    ret.add(currConstraint);
                }
            }
            ArrayList<SQLDefaultConstraint> arrayList = ret;
            return arrayList;
        }
    }

    public List<SQLCheckConstraint> getCheckConstraints(String catName, String db_name, String tbl_name) throws MetaException {
        ArrayList<SQLCheckConstraint> ret = new ArrayList<SQLCheckConstraint>();
        Object queryText = "SELECT " + this.DBS + ".\"NAME\", " + this.TBLS + ".\"TBL_NAME\",CASE WHEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" IS NOT NULL THEN " + this.COLUMNS_V2 + ".\"COLUMN_NAME\" ELSE " + this.PARTITION_KEYS + ".\"PKEY_NAME\" END, " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_NAME\", " + this.KEY_CONSTRAINTS + ".\"ENABLE_VALIDATE_RELY\", " + this.KEY_CONSTRAINTS + ".\"DEFAULT_VALUE\"  from " + this.TBLS + "  INNER JOIN " + this.KEY_CONSTRAINTS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_TBL_ID\"  INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"  LEFT OUTER JOIN " + this.COLUMNS_V2 + " ON " + this.COLUMNS_V2 + ".\"CD_ID\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_CD_ID\" AND  " + this.COLUMNS_V2 + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  LEFT OUTER JOIN " + this.PARTITION_KEYS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITION_KEYS + ".\"TBL_ID\" AND  " + this.PARTITION_KEYS + ".\"INTEGER_IDX\" = " + this.KEY_CONSTRAINTS + ".\"PARENT_INTEGER_IDX\"  WHERE " + this.KEY_CONSTRAINTS + ".\"CONSTRAINT_TYPE\" = 5 AND " + this.DBS + ".\"CTLG_NAME\" = ? AND" + (String)(db_name == null ? "" : " " + this.DBS + ".\"NAME\" = ? AND") + (String)(tbl_name == null ? "" : " " + this.TBLS + ".\"TBL_NAME\" = ? ");
        if (((String)(queryText = ((String)queryText).trim())).endsWith("AND")) {
            queryText = ((String)queryText).substring(0, ((String)queryText).length() - 3);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getCheckConstraints: directsql : " + (String)queryText);
        }
        ArrayList<String> pms = new ArrayList<String>();
        pms.add(catName);
        if (db_name != null) {
            pms.add(db_name);
        }
        if (tbl_name != null) {
            pms.add(tbl_name);
        }
        try (QueryWrapper queryParams = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", queryText));){
            List<Object[]> sqlResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(queryParams.getInnerQuery(), pms.toArray(), (String)queryText));
            if (!sqlResult.isEmpty()) {
                for (Object[] line : sqlResult) {
                    int enableValidateRely = MetastoreDirectSqlUtils.extractSqlInt(line[4]);
                    boolean enable = (enableValidateRely & 4) != 0;
                    boolean validate = (enableValidateRely & 2) != 0;
                    boolean rely = (enableValidateRely & 1) != 0;
                    SQLCheckConstraint currConstraint = new SQLCheckConstraint(catName, MetastoreDirectSqlUtils.extractSqlString(line[0]), MetastoreDirectSqlUtils.extractSqlString(line[1]), MetastoreDirectSqlUtils.extractSqlString(line[2]), MetastoreDirectSqlUtils.extractSqlString(line[5]), MetastoreDirectSqlUtils.extractSqlString(line[3]), enable, validate, rely);
                    ret.add(currConstraint);
                }
            }
            ArrayList<SQLCheckConstraint> arrayList = ret;
            return arrayList;
        }
    }

    public void dropPartitionsViaSqlFilter(final String catName, final String dbName, final String tblName, List<String> partNames) throws MetaException {
        if (partNames.isEmpty()) {
            return;
        }
        Batchable.runBatched(this.batchSize, partNames, new Batchable<String, Void>(){

            @Override
            public List<Void> run(List<String> input) throws MetaException {
                String filter = MetaStoreDirectSql.this.PARTITIONS + ".\"PART_NAME\" in (" + MetaStoreDirectSql.this.makeParams(input.size()) + ")";
                List<Long> partitionIds = MetaStoreDirectSql.this.getPartitionIdsViaSqlFilter(catName, dbName, tblName, filter, input, Collections.emptyList(), null);
                if (partitionIds.isEmpty()) {
                    return Collections.emptyList();
                }
                MetaStoreDirectSql.this.dropPartitionsByPartitionIds(partitionIds);
                return Collections.emptyList();
            }
        });
    }

    private void dropPartitionsByPartitionIds(List<Long> partitionIdList) throws MetaException {
        if (partitionIdList.isEmpty()) {
            return;
        }
        String partitionIds = MetaStoreDirectSql.getIdListForIn(partitionIdList);
        String queryText = "SELECT " + this.SDS + ".\"SD_ID\", " + this.SDS + ".\"CD_ID\", " + this.SDS + ".\"SERDE_ID\" from " + this.SDS + " INNER JOIN " + this.PARTITIONS + " ON " + this.PARTITIONS + ".\"SD_ID\" = " + this.SDS + ".\"SD_ID\" WHERE " + this.PARTITIONS + ".\"PART_ID\" in (" + partitionIds + ")";
        ArrayList<Object> sdIdList = new ArrayList<Object>(partitionIdList.size());
        ArrayList<Long> columnDescriptorIdList = new ArrayList<Long>(1);
        ArrayList<Object> serdeIdList = new ArrayList<Object>(partitionIdList.size());
        try (QueryWrapper wrapper = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            List<Object[]> sqlResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(wrapper.getInnerQuery(), null, queryText));
            if (!sqlResult.isEmpty()) {
                for (Object[] fields : sqlResult) {
                    sdIdList.add(MetastoreDirectSqlUtils.extractSqlLong(fields[0]));
                    Long colId = MetastoreDirectSqlUtils.extractSqlLong(fields[1]);
                    if (!columnDescriptorIdList.contains(colId)) {
                        columnDescriptorIdList.add(colId);
                    }
                    serdeIdList.add(MetastoreDirectSqlUtils.extractSqlLong(fields[2]));
                }
            }
        }
        try {
            queryText = "delete from " + this.PART_PRIVS + " where \"PART_ID\" in (" + partitionIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from " + this.PART_COL_PRIVS + " where \"PART_ID\" in (" + partitionIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from " + this.PART_COL_STATS + " where \"PART_ID\" in (" + partitionIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from " + this.PARTITION_PARAMS + " where \"PART_ID\" in (" + partitionIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from " + this.PARTITION_KEY_VALS + " where \"PART_ID\" in (" + partitionIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from " + this.PARTITIONS + " where \"PART_ID\" in (" + partitionIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
        }
        catch (SQLException sqlException) {
            LOG.warn("SQL error executing query while dropping partition", (Throwable)sqlException);
            throw new MetaException("Encountered error while dropping partitions.");
        }
        this.dropStorageDescriptors(sdIdList);
        Deadline.checkTimeout();
        this.dropSerdes(serdeIdList);
        Deadline.checkTimeout();
        this.dropDanglingColumnDescriptors(columnDescriptorIdList);
    }

    private void dropStorageDescriptors(List<Object> storageDescriptorIdList) throws MetaException {
        if (storageDescriptorIdList.isEmpty()) {
            return;
        }
        String sdIds = MetaStoreDirectSql.getIdListForIn(storageDescriptorIdList);
        String queryText = "select " + this.SKEWED_VALUES + ".\"STRING_LIST_ID_EID\" from " + this.SKEWED_VALUES + " WHERE " + this.SKEWED_VALUES + ".\"SD_ID_OID\" in  (" + sdIds + ")";
        ArrayList<Long> skewedStringListIdList = new ArrayList<Long>(0);
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            List sqlResult = (List)this.executeWithArray(query.getInnerQuery(), null, queryText);
            if (!sqlResult.isEmpty()) {
                for (Object stringListId : sqlResult) {
                    skewedStringListIdList.add(MetastoreDirectSqlUtils.extractSqlLong(stringListId));
                }
            }
        }
        String skewedStringListIds = MetaStoreDirectSql.getIdListForIn(skewedStringListIdList);
        try {
            queryText = "delete from " + this.SD_PARAMS + " where \"SD_ID\" in (" + sdIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from " + this.SORT_COLS + " where \"SD_ID\" in (" + sdIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from " + this.BUCKETING_COLS + " where \"SD_ID\" in (" + sdIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            if (skewedStringListIdList.size() > 0) {
                queryText = "delete from " + this.SKEWED_COL_VALUE_LOC_MAP + " where \"SD_ID\" in (" + sdIds + ")";
                this.executeNoResult(queryText);
                Deadline.checkTimeout();
                queryText = "delete from " + this.SKEWED_VALUES + " where \"SD_ID_OID\" in (" + sdIds + ")";
                this.executeNoResult(queryText);
                Deadline.checkTimeout();
                queryText = "delete from " + this.SKEWED_STRING_LIST_VALUES + " where \"STRING_LIST_ID\" in (" + skewedStringListIds + ")";
                this.executeNoResult(queryText);
                Deadline.checkTimeout();
                queryText = "delete from " + this.SKEWED_STRING_LIST + " where \"STRING_LIST_ID\" in (" + skewedStringListIds + ")";
                this.executeNoResult(queryText);
                Deadline.checkTimeout();
            }
            queryText = "delete from " + this.SKEWED_COL_NAMES + " where \"SD_ID\" in (" + sdIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from " + this.SDS + " where \"SD_ID\" in (" + sdIds + ")";
            this.executeNoResult(queryText);
        }
        catch (SQLException sqlException) {
            LOG.warn("SQL error executing query while dropping storage descriptor.", (Throwable)sqlException);
            throw new MetaException("Encountered error while dropping storage descriptor.");
        }
    }

    private void dropSerdes(List<Object> serdeIdList) throws MetaException {
        if (serdeIdList.isEmpty()) {
            return;
        }
        String serdeIds = MetaStoreDirectSql.getIdListForIn(serdeIdList);
        try {
            String queryText = "delete from " + this.SERDE_PARAMS + " where \"SERDE_ID\" in (" + serdeIds + ")";
            this.executeNoResult(queryText);
            Deadline.checkTimeout();
            queryText = "delete from " + this.SERDES + " where \"SERDE_ID\" in (" + serdeIds + ")";
            this.executeNoResult(queryText);
        }
        catch (SQLException sqlException) {
            LOG.warn("SQL error executing query while dropping serde.", (Throwable)sqlException);
            throw new MetaException("Encountered error while dropping serde.");
        }
    }

    private void dropDanglingColumnDescriptors(List<Long> columnDescriptorIdList) throws MetaException {
        if (columnDescriptorIdList.isEmpty()) {
            return;
        }
        String colIds = MetaStoreDirectSql.getIdListForIn(columnDescriptorIdList);
        String queryText = "SELECT " + this.SDS + ".\"CD_ID\" from " + this.SDS + " WHERE " + this.SDS + ".\"CD_ID\" in (" + colIds + ") GROUP BY " + this.SDS + ".\"CD_ID\"";
        HashSet<Long> danglingColumnDescriptorIdSet = new HashSet<Long>(columnDescriptorIdList);
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            List sqlResult = (List)this.executeWithArray(query.getInnerQuery(), null, queryText);
            if (!sqlResult.isEmpty()) {
                for (Object cdId : sqlResult) {
                    danglingColumnDescriptorIdSet.remove(MetastoreDirectSqlUtils.extractSqlLong(cdId));
                }
            }
        }
        if (!danglingColumnDescriptorIdSet.isEmpty()) {
            try {
                String danglingCDIds = MetaStoreDirectSql.getIdListForIn(danglingColumnDescriptorIdSet);
                queryText = "delete from " + this.COLUMNS_V2 + " where \"CD_ID\" in (" + danglingCDIds + ")";
                this.executeNoResult(queryText);
                Deadline.checkTimeout();
                queryText = "delete from " + this.CDS + " where \"CD_ID\" in (" + danglingCDIds + ")";
                this.executeNoResult(queryText);
            }
            catch (SQLException sqlException) {
                LOG.warn("SQL error executing query while dropping dangling col descriptions", (Throwable)sqlException);
                throw new MetaException("Encountered error while dropping col descriptions");
            }
        }
    }

    public List<org.apache.hadoop.hive.common.TableName> getTableNamesWithStats() throws MetaException {
        String queryText0 = "SELECT DISTINCT " + this.TBLS + ".\"TBL_NAME\", " + this.DBS + ".\"NAME\", " + this.DBS + ".\"CTLG_NAME\" FROM " + this.TBLS + " INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\"";
        String queryText1 = " WHERE " + this.TBLS + ".\"TBL_TYPE\" IN (" + this.makeParams(STATS_TABLE_TYPES.length) + ")";
        ArrayList<org.apache.hadoop.hive.common.TableName> result = new ArrayList<org.apache.hadoop.hive.common.TableName>();
        String queryText = queryText0 + " INNER JOIN " + this.TAB_COL_STATS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.TAB_COL_STATS + ".\"TBL_ID\"" + queryText1;
        this.getStatsTableListResult(queryText, result);
        queryText = queryText0 + " INNER JOIN " + this.PARTITIONS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITIONS + ".\"TBL_ID\" INNER JOIN " + this.PART_COL_STATS + " ON " + this.PARTITIONS + ".\"PART_ID\" = " + this.PART_COL_STATS + ".\"PART_ID\"" + queryText1;
        this.getStatsTableListResult(queryText, result);
        return result;
    }

    public Map<String, List<String>> getColAndPartNamesWithStats(String catName, String dbName, String tableName) throws MetaException {
        String queryText = "SELECT DISTINCT " + this.PARTITIONS + ".\"PART_NAME\", " + this.PART_COL_STATS + ".\"COLUMN_NAME\" FROM " + this.TBLS + " INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" INNER JOIN " + this.PARTITIONS + " ON " + this.TBLS + ".\"TBL_ID\" = " + this.PARTITIONS + ".\"TBL_ID\"  INNER JOIN " + this.PART_COL_STATS + " ON " + this.PARTITIONS + ".\"PART_ID\" = " + this.PART_COL_STATS + ".\"PART_ID\" WHERE " + this.DBS + ".\"NAME\" = ? AND " + this.DBS + ".\"CTLG_NAME\" = ? AND " + this.TBLS + ".\"TBL_NAME\" = ? ORDER BY " + this.PARTITIONS + ".\"PART_NAME\"";
        LOG.debug("Running {}", (Object)queryText);
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            List<Object[]> sqlResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(query.getInnerQuery(), new Object[]{dbName, catName, tableName}, queryText));
            HashMap result = new HashMap();
            String lastPartName = null;
            ArrayList<String> cols = null;
            for (Object[] line : sqlResult) {
                String col = MetastoreDirectSqlUtils.extractSqlString(line[1]);
                String part = MetastoreDirectSqlUtils.extractSqlString(line[0]);
                if (!part.equals(lastPartName)) {
                    if (lastPartName != null) {
                        result.put(lastPartName, cols);
                    }
                    cols = cols == null ? new ArrayList<String>() : new ArrayList(cols.size());
                    lastPartName = part;
                }
                cols.add(col);
            }
            if (lastPartName != null) {
                result.put(lastPartName, cols);
            }
            HashMap hashMap = result;
            return hashMap;
        }
    }

    public List<org.apache.hadoop.hive.common.TableName> getAllTableNamesForStats() throws MetaException {
        String queryText = "SELECT " + this.TBLS + ".\"TBL_NAME\", " + this.DBS + ".\"NAME\", " + this.DBS + ".\"CTLG_NAME\" FROM " + this.TBLS + " INNER JOIN " + this.DBS + " ON " + this.TBLS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" WHERE " + this.TBLS + ".\"TBL_TYPE\" IN (" + this.makeParams(STATS_TABLE_TYPES.length) + ")";
        ArrayList<org.apache.hadoop.hive.common.TableName> result = new ArrayList<org.apache.hadoop.hive.common.TableName>();
        this.getStatsTableListResult(queryText, result);
        return result;
    }

    private void getStatsTableListResult(String queryText, List<org.apache.hadoop.hive.common.TableName> result) throws MetaException {
        LOG.debug("Running {}", (Object)queryText);
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            List<Object[]> sqlResult = MetastoreDirectSqlUtils.ensureList(this.executeWithArray(query.getInnerQuery(), STATS_TABLE_TYPES, queryText));
            for (Object[] line : sqlResult) {
                result.add(new org.apache.hadoop.hive.common.TableName(MetastoreDirectSqlUtils.extractSqlString(line[2]), MetastoreDirectSqlUtils.extractSqlString(line[1]), MetastoreDirectSqlUtils.extractSqlString(line[0])));
            }
        }
    }

    public void lockDbTable(String tableName) throws MetaException {
        if (!ALLOWED_TABLES_TO_LOCK.contains(tableName)) {
            throw new MetaException("Error while locking table " + tableName);
        }
        String lockCommand = "lock table \"" + tableName + "\" in exclusive mode";
        try {
            this.executeNoResult(lockCommand);
        }
        catch (SQLException sqle) {
            throw new MetaException("Error while locking table " + tableName + ": " + sqle.getMessage());
        }
    }

    public void deleteColumnStatsState(long tbl_id) throws MetaException {
        String queryText = switch (DatabaseProduct.dbType) {
            case DatabaseProduct.DbType.MYSQL -> "delete pp from " + this.PARTITION_PARAMS + " pp, " + this.PARTITIONS + " p where   p.\"PART_ID\" = pp.\"PART_ID\" AND   p.\"TBL_ID\" = " + tbl_id + "  and \"PARAM_KEY\" = 'COLUMN_STATS_ACCURATE'";
            default -> "delete from " + this.PARTITION_PARAMS + " where   \"PART_ID\" in (select p.\"PART_ID\"  from " + this.PARTITIONS + " p where   p.\"TBL_ID\" =  " + tbl_id + ")  and \"PARAM_KEY\" = 'COLUMN_STATS_ACCURATE'";
        };
        try {
            this.executeNoResult(queryText);
        }
        catch (SQLException e) {
            throw new MetaException("Error removing column stat states:" + e.getMessage());
        }
    }

    public boolean deleteTableColumnStatistics(long tableId, List<String> colNames, String engine) {
        String deleteSql = "delete from " + this.TAB_COL_STATS + " where \"TBL_ID\" = ?";
        ArrayList<Object> params = new ArrayList<Object>(colNames == null ? 2 : colNames.size() + 2);
        params.add(tableId);
        if (colNames != null && !colNames.isEmpty()) {
            deleteSql = deleteSql + " and \"COLUMN_NAME\" in (" + this.makeParams(colNames.size()) + ")";
            params.addAll(colNames);
        }
        if (engine != null) {
            deleteSql = deleteSql + " and \"ENGINE\" = ?";
            params.add(engine);
        }
        try (QueryWrapper queryParams = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)deleteSql));){
            this.executeWithArray(queryParams.getInnerQuery(), params.toArray(), deleteSql);
        }
        catch (MetaException e) {
            return false;
        }
        return true;
    }

    public boolean deletePartitionColumnStats(final String catName, final String dbName, final String tblName, List<String> partNames, final List<String> colNames, final String engine) throws MetaException {
        Batchable.runBatched(this.batchSize, partNames, new Batchable<String, Void>(){

            @Override
            public List<Void> run(List<String> input) throws Exception {
                String sqlFilter = MetaStoreDirectSql.this.PARTITIONS + ".\"PART_NAME\" in  (" + MetaStoreDirectSql.this.makeParams(input.size()) + ")";
                List<Long> partitionIds = MetaStoreDirectSql.this.getPartitionIdsViaSqlFilter(catName, dbName, tblName, sqlFilter, input, Collections.emptyList(), -1);
                if (!partitionIds.isEmpty()) {
                    String deleteSql = "delete from " + MetaStoreDirectSql.this.PART_COL_STATS + " where \"PART_ID\" in ( " + MetaStoreDirectSql.getIdListForIn(partitionIds) + ")";
                    ArrayList<String> params = new ArrayList<String>(colNames == null ? 1 : colNames.size() + 1);
                    if (colNames != null && !colNames.isEmpty()) {
                        deleteSql = deleteSql + " and \"COLUMN_NAME\" in (" + MetaStoreDirectSql.this.makeParams(colNames.size()) + ")";
                        params.addAll(colNames);
                    }
                    if (engine != null) {
                        deleteSql = deleteSql + " and \"ENGINE\" = ?";
                        params.add(engine);
                    }
                    try (QueryWrapper queryParams = new QueryWrapper(MetaStoreDirectSql.this.pm.newQuery("javax.jdo.query.SQL", (Object)deleteSql));){
                        MetaStoreDirectSql.this.executeWithArray(queryParams.getInnerQuery(), params.toArray(), deleteSql);
                    }
                }
                return null;
            }
        });
        return true;
    }

    public Map<String, Map<String, String>> updatePartitionColumnStatisticsBatch(Map<String, ColumnStatistics> partColStatsMap, Table tbl, List<TransactionalMetaStoreEventListener> listeners, String validWriteIds, long writeId) throws MetaException {
        return this.directSqlUpdatePart.updatePartitionColumnStatistics(partColStatsMap, tbl, validWriteIds, writeId, listeners);
    }

    public List<Function> getFunctions(final String catName) throws MetaException {
        List<Long> funcIds = this.getFunctionIds(catName);
        if (funcIds.isEmpty()) {
            return Collections.emptyList();
        }
        return Batchable.runBatched(this.batchSize, funcIds, new Batchable<Long, Function>(){

            @Override
            public List<Function> run(List<Long> input) throws MetaException {
                return MetaStoreDirectSql.this.getFunctionsFromFunctionIds(input, catName);
            }
        });
    }

    private List<Function> getFunctionsFromFunctionIds(List<Long> funcIdList, String catName) throws MetaException {
        String funcIds = MetaStoreDirectSql.getIdListForIn(funcIdList);
        boolean funcIdIndex = false;
        boolean funcNameIndex = true;
        int dbNameIndex = 2;
        int funcClassNameIndex = 3;
        int funcOwnerNameIndex = 4;
        int funcOwnerTypeIndex = 5;
        int funcCreateTimeIndex = 6;
        int funcTypeIndex = 7;
        String queryText = "SELECT " + this.FUNCS + ".\"FUNC_ID\", " + this.FUNCS + ".\"FUNC_NAME\", " + this.DBS + ".\"NAME\", " + this.FUNCS + ".\"CLASS_NAME\", " + this.FUNCS + ".\"OWNER_NAME\", " + this.FUNCS + ".\"OWNER_TYPE\", " + this.FUNCS + ".\"CREATE_TIME\", " + this.FUNCS + ".\"FUNC_TYPE\" FROM " + this.FUNCS + " LEFT JOIN " + this.DBS + " ON " + this.FUNCS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" where " + this.FUNCS + ".\"FUNC_ID\" in (" + funcIds + ") order by " + this.FUNCS + ".\"FUNC_NAME\" asc";
        ArrayList<Function> results = new ArrayList<Function>();
        TreeMap<Long, Function> funcs = new TreeMap<Long, Function>();
        boolean doTrace = LOG.isDebugEnabled();
        long start = doTrace ? System.nanoTime() : 0L;
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            List queryResult = (List)this.executeWithArray(query.getInnerQuery(), null, queryText);
            long end = doTrace ? System.nanoTime() : 0L;
            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, end);
            for (Object[] function : queryResult) {
                Long funcId = MetastoreDirectSqlUtils.extractSqlLong(function[0]);
                String funcName = MetastoreDirectSqlUtils.extractSqlString(function[1]);
                String dbName = MetastoreDirectSqlUtils.extractSqlString(function[2]);
                String funcClassName = MetastoreDirectSqlUtils.extractSqlString(function[3]);
                String funcOwnerName = MetastoreDirectSqlUtils.extractSqlString(function[4]);
                String funcOwnerType = MetastoreDirectSqlUtils.extractSqlString(function[5]);
                int funcCreateTime = MetastoreDirectSqlUtils.extractSqlInt(function[6]);
                int funcType = MetastoreDirectSqlUtils.extractSqlInt(function[7]);
                Function func = new Function();
                func.setFunctionName(funcName);
                func.setDbName(dbName);
                func.setCatName(catName);
                func.setClassName(funcClassName);
                func.setOwnerName(funcOwnerName);
                func.setOwnerType(PrincipalType.valueOf((String)funcOwnerType));
                func.setCreateTime(funcCreateTime);
                func.setFunctionType(FunctionType.findByValue((int)funcType));
                func.setResourceUris(new ArrayList());
                results.add(func);
                funcs.put(funcId, func);
            }
        }
        MetastoreDirectSqlUtils.setFunctionResourceUris(this.FUNC_RU, this.pm, funcIds, funcs);
        return results;
    }

    private List<Long> getFunctionIds(String catName) throws MetaException {
        boolean doTrace = LOG.isDebugEnabled();
        String queryText = "select " + this.FUNCS + ".\"FUNC_ID\" from " + this.FUNCS + " LEFT JOIN " + this.DBS + " ON " + this.FUNCS + ".\"DB_ID\" = " + this.DBS + ".\"DB_ID\" where " + this.DBS + ".\"CTLG_NAME\" = ? ";
        long start = doTrace ? System.nanoTime() : 0L;
        Object[] params = new Object[]{catName};
        try (QueryWrapper query = new QueryWrapper(this.pm.newQuery("javax.jdo.query.SQL", (Object)queryText));){
            List<Long> result;
            List sqlResult = (List)this.executeWithArray(query.getInnerQuery(), params, queryText);
            long queryTime = doTrace ? System.nanoTime() : 0L;
            MetastoreDirectSqlUtils.timingTrace(doTrace, queryText, start, queryTime);
            if (sqlResult.isEmpty()) {
                result = Collections.emptyList();
            } else {
                result = new ArrayList(sqlResult.size());
                for (Object fields : sqlResult) {
                    result.add(MetastoreDirectSqlUtils.extractSqlLong(fields));
                }
            }
            List<Long> list = result;
            return list;
        }
    }

    long updateTableParam(Table table, String key, String expectedValue, String newValue) {
        String statement = TxnUtils.createUpdatePreparedStmt("\"TABLE_PARAMS\"", (List<String>)ImmutableList.of((Object)"\"PARAM_VALUE\""), (List<String>)ImmutableList.of((Object)"\"TBL_ID\"", (Object)"\"PARAM_KEY\"", (Object)this.dbType.toVarChar("\"PARAM_VALUE\"")));
        Query query = this.pm.newQuery("javax.jdo.query.SQL", (Object)statement);
        return (Long)query.executeWithArray(new Object[]{newValue, table.getId(), key, expectedValue});
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface TableName {
    }

    public static class SqlFilterForPushdown {
        private final List<Object> params = new ArrayList<Object>();
        private final List<String> joins = new ArrayList<String>();
        private String filter;
        private String catName;
        private String dbName;
        private String tableName;
        private boolean compactJoins = true;

        SqlFilterForPushdown() {
        }

        SqlFilterForPushdown(Table table, boolean compactJoins) {
            this.catName = table.getCatName();
            this.dbName = table.getDbName();
            this.tableName = table.getTableName();
            this.compactJoins = compactJoins;
        }
    }

    private static class PartitionFilterGenerator
    extends ExpressionTree.TreeVisitor {
        private final String catName;
        private final String dbName;
        private final String tableName;
        private final List<FieldSchema> partitionKeys;
        private final ExpressionTree.FilterBuilder filterBuffer;
        private final List<Object> params;
        private final List<String> joins;
        private final boolean dbHasJoinCastBug;
        private final String defaultPartName;
        private final DatabaseProduct dbType;
        private final String PARTITION_KEY_VALS;
        private final String PARTITIONS;
        private final String DBS;
        private final String TBLS;

        private PartitionFilterGenerator(String catName, String dbName, String tableName, List<FieldSchema> partitionKeys, List<Object> params, List<String> joins, boolean dbHasJoinCastBug, String defaultPartName, DatabaseProduct dbType, String schema) {
            this.catName = catName;
            this.dbName = dbName;
            this.tableName = tableName;
            this.partitionKeys = partitionKeys;
            this.params = params;
            this.joins = joins;
            this.dbHasJoinCastBug = dbHasJoinCastBug;
            this.filterBuffer = new ExpressionTree.FilterBuilder(false);
            this.defaultPartName = defaultPartName;
            this.dbType = dbType;
            this.PARTITION_KEY_VALS = MetaStoreDirectSql.getFullyQualifiedName(schema, "PARTITION_KEY_VALS");
            this.PARTITIONS = MetaStoreDirectSql.getFullyQualifiedName(schema, "PARTITIONS");
            this.DBS = MetaStoreDirectSql.getFullyQualifiedName(schema, "DBS");
            this.TBLS = MetaStoreDirectSql.getFullyQualifiedName(schema, "TBLS");
        }

        private static String generateSqlFilter(String catName, String dbName, String tableName, List<FieldSchema> partitionKeys, ExpressionTree tree, List<Object> params, List<String> joins, boolean dbHasJoinCastBug, String defaultPartName, DatabaseProduct dbType, String schema, boolean compactJoins) throws MetaException {
            if (tree == null) {
                return null;
            }
            if (tree.getRoot() == null) {
                return "";
            }
            PartitionFilterGenerator visitor = new PartitionFilterGenerator(catName, dbName, tableName, partitionKeys, params, joins, dbHasJoinCastBug, defaultPartName, dbType, schema);
            tree.accept(visitor);
            if (visitor.filterBuffer.hasError()) {
                LOG.info("Unable to push down SQL filter: " + visitor.filterBuffer.getErrorMessage());
                return null;
            }
            if (compactJoins) {
                for (int i = 0; i < joins.size(); ++i) {
                    if (joins.get(i) != null) continue;
                    joins.remove(i--);
                }
            }
            return "(" + visitor.filterBuffer.getFilter() + ")";
        }

        @Override
        protected void beginTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(" (");
        }

        @Override
        protected void midTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(node.getAndOr() == ExpressionTree.LogicalOperator.AND ? " and " : " or ");
        }

        @Override
        protected void endTreeNode(ExpressionTree.TreeNode node) throws MetaException {
            this.filterBuffer.append(") ");
        }

        @Override
        protected boolean shouldStop() {
            return this.filterBuffer.hasError();
        }

        @Override
        public void visit(ExpressionTree.LeafNode node) throws MetaException {
            boolean isDefaultPartition;
            int partColCount = this.partitionKeys.size();
            int partColIndex = ExpressionTree.LeafNode.getPartColIndexForFilter(node.keyName, this.partitionKeys, this.filterBuffer);
            if (this.filterBuffer.hasError()) {
                return;
            }
            FieldSchema partCol = this.partitionKeys.get(partColIndex);
            String colTypeStr = ColumnType.getTypeName((String)partCol.getType());
            FilterType colType = FilterType.fromType(colTypeStr);
            if (colType == FilterType.Invalid) {
                this.filterBuffer.setError("Filter pushdown not supported for type " + colTypeStr);
                return;
            }
            FilterType valType = FilterType.fromClass(node.value);
            Object nodeValue = node.value;
            if (valType == FilterType.Invalid) {
                this.filterBuffer.setError("Filter pushdown not supported for value " + String.valueOf(node.value.getClass()));
                return;
            }
            Object nodeValue0 = "?";
            if (colType == FilterType.Date) {
                try {
                    nodeValue = MetaStoreUtils.normalizeDate((String)((String)nodeValue));
                    valType = FilterType.Date;
                    if (this.dbType.isPOSTGRES() || this.dbType.isORACLE()) {
                        nodeValue0 = "date '" + String.valueOf(nodeValue) + "'";
                        nodeValue = null;
                    }
                }
                catch (Exception exception) {}
            } else if (colType == FilterType.Timestamp) {
                if (this.dbType.isDERBY() || this.dbType.isMYSQL()) {
                    this.filterBuffer.setError("Filter pushdown on timestamp not supported for " + String.valueOf((Object)DatabaseProduct.dbType));
                    return;
                }
                try {
                    MetaStoreUtils.convertStringToTimestamp((String)((String)nodeValue));
                    valType = FilterType.Timestamp;
                    if (this.dbType.isPOSTGRES() || this.dbType.isORACLE()) {
                        nodeValue0 = "timestamp '" + String.valueOf(nodeValue) + "'";
                        nodeValue = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean bl = isDefaultPartition = valType == FilterType.String && this.defaultPartName.equals(nodeValue);
            if (colType != valType && !isDefaultPartition) {
                this.filterBuffer.setError("Cannot push down filter for " + colTypeStr + " column and value " + String.valueOf(nodeValue.getClass()));
                return;
            }
            if (this.joins.isEmpty()) {
                for (int i = 0; i < partColCount; ++i) {
                    this.joins.add(null);
                }
            }
            if (this.joins.get(partColIndex) == null) {
                this.joins.set(partColIndex, "inner join " + this.PARTITION_KEY_VALS + " \"FILTER" + partColIndex + "\" on \"FILTER" + partColIndex + "\".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" and \"FILTER" + partColIndex + "\".\"INTEGER_IDX\" = " + partColIndex);
            }
            Object tableValue = "\"FILTER" + partColIndex + "\".\"PART_KEY_VAL\"";
            if (node.isReverseOrder && nodeValue != null) {
                this.params.add(nodeValue);
            }
            String tableColumn = tableValue;
            if (colType != FilterType.String && !isDefaultPartition) {
                if (colType == FilterType.Integral) {
                    tableValue = "cast(" + (String)tableValue + " as decimal(21,0))";
                } else if (colType == FilterType.Date) {
                    tableValue = this.dbType.toDate((String)tableValue);
                } else if (colType == FilterType.Timestamp) {
                    tableValue = this.dbType.toTimestamp((String)tableValue);
                }
                String tableValue0 = tableValue;
                tableValue = "(case when " + tableColumn + " <> ?";
                this.params.add(this.defaultPartName);
                if (this.dbHasJoinCastBug) {
                    tableValue = (String)tableValue + " and " + this.TBLS + ".\"TBL_NAME\" = ? and " + this.DBS + ".\"NAME\" = ? and " + this.DBS + ".\"CTLG_NAME\" = ? and \"FILTER" + partColIndex + "\".\"PART_ID\" = " + this.PARTITIONS + ".\"PART_ID\" and \"FILTER" + partColIndex + "\".\"INTEGER_IDX\" = " + partColIndex;
                    this.params.add(this.tableName.toLowerCase());
                    this.params.add(this.dbName.toLowerCase());
                    this.params.add(this.catName.toLowerCase());
                }
                tableValue = (String)tableValue + " then " + tableValue0 + " else null end)";
            }
            if (!node.isReverseOrder && nodeValue != null) {
                this.params.add(nodeValue);
            }
            if (node.operator == ExpressionTree.Operator.LIKE) {
                nodeValue0 = (String)nodeValue0 + " ESCAPE '\\' ";
            }
            String filter = node.isReverseOrder ? (String)nodeValue0 + " " + node.operator.getSqlOp() + " " + (String)tableValue : (String)tableValue + " " + node.operator.getSqlOp() + " " + (String)nodeValue0;
            boolean isOpEquals = ExpressionTree.Operator.isEqualOperator(node.operator);
            boolean isOpNotEqual = ExpressionTree.Operator.isNotEqualOperator(node.operator);
            String nodeValueStr = node.value.toString();
            if (StringUtils.isNotEmpty((CharSequence)nodeValueStr) && (isOpEquals || isOpNotEqual)) {
                HashMap<String, String> partKeyToVal = new HashMap<String, String>();
                partKeyToVal.put(partCol.getName(), nodeValueStr);
                Object escapedNameFragment = Warehouse.makePartName(partKeyToVal, (boolean)false);
                if (colType == FilterType.Date) {
                    escapedNameFragment = (String)escapedNameFragment + "%";
                }
                if (colType != FilterType.Date && partColCount == 1) {
                    this.params.add(escapedNameFragment);
                    filter = filter + " and " + this.PARTITIONS + ".\"PART_NAME\"" + (isOpEquals ? " =? " : " !=? ");
                } else {
                    if (partColCount == 1) {
                        this.params.add(escapedNameFragment);
                    } else if (partColIndex + 1 == partColCount) {
                        this.params.add("%/" + (String)escapedNameFragment);
                    } else if (partColIndex == 0) {
                        this.params.add((String)escapedNameFragment + "/%");
                    } else {
                        this.params.add("%/" + (String)escapedNameFragment + "/%");
                    }
                    filter = filter + " and " + this.PARTITIONS + ".\"PART_NAME\"" + (isOpEquals ? " like ? " : " not like ? ");
                }
            }
            this.filterBuffer.append("(" + filter + ")");
        }

        private static enum FilterType {
            Integral((Set<String>)ImmutableSet.of((Object)"tinyint", (Object)"smallint", (Object)"int", (Object)"bigint"), Long.class),
            String((Set<String>)ImmutableSet.of((Object)"string", (Object)"char", (Object)"varchar"), String.class),
            Date((Set<String>)ImmutableSet.of((Object)"date"), Date.class),
            Timestamp((Set<String>)ImmutableSet.of((Object)"timestamp"), Timestamp.class),
            Invalid(Collections.emptySet(), Void.class);

            private final Set<String> colTypes;
            private final Class<?> clazz;

            private FilterType(Set<String> colTypes, Class<?> clazz) {
                this.colTypes = colTypes;
                this.clazz = clazz;
            }

            public Set<String> getType() {
                return this.colTypes;
            }

            public Class<?> getClazz() {
                return this.clazz;
            }

            public static FilterType fromType(String colTypeStr) {
                for (FilterType filterType : FilterType.values()) {
                    if (!filterType.colTypes.contains(colTypeStr)) continue;
                    return filterType;
                }
                return Invalid;
            }

            public static FilterType fromClass(Object value) {
                for (FilterType filterType : FilterType.values()) {
                    if (!filterType.clazz.isInstance(value)) continue;
                    return filterType;
                }
                return Invalid;
            }
        }
    }
}

