/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.runtime.interop.JSMetaType;
import java.lang.invoke.MethodHandles;
import java.util.Objects;

@GeneratedBy(value=JSMetaType.class)
final class JSMetaTypeGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    private JSMetaTypeGen() {
    }

    static {
        LibraryExport.register(JSMetaType.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JSMetaType.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, JSMetaType.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSMetaType);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JSMetaType);
            return new Cached();
        }

        @GeneratedBy(value=JSMetaType.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JSMetaType) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof JSMetaType;
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMetaInstance(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSMetaType arg0Value = (JSMetaType)arg0Value_;
                return JSMetaType.IsMetaInstance.doGeneric(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSMetaType)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSMetaType)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSMetaType)receiver).isMetaObject();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSMetaType)receiver).getTypeName();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSMetaType)receiver).getTypeName();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSMetaType)receiver).toDisplayString(allowSideEffects);
            }
        }

        @GeneratedBy(value=JSMetaType.class)
        private static final class Cached
        extends InteropLibrary {
            static final InlineSupport.ReferenceField<CachedData> CACHED_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"cached_cache", CachedData.class);
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private CachedData cached_cache;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JSMetaType) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof JSMetaType;
            }

            @ExplodeLoop
            public boolean isMetaInstance(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSMetaType arg0Value = (JSMetaType)arg0Value_;
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0) {
                        CachedData s0_ = this.cached_cache;
                        while (s0_ != null) {
                            if (s0_.valueLib_.accepts(arg1Value) && arg0Value == s0_.cachedType_) {
                                return JSMetaType.IsMetaInstance.doCached(arg0Value, arg1Value, s0_.cachedType_, s0_.valueLib_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 2) != 0) {
                        return JSMetaType.IsMetaInstance.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private boolean executeAndSpecialize(JSMetaType arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 2) == 0) {
                    CachedData s0_;
                    block4: {
                        CachedData s0_original;
                        do {
                            int count0_ = 0;
                            s0_original = s0_ = (CachedData)((Object)CACHED_CACHE_UPDATER.getVolatile((Node)this));
                            while (!(s0_ == null || s0_.valueLib_.accepts(arg1Value) && arg0Value == s0_.cachedType_)) {
                                ++count0_;
                                s0_ = s0_.next_;
                            }
                            if (s0_ != null || count0_ >= 3) break block4;
                            s0_ = (CachedData)this.insert(new CachedData(s0_original));
                            s0_.cachedType_ = arg0Value;
                            InteropLibrary valueLib__ = (InteropLibrary)s0_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg1Value)));
                            Objects.requireNonNull(valueLib__, "Specialization 'doCached(JSMetaType, Object, JSMetaType, InteropLibrary)' cache 'valueLib' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s0_.valueLib_ = valueLib__;
                        } while (!CACHED_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s0_ != null) {
                        return JSMetaType.IsMetaInstance.doCached(arg0Value, arg1Value, s0_.cachedType_, s0_.valueLib_);
                    }
                }
                this.cached_cache = null;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                return JSMetaType.IsMetaInstance.doGeneric(arg0Value, arg1Value);
            }

            public NodeCost getCost() {
                CachedData s0_;
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0 && ((s0_ = this.cached_cache) == null || s0_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSMetaType)receiver).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSMetaType)receiver).getLanguage();
            }

            public boolean isMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSMetaType)receiver).isMetaObject();
            }

            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSMetaType)receiver).getTypeName();
            }

            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSMetaType)receiver).getTypeName();
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSMetaType)receiver).toDisplayString(allowSideEffects);
            }

            @GeneratedBy(value=JSMetaType.class)
            @DenyReplace
            private static final class CachedData
            extends Node {
                @Node.Child
                CachedData next_;
                @CompilerDirectives.CompilationFinal
                JSMetaType cachedType_;
                @Node.Child
                InteropLibrary valueLib_;

                CachedData(CachedData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }
        }
    }
}

